/*
 * Decompiled with CFR 0.152.
 */
package circlet.platform.client.arenas;

import circlet.platform.api.ARecord;
import circlet.platform.api.ArenasKt;
import circlet.platform.api.OptionalRecord;
import circlet.platform.client.ArenaPersistence;
import circlet.platform.client.ResolvedRecord;
import circlet.platform.client.arenas.Etag;
import circlet.platform.client.arenas.EtagUnknown;
import circlet.platform.client.arenas.OptimisticRecord;
import circlet.platform.client.arenas.Record;
import circlet.platform.client.circlet.platform.client.arenas.ClientFailureReason;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010/\u001a\b\u0012\u0004\u0012\u0002H100\"\b\b\u0000\u00101*\u000202J\u0016\u00103\u001a\b\u0012\u0004\u0012\u0002H104\"\b\b\u0000\u00101*\u000202J\u0006\u00105\u001a\u00020\u0007J\"\u00106\u001a\b\u0012\u0004\u0012\u0002H107\"\b\b\u0000\u00101*\u0002022\n\u00108\u001a\u00060\u0003j\u0002`%J+\u00109\u001a\u0004\u0018\u0001H1\"\b\b\u0000\u00101*\u0002022\n\u00108\u001a\u00060\u0003j\u0002`%2\u0006\u0010:\u001a\u00020\u0007\u00a2\u0006\u0002\u0010;J\u000e\u0010<\u001a\u00020\u00072\u0006\u00108\u001a\u00020\u0003J\u001f\u0010=\u001a\u00020>2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020A0@H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010BJ\u000e\u0010C\u001a\u00020>2\u0006\u0010D\u001a\u00020EJ\b\u0010F\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0012\"\u0004\b\u001b\u0010\u0014R\u001a\u0010\u001c\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001b\u0010#\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`%0$8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R!\u0010(\u001a\u0012\u0012\b\u0012\u00060\u0003j\u0002`%\u0012\u0004\u0012\u00020*0)\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u000e\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006G"}, d2={"Lcirclet/platform/client/arenas/ClientArenaRecordsCache;", "", "arenaId", "", "persistence", "Lcirclet/platform/client/ArenaPersistence;", "exceptArchived", "", "(Ljava/lang/String;Lcirclet/platform/client/ArenaPersistence;Ljava/lang/Boolean;)V", "getArenaId", "()Ljava/lang/String;", "checksum", "", "getChecksum", "()I", "etag", "Lcirclet/platform/client/arenas/Etag;", "getEtag", "()Lcirclet/platform/client/arenas/Etag;", "setEtag", "(Lcirclet/platform/client/arenas/Etag;)V", "etagFullyLoaded", "getEtagFullyLoaded", "setEtagFullyLoaded", "Ljava/lang/Boolean;", "hasAllUpdatesFromEtag", "getHasAllUpdatesFromEtag", "setHasAllUpdatesFromEtag", "loadedFully", "getLoadedFully", "()Z", "setLoadedFully", "(Z)V", "getPersistence", "()Lcirclet/platform/client/ArenaPersistence;", "recordIds", "", "Lcirclet/platform/api/TID;", "getRecordIds", "()Ljava/util/Set;", "records", "", "Lcirclet/platform/client/arenas/Record;", "getRecords", "()Ljava/util/Map;", "size", "getSize", "allRecords", "Lkotlin/sequences/Sequence;", "T", "Lcirclet/platform/api/ARecord;", "allRecordsList", "", "hasOptimisticUpdates", "lookupOptionalRef", "Lcirclet/platform/api/OptionalRecord;", "id", "lookupRef", "acceptUnresolved", "(Ljava/lang/String;Z)Lcirclet/platform/api/ARecord;", "needResolve", "persistUpdates", "", "actual", "", "Lcirclet/platform/client/ResolvedRecord;", "(Ljava/util/Collection;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "putOptimisticRecord", "optimistic", "Lcirclet/platform/client/arenas/OptimisticRecord;", "toString", "platform-client"})
@SourceDebugExtension(value={"SMAP\nClientArenaRecordsCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientArenaRecordsCache.kt\ncirclet/platform/client/arenas/ClientArenaRecordsCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n1603#2,9:119\n1855#2:128\n1856#2:130\n1612#2:131\n1774#2,4:132\n1603#2,9:136\n1855#2:145\n1856#2:147\n1612#2:148\n1603#2,9:149\n1855#2:158\n1856#2:160\n1612#2:161\n1747#2,3:163\n1#3:129\n1#3:146\n1#3:159\n1#3:162\n*S KotlinDebug\n*F\n+ 1 ClientArenaRecordsCache.kt\ncirclet/platform/client/arenas/ClientArenaRecordsCache\n*L\n23#1:119,9\n23#1:128\n23#1:130\n23#1:131\n23#1:132,4\n28#1:136,9\n28#1:145\n28#1:147\n28#1:148\n30#1:149,9\n30#1:158\n30#1:160\n30#1:161\n48#1:163,3\n23#1:129\n28#1:146\n30#1:159\n*E\n"})
public final class ClientArenaRecordsCache {
    @NotNull
    private final String arenaId;
    @Nullable
    private final ArenaPersistence persistence;
    @Nullable
    private final Boolean exceptArchived;
    @NotNull
    private final Map<String, Record> records;
    @NotNull
    private Etag etag;
    @NotNull
    private Etag etagFullyLoaded;
    @Nullable
    private Etag hasAllUpdatesFromEtag;
    private boolean loadedFully;

    public ClientArenaRecordsCache(@NotNull String arenaId, @Nullable ArenaPersistence persistence2, @Nullable Boolean exceptArchived2) {
        Intrinsics.checkNotNullParameter((Object)arenaId, (String)"arenaId");
        this.arenaId = arenaId;
        this.persistence = persistence2;
        this.exceptArchived = exceptArchived2;
        this.records = new LinkedHashMap();
        this.etag = EtagUnknown.INSTANCE;
        this.etagFullyLoaded = EtagUnknown.INSTANCE;
    }

    @NotNull
    public final String getArenaId() {
        return this.arenaId;
    }

    @Nullable
    public final ArenaPersistence getPersistence() {
        return this.persistence;
    }

    @NotNull
    public final Map<String, Record> getRecords() {
        return this.records;
    }

    @NotNull
    public final Etag getEtag() {
        return this.etag;
    }

    public final void setEtag(@NotNull Etag etag) {
        Intrinsics.checkNotNullParameter((Object)etag, (String)"<set-?>");
        this.etag = etag;
    }

    @NotNull
    public final Etag getEtagFullyLoaded() {
        return this.etagFullyLoaded;
    }

    public final void setEtagFullyLoaded(@NotNull Etag etag) {
        Intrinsics.checkNotNullParameter((Object)etag, (String)"<set-?>");
        this.etagFullyLoaded = etag;
    }

    @Nullable
    public final Etag getHasAllUpdatesFromEtag() {
        return this.hasAllUpdatesFromEtag;
    }

    public final void setHasAllUpdatesFromEtag(@Nullable Etag etag) {
        this.hasAllUpdatesFromEtag = etag;
    }

    public final boolean getLoadedFully() {
        return this.loadedFully;
    }

    public final void setLoadedFully(boolean bl) {
        this.loadedFully = bl;
    }

    /*
     * WARNING - void declaration
     */
    public final int getSize() {
        int n;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.records.values();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ARecord it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Record it = (Record)element$iv$iv;
            boolean bl2 = false;
            if (Record.value$default(it, false, 1, null) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$count$iv = (List)destination$iv$iv;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_4;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                ARecord it = (ARecord)element$iv;
                boolean bl = false;
                if (!(!it.getArchived()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_4;
        }
        return n;
    }

    @NotNull
    public final Set<String> getRecordIds() {
        return this.records.keySet();
    }

    private final int getChecksum() {
        return this.records.size();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T extends ARecord> Sequence<T> allRecords() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.records.values();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ARecord it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Record it = (Record)element$iv$iv;
            boolean bl2 = false;
            if (Record.value$default(it, false, 1, null) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Sequence sequence = CollectionsKt.asSequence((Iterable)((List)destination$iv$iv));
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<T of circlet.platform.client.arenas.ClientArenaRecordsCache.allRecords>");
        return sequence;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T extends ARecord> List<T> allRecordsList() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.records.values();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ARecord it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Record it = (Record)element$iv$iv;
            boolean bl2 = false;
            if (Record.value$default(it, false, 1, null) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final <T extends ARecord> T lookupRef(@NotNull String id2, boolean acceptUnresolved) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Record record2 = this.records.get(id2);
        return (T)(record2 != null ? record2.value(acceptUnresolved) : null);
    }

    @NotNull
    public final <T extends ARecord> OptionalRecord<T> lookupOptionalRef(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Object object = this.records.get(id2);
        if (object == null || (object = ((Record)object).optValue(this.arenaId, id2)) == null) {
            object = new OptionalRecord.Failed<Object>(this.arenaId, id2, null, new ClientFailureReason.RefNotFoundInCache(this.arenaId, id2));
        }
        return object;
    }

    public final void putOptimisticRecord(@NotNull OptimisticRecord optimistic) {
        Record oldRecord;
        Intrinsics.checkNotNullParameter((Object)optimistic, (String)"optimistic");
        if (!ArenasKt.isTemporary(optimistic.getRecord())) {
            String string2 = optimistic.getRecord().getTemporaryId();
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                this.records.remove(it);
            }
        }
        String key2 = optimistic.getRecord().getId();
        Record record2 = oldRecord = this.records.get(key2);
        this.records.put(key2, new Record(optimistic, record2 != null ? record2.getServer() : null));
    }

    public final boolean hasOptimisticUpdates() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.records.values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Record it = (Record)element$iv;
                    boolean bl2 = false;
                    if (!(it.getOptimistic() != null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean needResolve(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Record record2 = this.records.get(id2);
        return (record2 != null ? record2.getServer() : null) == null;
    }

    @Nullable
    public final Object persistUpdates(@NotNull Collection<ResolvedRecord> actual, @NotNull Continuation<? super Unit> $completion) {
        if (this.persistence != null && (!actual.isEmpty() || !this.persistence.isUpToDate(this.etag, this.etagFullyLoaded))) {
            Object object = this.persistence.persist(actual, this.etag, this.etagFullyLoaded, this.getChecksum(), this.exceptArchived, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @NotNull
    public String toString() {
        return StringsKt.trimIndent((String)("\n            etag = " + this.etag + ", size = " + this.getSize() + ",\n            etagFL = " + this.etagFullyLoaded + ",\n            hasAllUpdatesFromEtag = " + this.hasAllUpdatesFromEtag + ",\n            exceptArchived = " + this.exceptArchived + "\n        "));
    }
}

