/*
 * Decompiled with CFR 0.152.
 */
package circlet.platform.client.circlet.platform.client.arenas;

import circlet.platform.api.services.ArenaResponse;
import circlet.platform.api.services.ArenasFailureReason;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0006\u0007\b\t\n\u000b\fJ\u0014\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006H\u0016\u0082\u0001\u0006\r\u000e\u000f\u0010\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason;", "Lcirclet/platform/api/services/ArenasFailureReason;", "toResp", "Lcirclet/platform/api/services/ArenaResponse$Failed;", "arenaId", "", "Lcirclet/platform/api/ArenaId;", "ArenaNotFoundInCache", "Empty", "Exception", "NestedRefInTombstone", "NoServerResponse", "RefNotFoundInCache", "Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason$ArenaNotFoundInCache;", "Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason$Empty;", "Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason$Exception;", "Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason$NestedRefInTombstone;", "Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason$NoServerResponse;", "Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason$RefNotFoundInCache;", "platform-client"})
public interface ClientFailureReason
extends ArenasFailureReason {
    @NotNull
    public ArenaResponse.Failed toResp(@NotNull String var1);

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\u0003H\u0016R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason$ArenaNotFoundInCache;", "Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason;", "arenaId", "", "Lcirclet/platform/api/ArenaId;", "(Ljava/lang/String;)V", "getArenaId", "()Ljava/lang/String;", "print", "platform-client"})
    public static final class ArenaNotFoundInCache
    implements ClientFailureReason {
        @NotNull
        private final String arenaId;

        public ArenaNotFoundInCache(@NotNull String arenaId) {
            Intrinsics.checkNotNullParameter((Object)arenaId, (String)"arenaId");
            this.arenaId = arenaId;
        }

        @NotNull
        public final String getArenaId() {
            return this.arenaId;
        }

        @Override
        @NotNull
        public String print() {
            return "Arena " + this.arenaId + " is not found in cache";
        }

        @Override
        @NotNull
        public ArenaResponse.Failed toResp(@NotNull String arenaId) {
            return DefaultImpls.toResp(this, arenaId);
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static ArenaResponse.Failed toResp(@NotNull ClientFailureReason $this, @NotNull String arenaId) {
            Intrinsics.checkNotNullParameter((Object)arenaId, (String)"arenaId");
            return new ArenaResponse.Failed(arenaId, $this);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason$Empty;", "Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason;", "()V", "print", "", "platform-client"})
    public static final class Empty
    implements ClientFailureReason {
        @NotNull
        public static final Empty INSTANCE = new Empty();

        private Empty() {
        }

        @Override
        @NotNull
        public String print() {
            return "Unresolved record with empty failure reason: the possible cause - server has older version than client.";
        }

        @Override
        @NotNull
        public ArenaResponse.Failed toResp(@NotNull String arenaId) {
            return DefaultImpls.toResp(this, arenaId);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0003H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason$Exception;", "Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason;", "error", "", "(Ljava/lang/String;)V", "getError", "()Ljava/lang/String;", "print", "platform-client"})
    public static final class Exception
    implements ClientFailureReason {
        @Nullable
        private final String error;

        public Exception(@Nullable String error2) {
            this.error = error2;
        }

        @Nullable
        public final String getError() {
            return this.error;
        }

        @Override
        @NotNull
        public String print() {
            String string2 = this.error;
            if (string2 == null) {
                string2 = "unknown";
            }
            return string2;
        }

        @Override
        @NotNull
        public ArenaResponse.Failed toResp(@NotNull String arenaId) {
            return DefaultImpls.toResp(this, arenaId);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason$NestedRefInTombstone;", "Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason;", "containerSelector", "", "(Ljava/lang/String;)V", "print", "platform-client"})
    public static final class NestedRefInTombstone
    implements ClientFailureReason {
        @NotNull
        private final String containerSelector;

        public NestedRefInTombstone(@NotNull String containerSelector) {
            Intrinsics.checkNotNullParameter((Object)containerSelector, (String)"containerSelector");
            this.containerSelector = containerSelector;
        }

        @Override
        @NotNull
        public String print() {
            return "Unresolved(TS) ref is from other tombstone record " + this.containerSelector;
        }

        @Override
        @NotNull
        public ArenaResponse.Failed toResp(@NotNull String arenaId) {
            return DefaultImpls.toResp(this, arenaId);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason$NoServerResponse;", "Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason;", "method", "", "(Ljava/lang/String;)V", "getMethod", "()Ljava/lang/String;", "print", "platform-client"})
    public static final class NoServerResponse
    implements ClientFailureReason {
        @NotNull
        private final String method;

        public NoServerResponse(@NotNull String method) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            this.method = method;
        }

        @NotNull
        public final String getMethod() {
            return this.method;
        }

        @Override
        @NotNull
        public String print() {
            return "No response from server on calling " + this.method + ", should be investigated and fixed on server-side";
        }

        @Override
        @NotNull
        public ArenaResponse.Failed toResp(@NotNull String arenaId) {
            return DefaultImpls.toResp(this, arenaId);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001d\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0003j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000b\u001a\u00020\u0003H\u0016R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0005\u001a\u00060\u0003j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\f"}, d2={"Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason$RefNotFoundInCache;", "Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason;", "arenaId", "", "Lcirclet/platform/api/ArenaId;", "id", "Lcirclet/platform/api/TID;", "(Ljava/lang/String;Ljava/lang/String;)V", "getArenaId", "()Ljava/lang/String;", "getId", "print", "platform-client"})
    public static final class RefNotFoundInCache
    implements ClientFailureReason {
        @NotNull
        private final String arenaId;
        @NotNull
        private final String id;

        public RefNotFoundInCache(@NotNull String arenaId, @NotNull String id2) {
            Intrinsics.checkNotNullParameter((Object)arenaId, (String)"arenaId");
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            this.arenaId = arenaId;
            this.id = id2;
        }

        @NotNull
        public final String getArenaId() {
            return this.arenaId;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @Override
        @NotNull
        public String print() {
            return "Ref " + this.arenaId + "/" + this.id + " is not found in cache";
        }

        @Override
        @NotNull
        public ArenaResponse.Failed toResp(@NotNull String arenaId) {
            return DefaultImpls.toResp(this, arenaId);
        }
    }
}

