/*
 * Decompiled with CFR 0.152.
 */
package circlet.todo.remind;

import circlet.platform.api.ADateJvmKt;
import circlet.platform.api.KotlinXDate;
import circlet.platform.api.KotlinXDateTime;
import circlet.todo.TodoPostponeDateCalculator;
import circlet.todo.remind.RemindMeItemsProvider;
import circlet.todo.remind.TodoMoreMenuButtonItem;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lcirclet/todo/remind/RemindMeItemsProviderImpl;", "Lcirclet/todo/remind/RemindMeItemsProvider;", "()V", "getItems", "", "Lcirclet/todo/remind/TodoMoreMenuButtonItem;", "currentTime", "Lcirclet/platform/api/KotlinXDateTime;", "Lcirclet/platform/api/ADateTime;", "inTodo", "", "scheduled", "withDevTool", "app-state"})
public final class RemindMeItemsProviderImpl
implements RemindMeItemsProvider {
    @Override
    @NotNull
    public List<TodoMoreMenuButtonItem> getItems(@NotNull KotlinXDateTime currentTime, boolean inTodo, boolean scheduled, boolean withDevTool) {
        Intrinsics.checkNotNullParameter((Object)currentTime, (String)"currentTime");
        KotlinXDate tom = ADateJvmKt.toDate(ADateJvmKt.plusDays(currentTime, 1));
        KotlinXDate nextWeek = new TodoPostponeDateCalculator().nextWeek(ADateJvmKt.toDate(currentTime));
        Object[] objectArray = new TodoMoreMenuButtonItem[]{new TodoMoreMenuButtonItem.Action("In 20 minutes", null, ADateJvmKt.plusMinutes(currentTime, 20)), new TodoMoreMenuButtonItem.Action("In 1 hour", null, ADateJvmKt.plusHours(currentTime, 1)), new TodoMoreMenuButtonItem.Action("Tomorrow at 9:00", tom, ADateJvmKt.plusHours(ADateJvmKt.toDateTimeAtStartOfDay(tom), 9)), new TodoMoreMenuButtonItem.Action("Next week at 9:00", nextWeek, ADateJvmKt.plusHours(ADateJvmKt.toDateTimeAtStartOfDay(nextWeek), 9))};
        List res = CollectionsKt.mutableListOf((Object[])objectArray);
        if (withDevTool) {
            res.add(new TodoMoreMenuButtonItem.Action("In 1 minute", null, ADateJvmKt.plusSeconds(currentTime, 60)));
        }
        if (inTodo && scheduled) {
            res.add(TodoMoreMenuButtonItem.Separator.INSTANCE);
            res.add(TodoMoreMenuButtonItem.Remove.INSTANCE);
        }
        return res;
    }
}

