/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.changes;

import circlet.client.api.GitCommitChange;
import circlet.client.api.GitFile;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.space.vcs.changes.SpaceChangeKt;
import com.intellij.space.vcs.changes.SpaceRepository;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006#"}, d2={"Lcom/intellij/space/vcs/changes/SpaceChange;", "", "repository", "Lcom/intellij/space/vcs/changes/SpaceRepository;", "gitCommitChange", "Lcirclet/client/api/GitCommitChange;", "unreachable", "", "(Lcom/intellij/space/vcs/changes/SpaceRepository;Lcirclet/client/api/GitCommitChange;Z)V", "fileStatus", "Lcom/intellij/openapi/vcs/FileStatus;", "getFileStatus", "()Lcom/intellij/openapi/vcs/FileStatus;", "getGitCommitChange", "()Lcirclet/client/api/GitCommitChange;", "newFilePath", "Lcom/intellij/openapi/vcs/FilePath;", "getNewFilePath", "()Lcom/intellij/openapi/vcs/FilePath;", "oldFilePath", "getOldFilePath", "getRepository", "()Lcom/intellij/space/vcs/changes/SpaceRepository;", "getUnreachable", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.space.vcs"})
public final class SpaceChange {
    @NotNull
    private final SpaceRepository repository;
    @NotNull
    private final GitCommitChange gitCommitChange;
    private final boolean unreachable;
    @NotNull
    private final FileStatus fileStatus;
    @Nullable
    private final FilePath oldFilePath;
    @Nullable
    private final FilePath newFilePath;

    public SpaceChange(@NotNull SpaceRepository repository2, @NotNull GitCommitChange gitCommitChange, boolean unreachable) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)gitCommitChange, (String)"gitCommitChange");
        this.repository = repository2;
        this.gitCommitChange = gitCommitChange;
        this.unreachable = unreachable;
        this.fileStatus = SpaceChangeKt.access$getFileStatus(this.gitCommitChange);
        GitFile gitFile = this.gitCommitChange.getOld();
        this.oldFilePath = gitFile != null ? SpaceChangeKt.access$getFilePath(gitFile, this.repository.getMapping()) : null;
        GitFile gitFile2 = this.gitCommitChange.getNew();
        this.newFilePath = gitFile2 != null ? SpaceChangeKt.access$getFilePath(gitFile2, this.repository.getMapping()) : null;
    }

    public /* synthetic */ SpaceChange(SpaceRepository spaceRepository, GitCommitChange gitCommitChange, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(spaceRepository, gitCommitChange, bl);
    }

    @NotNull
    public final SpaceRepository getRepository() {
        return this.repository;
    }

    @NotNull
    public final GitCommitChange getGitCommitChange() {
        return this.gitCommitChange;
    }

    public final boolean getUnreachable() {
        return this.unreachable;
    }

    @NotNull
    public final FileStatus getFileStatus() {
        return this.fileStatus;
    }

    @Nullable
    public final FilePath getOldFilePath() {
        return this.oldFilePath;
    }

    @Nullable
    public final FilePath getNewFilePath() {
        return this.newFilePath;
    }

    @NotNull
    public final SpaceRepository component1() {
        return this.repository;
    }

    @NotNull
    public final GitCommitChange component2() {
        return this.gitCommitChange;
    }

    public final boolean component3() {
        return this.unreachable;
    }

    @NotNull
    public final SpaceChange copy(@NotNull SpaceRepository repository2, @NotNull GitCommitChange gitCommitChange, boolean unreachable) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)gitCommitChange, (String)"gitCommitChange");
        return new SpaceChange(repository2, gitCommitChange, unreachable);
    }

    public static /* synthetic */ SpaceChange copy$default(SpaceChange spaceChange, SpaceRepository spaceRepository, GitCommitChange gitCommitChange, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            spaceRepository = spaceChange.repository;
        }
        if ((n & 2) != 0) {
            gitCommitChange = spaceChange.gitCommitChange;
        }
        if ((n & 4) != 0) {
            bl = spaceChange.unreachable;
        }
        return spaceChange.copy(spaceRepository, gitCommitChange, bl);
    }

    @NotNull
    public String toString() {
        return "SpaceChange(repository=" + this.repository + ", gitCommitChange=" + this.gitCommitChange + ", unreachable=" + this.unreachable + ")";
    }

    public int hashCode() {
        int result2 = this.repository.hashCode();
        result2 = result2 * 31 + this.gitCommitChange.hashCode();
        int n = this.unreachable ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result2 = result2 * 31 + n;
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SpaceChange)) {
            return false;
        }
        SpaceChange spaceChange = (SpaceChange)other;
        if (!Intrinsics.areEqual((Object)this.repository, (Object)spaceChange.repository)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.gitCommitChange, (Object)spaceChange.gitCommitChange)) {
            return false;
        }
        return this.unreachable == spaceChange.unreachable;
    }
}

