/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.log;

import circlet.code.api.ExecutionStatus;
import circlet.code.api.ExternalCheckDTO;
import circlet.platform.api.PrimitivesExKt;
import com.intellij.icons.AllIcons;
import com.intellij.space.SpaceIcons;
import com.intellij.space.utils.DateUtilitiesKt;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u0015\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0015\u0010\t\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u001d\u0010\n\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\bH\u0002\u00a8\u0006\u000f"}, d2={"getDescription", "", "Lorg/jetbrains/annotations/Nls;", "value", "Lcirclet/code/api/ExternalCheckDTO;", "getIcon", "Ljavax/swing/Icon;", "status", "Lcirclet/code/api/ExecutionStatus;", "getText", "getTime", "timestamp", "", "isInProgress", "", "intellij.space.vcs"})
public final class SpaceExternalCheckRendererKt {
    private static final Icon getIcon(ExecutionStatus status2) {
        Icon icon2;
        switch (WhenMappings.$EnumSwitchMapping$0[status2.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                Icon icon3 = SpaceIcons.Icons.Pending;
                icon2 = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Pending");
                break;
            }
            case 4: {
                Icon icon4 = SpaceIcons.Icons.FailedToStart;
                icon2 = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"FailedToStart");
                break;
            }
            case 5: {
                Icon icon5 = SpaceIcons.Icons.Running;
                icon2 = icon5;
                Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"Running");
                break;
            }
            case 6: {
                Icon icon6 = SpaceIcons.Icons.Failing;
                icon2 = icon6;
                Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"Failing");
                break;
            }
            case 7: {
                Icon icon7 = SpaceIcons.Icons.Hanging;
                icon2 = icon7;
                Intrinsics.checkNotNullExpressionValue((Object)icon7, (String)"Hanging");
                break;
            }
            case 8: {
                Icon icon8 = AllIcons.RunConfigurations.ToolbarPassed;
                icon2 = icon8;
                Intrinsics.checkNotNullExpressionValue((Object)icon8, (String)"ToolbarPassed");
                break;
            }
            case 9: {
                Icon icon9 = SpaceIcons.Icons.Failed;
                icon2 = icon9;
                Intrinsics.checkNotNullExpressionValue((Object)icon9, (String)"Failed");
                break;
            }
            case 10: {
                Icon icon10 = SpaceIcons.Icons.Terminated;
                icon2 = icon10;
                Intrinsics.checkNotNullExpressionValue((Object)icon10, (String)"Terminated");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return icon2;
    }

    private static final String getText(ExternalCheckDTO value2) {
        return value2.getTaskName();
    }

    private static final String getDescription(ExternalCheckDTO value2) {
        String string2 = value2.getDescription();
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    private static final String getTime(ExecutionStatus status2, long timestamp) {
        return SpaceExternalCheckRendererKt.isInProgress(status2) ? DateUtilitiesKt.formatDuration(PrimitivesExKt.getNowMs() - timestamp) : DateUtilitiesKt.formatPrettyDateTime(timestamp);
    }

    private static final boolean isInProgress(ExecutionStatus $this$isInProgress) {
        return $this$isInProgress == ExecutionStatus.RUNNING || $this$isInProgress == ExecutionStatus.FAILING;
    }

    public static final /* synthetic */ Icon access$getIcon(ExecutionStatus status2) {
        return SpaceExternalCheckRendererKt.getIcon(status2);
    }

    public static final /* synthetic */ String access$getText(ExternalCheckDTO value2) {
        return SpaceExternalCheckRendererKt.getText(value2);
    }

    public static final /* synthetic */ String access$getTime(ExecutionStatus status2, long timestamp) {
        return SpaceExternalCheckRendererKt.getTime(status2, timestamp);
    }

    public static final /* synthetic */ String access$getDescription(ExternalCheckDTO value2) {
        return SpaceExternalCheckRendererKt.getDescription(value2);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExecutionStatus.values().length];
            try {
                nArray[ExecutionStatus.PENDING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutionStatus.SCHEDULED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutionStatus.READY_TO_START.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutionStatus.FAILED_TO_START.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutionStatus.RUNNING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutionStatus.FAILING.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutionStatus.HANGING.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutionStatus.SUCCEEDED.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutionStatus.FAILED.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutionStatus.TERMINATED.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

