/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.filter;

import java.text.ParseException;
import org.apache.ivy.osgi.filter.AndFilter;
import org.apache.ivy.osgi.filter.CompareFilter;
import org.apache.ivy.osgi.filter.MultiOperatorFilter;
import org.apache.ivy.osgi.filter.NotFilter;
import org.apache.ivy.osgi.filter.OSGiFilter;
import org.apache.ivy.osgi.filter.OrFilter;

public class OSGiFilterParser {
    public static OSGiFilter parse(String text2) throws ParseException {
        return new Parser(text2).parse();
    }

    static class Parser {
        private final String text;
        private int length;
        private int pos = 0;
        private char c;

        Parser(String text2) {
            this.text = text2;
            this.length = text2.length();
        }

        OSGiFilter parse() throws ParseException {
            return this.parseFilter();
        }

        private char readNext() {
            this.c = this.pos == this.length ? (char)'\u0000' : this.text.charAt(this.pos++);
            return this.c;
        }

        private void unread() {
            if (this.pos > 0) {
                --this.pos;
            }
        }

        private OSGiFilter parseFilter() throws ParseException {
            this.skipWhiteSpace();
            this.readNext();
            if (this.c != '(') {
                throw new ParseException("Expecting '(' as the start of the filter", this.pos);
            }
            OSGiFilter filter2 = this.parseFilterComp();
            this.readNext();
            if (this.c != ')') {
                throw new ParseException("Expecting ')' as the end of the filter", this.pos);
            }
            return filter2;
        }

        private OSGiFilter parseFilterComp() throws ParseException {
            OSGiFilter filter2;
            switch (this.readNext()) {
                case '&': {
                    filter2 = this.parseAnd();
                    break;
                }
                case '|': {
                    filter2 = this.parseOr();
                    break;
                }
                case '!': {
                    filter2 = this.parseNot();
                    break;
                }
                default: {
                    this.unread();
                    filter2 = this.parseOperation();
                }
            }
            return filter2;
        }

        private OSGiFilter parseOperation() throws ParseException {
            String leftValue = this.parseCompareValue();
            CompareFilter.Operator operator = this.parseCompareOperator();
            String rightValue = this.parseCompareValue();
            return new CompareFilter(leftValue, operator, rightValue);
        }

        private String parseCompareValue() {
            StringBuilder builder = new StringBuilder();
            do {
                this.readNext();
                if (this.isOperator(this.c) || this.c == ')' || this.c == '(') {
                    this.unread();
                    break;
                }
                builder.append(this.c);
            } while (this.pos < this.length);
            return builder.toString();
        }

        private boolean isOperator(char ch) {
            return ch == '=' || ch == '<' || ch == '>' || ch == '~';
        }

        private CompareFilter.Operator parseCompareOperator() throws ParseException {
            switch (this.readNext()) {
                case '=': {
                    if (this.readNext() == '*') {
                        return CompareFilter.Operator.PRESENT;
                    }
                    this.unread();
                    return CompareFilter.Operator.EQUALS;
                }
                case '>': {
                    if (this.readNext() == '=') {
                        return CompareFilter.Operator.GREATER_OR_EQUAL;
                    }
                    this.unread();
                    return CompareFilter.Operator.GREATER_THAN;
                }
                case '<': {
                    if (this.readNext() == '=') {
                        return CompareFilter.Operator.LOWER_OR_EQUAL;
                    }
                    this.unread();
                    return CompareFilter.Operator.LOWER_THAN;
                }
                case '~': {
                    if (this.readNext() == '=') {
                        return CompareFilter.Operator.LOWER_OR_EQUAL;
                    }
                    this.unread();
                }
            }
            throw new ParseException("Expecting an operator: =, <, <=, >, >=, ~= or =*", this.pos);
        }

        private OSGiFilter parseAnd() throws ParseException {
            AndFilter filter2 = new AndFilter();
            this.parseFilterList(filter2);
            return filter2;
        }

        private OSGiFilter parseOr() throws ParseException {
            OrFilter filter2 = new OrFilter();
            this.parseFilterList(filter2);
            return filter2;
        }

        private void parseFilterList(MultiOperatorFilter filter2) throws ParseException {
            do {
                this.skipWhiteSpace();
                this.readNext();
                if (this.c != '(') {
                    this.unread();
                    break;
                }
                this.unread();
                filter2.add(this.parseFilter());
            } while (this.pos < this.length);
            if (filter2.getSubFilters().size() == 0) {
                throw new ParseException("Expecting at least one sub filter", this.pos);
            }
        }

        private OSGiFilter parseNot() throws ParseException {
            this.readNext();
            if (this.c != '(') {
                throw new ParseException("The ! operator is expecting a filter", this.pos);
            }
            this.unread();
            return new NotFilter(this.parseFilter());
        }

        private void skipWhiteSpace() {
            do {
                switch (this.readNext()) {
                    case ' ': {
                        break;
                    }
                    default: {
                        this.unread();
                        return;
                    }
                }
            } while (this.pos < this.length);
        }
    }
}

