/*
 * Decompiled with CFR 0.152.
 */
package runtime.logging;

import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import runtime.json.JsonBuilderContext;
import runtime.logging.ErrorInfo;
import runtime.logging.JsonLogEventsLayoutKt;
import runtime.logging.LogAppVersion;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001f\u001a\b\u0010 \u001a\u0004\u0018\u00010\u0004\u001a\n\u0010!\u001a\u00020\"*\u00020#\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"#\u0010\u0003\u001a\n \u0002*\u0004\u0018\u00010\u00040\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\"\u001d\u0010\t\u001a\u0004\u0018\u00010\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\b\u001a\u0004\b\u000b\u0010\f\"\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000\" \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011*\u0004\u0018\u00010\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\"\u0018\u0010\u0015\u001a\u00020\u0016*\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\"\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u0011*\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006$"}, d2={"ISO_DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS", "Lorg/joda/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "computedHostName", "", "getComputedHostName", "()Ljava/lang/String;", "computedHostName$delegate", "Lkotlin/Lazy;", "logAppVersion", "Lruntime/logging/LogAppVersion;", "getLogAppVersion", "()Lruntime/logging/LogAppVersion;", "logAppVersion$delegate", "version", "", "allCauses", "Lkotlin/sequences/Sequence;", "Lch/qos/logback/classic/spi/IThrowableProxy;", "getAllCauses", "(Lch/qos/logback/classic/spi/IThrowableProxy;)Lkotlin/sequences/Sequence;", "error", "Lruntime/logging/ErrorInfo;", "getError", "(Lch/qos/logback/classic/spi/IThrowableProxy;)Lruntime/logging/ErrorInfo;", "superErrors", "Lch/qos/logback/classic/spi/ThrowableProxy;", "getSuperErrors", "(Lch/qos/logback/classic/spi/ThrowableProxy;)Lkotlin/sequences/Sequence;", "dateFormat", "timestamp", "", "getAppVersion", "putLogAppVersion", "", "Lruntime/json/JsonBuilderContext;", "platform-runtime"})
@SourceDebugExtension(value={"SMAP\nJsonLogEventsLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonLogEventsLayout.kt\nruntime/logging/JsonLogEventsLayoutKt\n+ 2 jsonDsl.kt\nruntime/json/JsonBuilderContext\n*L\n1#1,319:1\n54#2,4:320\n*S KotlinDebug\n*F\n+ 1 JsonLogEventsLayout.kt\nruntime/logging/JsonLogEventsLayoutKt\n*L\n58#1:320,4\n*E\n"})
public final class JsonLogEventsLayoutKt {
    @NotNull
    private static final Lazy computedHostName$delegate = LazyKt.lazy((Function0)computedHostName.2.INSTANCE);
    @NotNull
    private static final Lazy logAppVersion$delegate = LazyKt.lazy((Function0)logAppVersion.2.INSTANCE);
    private static final int version = 1;
    private static final DateTimeFormatter ISO_DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS = DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZoneUTC();

    private static final String getComputedHostName() {
        Lazy lazy = computedHostName$delegate;
        return (String)lazy.getValue();
    }

    private static final LogAppVersion getLogAppVersion() {
        Lazy lazy = logAppVersion$delegate;
        return (LogAppVersion)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public static final void putLogAppVersion(@NotNull JsonBuilderContext $this$putLogAppVersion) {
        block0: {
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)$this$putLogAppVersion, (String)"<this>");
            LogAppVersion logAppVersion2 = JsonLogEventsLayoutKt.getLogAppVersion();
            if (logAppVersion2 == null) break block0;
            LogAppVersion build = logAppVersion2;
            boolean bl = false;
            JsonBuilderContext jsonBuilderContext = $this$putLogAppVersion;
            String $this$put$iv = "app_build";
            boolean $i$f$put = false;
            ObjectNode objNode$iv = this_$iv.get__factory().objectNode();
            Intrinsics.checkNotNullExpressionValue((Object)objNode$iv, (String)"objNode");
            JsonBuilderContext $this$putLogAppVersion_u24lambda_u241_u24lambda_u240 = new JsonBuilderContext(objNode$iv, this_$iv.get__factory(), this_$iv.get__mapper());
            boolean bl2 = false;
            $this$putLogAppVersion_u24lambda_u241_u24lambda_u240.put("version", build.getVersion());
            $this$putLogAppVersion_u24lambda_u241_u24lambda_u240.put("date", build.getDate());
            $this$putLogAppVersion_u24lambda_u241_u24lambda_u240.put("commit", build.getCommit());
            $this$putLogAppVersion_u24lambda_u241_u24lambda_u240.put("branch", build.getBranch());
            this_$iv.get__node().set($this$put$iv, (JsonNode)objNode$iv);
        }
    }

    @Nullable
    public static final String getAppVersion() {
        LogAppVersion logAppVersion2 = JsonLogEventsLayoutKt.getLogAppVersion();
        return logAppVersion2 != null ? logAppVersion2.getVersion() : null;
    }

    @NotNull
    public static final String dateFormat(long timestamp) {
        String string2 = ISO_DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS.print(timestamp);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ISO_DATETIME_TIME_ZONE_F\u2026H_MILLIS.print(timestamp)");
        return string2;
    }

    private static final ErrorInfo getError(IThrowableProxy $this$error) {
        String string2 = $this$error.getClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className");
        return new ErrorInfo(string2, $this$error.getMessage());
    }

    private static final Sequence<IThrowableProxy> getAllCauses(IThrowableProxy $this$allCauses) {
        return SequencesKt.take((Sequence)SequencesKt.generateSequence((Object)$this$allCauses, (Function1)allCauses.1.INSTANCE), (int)15);
    }

    private static final Sequence<ErrorInfo> getSuperErrors(ThrowableProxy $this$superErrors) {
        return SequencesKt.map((Sequence)SequencesKt.take((Sequence)SequencesKt.generateSequence($this$superErrors.getThrowable().getClass().getSuperclass(), (Function1)superErrors.1.INSTANCE), (int)15), (Function1)((Function1)new Function1<Class<? extends Object>, ErrorInfo>($this$superErrors){
            final /* synthetic */ ThrowableProxy $this_superErrors;
            {
                this.$this_superErrors = $receiver;
                super(1);
            }

            @NotNull
            public final ErrorInfo invoke(@NotNull Class<? extends Object> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                String string2 = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
                return new ErrorInfo(string2, this.$this_superErrors.getMessage());
            }
        }));
    }

    public static final /* synthetic */ Sequence access$getAllCauses(IThrowableProxy $receiver) {
        return JsonLogEventsLayoutKt.getAllCauses($receiver);
    }

    public static final /* synthetic */ String access$getComputedHostName() {
        return JsonLogEventsLayoutKt.getComputedHostName();
    }

    public static final /* synthetic */ ErrorInfo access$getError(IThrowableProxy $receiver) {
        return JsonLogEventsLayoutKt.getError($receiver);
    }

    public static final /* synthetic */ Sequence access$getSuperErrors(ThrowableProxy $receiver) {
        return JsonLogEventsLayoutKt.getSuperErrors($receiver);
    }
}

