/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.CommonBundle;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.JavaCoverageAnnotator;
import com.intellij.coverage.JavaCoverageRunner;
import com.intellij.coverage.JavaCoverageSuite;
import com.intellij.coverage.PackageAnnotator;
import com.intellij.coverage.view.CoverageListNode;
import com.intellij.coverage.view.CoverageListRootNode;
import com.intellij.coverage.view.CoverageViewExtension;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.coverage.view.ElementColumnInfo;
import com.intellij.coverage.view.JavaCoverageNode;
import com.intellij.coverage.view.JavaCoverageRootNode;
import com.intellij.coverage.view.PercentageCoverageColumnInfo;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.coverage.JavaCoverageEnabledConfiguration;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.java.coverage.JavaCoverageBundle;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ui.ColumnInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCoverageViewExtension
extends CoverageViewExtension {
    private final JavaCoverageAnnotator myAnnotator;

    public JavaCoverageViewExtension(JavaCoverageAnnotator annotator, Project project, CoverageSuitesBundle suitesBundle, CoverageViewManager.StateBean stateBean) {
        super(project, suitesBundle, stateBean);
        this.myAnnotator = annotator;
    }

    public String getSummaryForNode(@NotNull AbstractTreeNode node) {
        if (node == null) {
            JavaCoverageViewExtension.$$$reportNull$$$0(0);
        }
        if (!this.myCoverageViewManager.isReady()) {
            return CommonBundle.getLoadingTreeNodeText();
        }
        if (this.myCoverageDataManager.isSubCoverageActive()) {
            return JavaCoverageViewExtension.showSubCoverageNotification();
        }
        PsiPackage aPackage = (PsiPackage)node.getValue();
        String coverageInformationString = this.myAnnotator.getPackageCoverageInformationString(aPackage, null, this.myCoverageDataManager, this.myStateBean.myFlattenPackages);
        return JavaCoverageBundle.message("coverage.view.node.summary", JavaCoverageViewExtension.getNotCoveredMessage(coverageInformationString), aPackage != null ? aPackage.getQualifiedName() : node.getName());
    }

    @Nls
    private static String showSubCoverageNotification() {
        return JavaCoverageBundle.message("sub.coverage.notification", new Object[0]);
    }

    public String getSummaryForRootNode(@NotNull AbstractTreeNode childNode) {
        if (childNode == null) {
            JavaCoverageViewExtension.$$$reportNull$$$0(1);
        }
        if (this.myCoverageDataManager.isSubCoverageActive()) {
            return JavaCoverageViewExtension.showSubCoverageNotification();
        }
        Object value = childNode.getValue();
        String coverageInformationString = this.myAnnotator.getPackageCoverageInformationString((PsiPackage)value, null, this.myCoverageDataManager);
        if (coverageInformationString == null) {
            if (!this.myCoverageViewManager.isReady()) {
                return CommonBundle.getLoadingTreeNodeText();
            }
            PackageAnnotator.SummaryCoverageInfo info = new PackageAnnotator.PackageCoverageInfo();
            Collection children = childNode.getChildren();
            for (Object child : children) {
                Object childValue = ((CoverageListNode)child).getValue();
                PackageAnnotator.SummaryCoverageInfo childInfo = this.getSummaryCoverageForNodeValue((AbstractTreeNode)childValue);
                info = JavaCoverageAnnotator.merge(info, childInfo);
            }
            coverageInformationString = JavaCoverageAnnotator.getCoverageInformationString(info, false);
        }
        return JavaCoverageBundle.message("coverage.view.root.node.summary", JavaCoverageViewExtension.getNotCoveredMessage(coverageInformationString));
    }

    private static String getNotCoveredMessage(String coverageInformationString) {
        if (coverageInformationString == null) {
            coverageInformationString = JavaCoverageBundle.message("coverage.view.no.coverage", new Object[0]);
        }
        return coverageInformationString;
    }

    public String getPercentage(int columnIndex, @NotNull AbstractTreeNode node) {
        if (node == null) {
            JavaCoverageViewExtension.$$$reportNull$$$0(2);
        }
        PackageAnnotator.SummaryCoverageInfo info = this.getSummaryCoverageForNodeValue(node);
        if (columnIndex == 1) {
            return JavaCoverageAnnotator.getClassCoveredPercentage(info);
        }
        if (columnIndex == 2) {
            return JavaCoverageAnnotator.getMethodCoveredPercentage(info);
        }
        if (columnIndex == 3) {
            return JavaCoverageAnnotator.getLineCoveredPercentage(info);
        }
        if (columnIndex == 4) {
            return JavaCoverageAnnotator.getBranchCoveredPercentage(info);
        }
        return "";
    }

    private PackageAnnotator.SummaryCoverageInfo getSummaryCoverageForNodeValue(AbstractTreeNode<?> node) {
        if (node instanceof CoverageListRootNode) {
            return this.myAnnotator.getPackageCoverageInfo("", this.myStateBean.myFlattenPackages);
        }
        JavaCoverageNode javaNode = (JavaCoverageNode)node;
        if (javaNode.isLeaf()) {
            return this.myAnnotator.getClassCoverageInfo(javaNode.getQualifiedName());
        }
        return this.myAnnotator.getPackageCoverageInfo(javaNode.getQualifiedName(), this.myStateBean.myFlattenPackages);
    }

    public PsiElement getElementToSelect(Object object) {
        PsiFile containingFile;
        PsiElement psiElement = super.getElementToSelect(object);
        if (psiElement != null && (containingFile = psiElement.getContainingFile()) instanceof PsiClassOwner) {
            PsiClass[] classes = ((PsiClassOwner)containingFile).getClasses();
            if (classes.length == 1) {
                return classes[0];
            }
            for (PsiClass aClass : classes) {
                if (!PsiTreeUtil.isAncestor((PsiElement)aClass, (PsiElement)psiElement, (boolean)false)) continue;
                return aClass;
            }
        }
        return psiElement;
    }

    public VirtualFile getVirtualFile(Object object) {
        if (object instanceof PsiPackage) {
            PsiDirectory[] directories = ((PsiPackage)object).getDirectories();
            return directories.length > 0 ? directories[0].getVirtualFile() : null;
        }
        return super.getVirtualFile(object);
    }

    @Nullable
    public PsiElement getParentElement(PsiElement element) {
        if (element instanceof PsiClass) {
            PsiDirectory containingDirectory = element.getContainingFile().getContainingDirectory();
            return containingDirectory != null ? JavaDirectoryService.getInstance().getPackage(containingDirectory) : null;
        }
        return ((PsiPackage)element).getParentPackage();
    }

    @NotNull
    public AbstractTreeNode<?> createRootNode() {
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)this.myProject).findPackage("");
        return new JavaCoverageRootNode(this.myProject, (PsiNamedElement)Objects.requireNonNull(aPackage), this.mySuitesBundle, this.myStateBean);
    }

    @NotNull
    public List<AbstractTreeNode<?>> createTopLevelNodes() {
        LinkedHashSet<PsiPackage> packages = new LinkedHashSet<PsiPackage>();
        LinkedHashSet<PsiClass> classes = new LinkedHashSet<PsiClass>();
        for (CoverageSuite suite : this.mySuitesBundle.getSuites()) {
            packages.addAll(((JavaCoverageSuite)suite).getCurrentSuitePackages(this.myProject));
            classes.addAll(((JavaCoverageSuite)suite).getCurrentSuiteClasses(this.myProject));
        }
        HashSet<PsiPackage> packs = new HashSet<PsiPackage>();
        block1: for (PsiPackage aPackage : packages) {
            String qualifiedName = aPackage.getQualifiedName();
            for (PsiPackage psiPackage : packages) {
                if (!psiPackage.getQualifiedName().startsWith(qualifiedName + ".")) continue;
                packs.add(psiPackage);
                continue block1;
            }
        }
        packages.removeAll(packs);
        ArrayList topLevelNodes = new ArrayList();
        GlobalSearchScope searchScope = this.mySuitesBundle.getSearchScope(this.myProject);
        for (PsiPackage aPackage : packages) {
            this.processSubPackage(aPackage, topLevelNodes, searchScope);
        }
        for (PsiClass aClass : classes) {
            JavaCoverageNode node = new JavaCoverageNode(this.myProject, (PsiNamedElement)aClass, this.mySuitesBundle, this.myStateBean);
            node.setFullyCovered(this.isFullyCovered((PsiNamedElement)aClass));
            topLevelNodes.add((AbstractTreeNode<?>)node);
        }
        ArrayList arrayList = topLevelNodes;
        if (arrayList == null) {
            JavaCoverageViewExtension.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private void collectSubPackages(List<AbstractTreeNode<?>> children, PsiPackage rootPackage, GlobalSearchScope searchScope) {
        PsiPackage[] subPackages;
        for (PsiPackage aPackage : subPackages = JavaCoverageViewExtension.getSubpackages(rootPackage, searchScope)) {
            this.processSubPackage(aPackage, children, searchScope);
        }
    }

    private void processSubPackage(PsiPackage aPackage, List<AbstractTreeNode<?>> children, GlobalSearchScope searchScope) {
        if (this.shouldIncludePackage(aPackage, searchScope)) {
            JavaCoverageNode node = new JavaCoverageNode(aPackage.getProject(), (PsiNamedElement)aPackage, this.mySuitesBundle, this.myStateBean);
            node.setFullyCovered(this.isFullyCovered((PsiNamedElement)aPackage));
            children.add((AbstractTreeNode<?>)node);
        } else if (!this.myStateBean.myFlattenPackages) {
            this.collectSubPackages(children, aPackage, searchScope);
        }
        if (this.myStateBean.myFlattenPackages) {
            this.collectSubPackages(children, aPackage, searchScope);
        }
    }

    private boolean shouldIncludePackage(PsiPackage aPackage, GlobalSearchScope searchScope) {
        return (Boolean)ReadAction.compute(() -> {
            PackageAnnotator.PackageCoverageInfo info;
            if (!this.isInCoverageScope((PsiElement)aPackage)) {
                return false;
            }
            if (!this.myAnnotator.isLoading() && (info = this.getPackageCoverageInfo(aPackage)) == null) {
                return false;
            }
            return !this.myStateBean.myFlattenPackages || aPackage.getClasses(searchScope).length != 0;
        });
    }

    private boolean shouldIncludeClass(PsiClass aClass) {
        PackageAnnotator.ClassCoverageInfo info;
        return this.myAnnotator.isLoading() || (info = this.getClassCoverageInfo(aClass)) != null;
    }

    private boolean isFullyCovered(PsiNamedElement classOrPackage) {
        PackageAnnotator.SummaryCoverageInfo info;
        if (classOrPackage instanceof PsiPackage) {
            PsiPackage psiPackage = (PsiPackage)classOrPackage;
            info = this.getPackageCoverageInfo(psiPackage);
        } else if (classOrPackage instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)classOrPackage;
            info = this.getClassCoverageInfo(psiClass);
        } else {
            return false;
        }
        return info != null && info.isFullyCovered();
    }

    public List<AbstractTreeNode<?>> getChildrenNodes(AbstractTreeNode node) {
        ArrayList children = new ArrayList();
        if (node instanceof CoverageListNode) {
            Object val = node.getValue();
            if (val instanceof PsiClass) {
                return Collections.emptyList();
            }
            if (val instanceof PsiPackage) {
                PsiPackage psiPackage = (PsiPackage)val;
                GlobalSearchScope globalSearchScope = this.mySuitesBundle.getSearchScope(this.myProject);
                if (((Boolean)ReadAction.compute(() -> this.isInCoverageScope((PsiElement)psiPackage))).booleanValue()) {
                    PsiFile[] childFiles;
                    if (!this.myStateBean.myFlattenPackages) {
                        this.collectSubPackages(children, psiPackage, globalSearchScope);
                    }
                    for (PsiFile file : childFiles = JavaCoverageViewExtension.getFiles(psiPackage, globalSearchScope)) {
                        this.collectFileChildren(file, children);
                    }
                } else if (!this.myStateBean.myFlattenPackages) {
                    this.collectSubPackages(children, (PsiPackage)val, globalSearchScope);
                }
            }
            if (node instanceof CoverageListRootNode) {
                for (CoverageSuite suite : this.mySuitesBundle.getSuites()) {
                    List<PsiClass> classes = ((JavaCoverageSuite)suite).getCurrentSuiteClasses(this.myProject);
                    for (PsiClass aClass : classes) {
                        JavaCoverageNode classNode = new JavaCoverageNode(this.myProject, (PsiNamedElement)aClass, this.mySuitesBundle, this.myStateBean);
                        classNode.setFullyCovered(this.isFullyCovered((PsiNamedElement)aClass));
                        children.add((AbstractTreeNode<?>)classNode);
                    }
                }
            }
            for (AbstractTreeNode abstractTreeNode : children) {
                abstractTreeNode.setParent(node);
            }
        }
        return children;
    }

    private static PsiFile[] getFiles(PsiPackage psiPackage, GlobalSearchScope searchScope) {
        return (PsiFile[])ReadAction.compute(() -> psiPackage.isValid() ? psiPackage.getFiles(searchScope) : PsiFile.EMPTY_ARRAY);
    }

    private static PsiPackage[] getSubpackages(PsiPackage psiPackage, GlobalSearchScope searchScope) {
        return (PsiPackage[])ReadAction.compute(() -> psiPackage.isValid() ? psiPackage.getSubPackages(searchScope) : PsiPackage.EMPTY_ARRAY);
    }

    protected void collectFileChildren(PsiFile file, List<? super AbstractTreeNode<?>> children) {
        if (file instanceof PsiClassOwner) {
            PsiClass[] classes;
            for (PsiClass aClass : classes = (PsiClass[])ReadAction.compute(() -> file.isValid() ? ((PsiClassOwner)file).getClasses() : PsiClass.EMPTY_ARRAY)) {
                if (!this.shouldIncludeClass(aClass)) continue;
                JavaCoverageNode node = new JavaCoverageNode(this.myProject, (PsiNamedElement)aClass, this.mySuitesBundle, this.myStateBean);
                node.setFullyCovered(this.isFullyCovered((PsiNamedElement)aClass));
                children.add((AbstractTreeNode<?>)node);
            }
        }
    }

    @Nullable
    private PackageAnnotator.ClassCoverageInfo getClassCoverageInfo(PsiClass aClass) {
        return this.myAnnotator.getClassCoverageInfo((String)ReadAction.compute(() -> aClass.isValid() ? aClass.getQualifiedName() : null));
    }

    @Nullable
    private PackageAnnotator.PackageCoverageInfo getPackageCoverageInfo(PsiPackage aPackage) {
        return (PackageAnnotator.PackageCoverageInfo)ReadAction.compute(() -> this.myAnnotator.getPackageCoverageInfo(aPackage.getQualifiedName(), this.myStateBean.myFlattenPackages));
    }

    public ColumnInfo[] createColumnInfos() {
        ArrayList<Object> infos = new ArrayList<Object>();
        infos.add(new ElementColumnInfo());
        infos.add(new PercentageCoverageColumnInfo(1, JavaCoverageBundle.message("coverage.view.column.class", new Object[0]), this.mySuitesBundle, this.myStateBean));
        infos.add(new PercentageCoverageColumnInfo(2, JavaCoverageBundle.message("coverage.view.column.method", new Object[0]), this.mySuitesBundle, this.myStateBean));
        infos.add(new PercentageCoverageColumnInfo(3, JavaCoverageBundle.message("coverage.view.column.line", new Object[0]), this.mySuitesBundle, this.myStateBean));
        RunConfigurationBase runConfiguration = this.mySuitesBundle.getRunConfiguration();
        if (runConfiguration != null) {
            JavaCoverageEnabledConfiguration coverageEnabledConfiguration = JavaCoverageEnabledConfiguration.getFrom(runConfiguration);
            if (coverageEnabledConfiguration != null) {
                this.tryAddBranches(infos, coverageEnabledConfiguration.getCoverageRunner(), coverageEnabledConfiguration.isTracingEnabled());
            }
        } else {
            CoverageSuite suite;
            CoverageRunner runner;
            CoverageSuite[] coverageSuiteArray = this.mySuitesBundle.getSuites();
            int n = coverageSuiteArray.length;
            for (int i = 0; i < n && !this.tryAddBranches(infos, runner = (suite = coverageSuiteArray[i]).getRunner(), false); ++i) {
            }
        }
        return infos.toArray(ColumnInfo.EMPTY_ARRAY);
    }

    private boolean tryAddBranches(ArrayList<? super ColumnInfo> infos, CoverageRunner coverageRunner, boolean branchCoverage) {
        if (this.isBranchInfoAvailable(coverageRunner, branchCoverage)) {
            infos.add((ColumnInfo)new PercentageCoverageColumnInfo(4, JavaCoverageBundle.message("coverage.view.column.branch", new Object[0]), this.mySuitesBundle, this.myStateBean));
            return true;
        }
        return false;
    }

    protected boolean isBranchInfoAvailable(CoverageRunner coverageRunner, boolean branchCoverage) {
        return coverageRunner instanceof JavaCoverageRunner && ((JavaCoverageRunner)coverageRunner).isBranchInfoAvailable(branchCoverage);
    }

    private boolean isInCoverageScope(PsiElement element) {
        if (element instanceof PsiPackage) {
            PsiPackage psiPackage = (PsiPackage)element;
            String qualifiedName = psiPackage.getQualifiedName();
            for (CoverageSuite suite : this.mySuitesBundle.getSuites()) {
                if (!((JavaCoverageSuite)suite).isPackageFiltered(qualifiedName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canSelectInCoverageView(Object object) {
        PsiFile psiFile;
        PsiFile psiFile2 = psiFile = object instanceof VirtualFile ? PsiManager.getInstance((Project)this.myProject).findFile((VirtualFile)object) : null;
        if (psiFile instanceof PsiClassOwner) {
            String packageName2 = ((PsiClassOwner)psiFile).getPackageName();
            return this.isInCoverageScope((PsiElement)JavaPsiFacade.getInstance((Project)this.myProject).findPackage(packageName2));
        }
        if (object instanceof PsiPackage) {
            return this.isInCoverageScope((PsiElement)object);
        }
        return false;
    }

    public boolean supportFlattenPackages() {
        return true;
    }

    public String getElementsName() {
        return JavaCoverageBundle.message("coverage.classes", new Object[0]);
    }

    public String getElementsCapitalisedName() {
        return JavaCoverageBundle.message("coverage.classes.capitalised", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/view/JavaCoverageViewExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/view/JavaCoverageViewExtension";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createTopLevelNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSummaryForNode";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSummaryForRootNode";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPercentage";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

