/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler.jarfs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.FileAccessorCache;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.FastJarFileSystem;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.FastJarVirtualFile;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.ZipEntryDescription;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.ZipImplementationKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J$\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00132\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00150\u0018H\u0002J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001a\u001a\u00020\u0005J$\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00150\u0018H\u0002J\u0018\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0\u001f*\u00020\u001dH\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/FastJarHandler;", "", "fileSystem", "Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/FastJarFileSystem;", "path", "", "(Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/FastJarFileSystem;Ljava/lang/String;)V", "cachedManifest", "", "file", "Ljava/io/File;", "getFile$cli_base", "()Ljava/io/File;", "getFileSystem", "()Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/FastJarFileSystem;", "myRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "contentsToByteArray", "zipEntryDescription", "Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/ZipEntryDescription;", "createFile", "Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/FastJarVirtualFile;", "entry", "directories", "", "findFileByPath", "pathInJar", "getOrCreateDirectory", "entryName", "", "splitPath", "Lkotlin/Pair;", "cli-base"})
@SourceDebugExtension(value={"SMAP\nFastJarHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FastJarHandler.kt\norg/jetbrains/kotlin/cli/jvm/compiler/jarfs/FastJarHandler\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n372#2,7:118\n661#3,11:125\n1#4:136\n*E\n*S KotlinDebug\n*F\n+ 1 FastJarHandler.kt\norg/jetbrains/kotlin/cli/jvm/compiler/jarfs/FastJarHandler\n*L\n82#1,7:118\n36#1,11:125\n*E\n"})
public final class FastJarHandler {
    private final VirtualFile myRoot;
    @NotNull
    private final File file;
    private final byte[] cachedManifest;
    @NotNull
    private final FastJarFileSystem fileSystem;

    @NotNull
    public final File getFile$cli_base() {
        return this.file;
    }

    /*
     * WARNING - void declaration
     */
    private final FastJarVirtualFile createFile(ZipEntryDescription entry, Map<String, FastJarVirtualFile> directories2) {
        void parentName;
        Pair<CharSequence, CharSequence> pair = this.splitPath(entry.getRelativePath());
        CharSequence charSequence2 = pair.component1();
        CharSequence shortName = pair.component2();
        FastJarVirtualFile parentFile = this.getOrCreateDirectory((CharSequence)parentName, directories2);
        if (Intrinsics.areEqual(".", shortName)) {
            return parentFile;
        }
        return new FastJarVirtualFile(this, shortName, entry.isDirectory() ? -1 : entry.getUncompressedSize(), parentFile, entry);
    }

    /*
     * WARNING - void declaration
     */
    private final FastJarVirtualFile getOrCreateDirectory(CharSequence entryName, Map<String, FastJarVirtualFile> directories2) {
        Object object;
        void $this$getOrPut$iv;
        Map<String, FastJarVirtualFile> map = directories2;
        String key$iv = ((Object)entryName).toString();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            void parentPath;
            boolean bl = false;
            Pair<CharSequence, CharSequence> pair = this.splitPath(entryName);
            CharSequence charSequence2 = pair.component1();
            CharSequence shortName = pair.component2();
            FastJarVirtualFile parentFile = this.getOrCreateDirectory((CharSequence)parentPath, directories2);
            FastJarVirtualFile answer$iv = new FastJarVirtualFile(this, shortName, -1, parentFile, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (FastJarVirtualFile)object;
    }

    private final Pair<CharSequence, CharSequence> splitPath(CharSequence $this$splitPath) {
        int slashIndex;
        for (slashIndex = $this$splitPath.length() - 1; slashIndex >= 0 && $this$splitPath.charAt(slashIndex) != '/'; --slashIndex) {
        }
        if (slashIndex == -1) {
            return new Pair<CharSequence, CharSequence>("", $this$splitPath);
        }
        return new Pair<CharSequence, CharSequence>($this$splitPath.subSequence(0, slashIndex), $this$splitPath.subSequence(slashIndex + 1, $this$splitPath.length()));
    }

    @Nullable
    public final VirtualFile findFileByPath(@NotNull String pathInJar) {
        Intrinsics.checkNotNullParameter(pathInJar, "pathInJar");
        VirtualFile virtualFile2 = this.myRoot;
        return virtualFile2 != null ? virtualFile2.findFileByRelativePath(pathInJar) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] contentsToByteArray(@NotNull ZipEntryDescription zipEntryDescription) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter(zipEntryDescription, "zipEntryDescription");
        CharSequence relativePath = zipEntryDescription.getRelativePath();
        if (StringUtil.equals(relativePath, "META-INF/MANIFEST.MF")) {
            if (this.cachedManifest == null) {
                throw (Throwable)new FileNotFoundException(this.file + "!/" + relativePath);
            }
            return this.cachedManifest;
        }
        Closeable closeable = this.fileSystem.getCachedOpenFileHandles$cli_base().get(this.file);
        Throwable throwable = null;
        try {
            byte[] byArray2;
            FileAccessorCache.Handle handle2;
            FileAccessorCache.Handle it = (FileAccessorCache.Handle)closeable;
            boolean bl = false;
            FileAccessorCache.Handle handle3 = it;
            Intrinsics.checkNotNullExpressionValue(handle3, "it");
            FileAccessorCache.Handle handle4 = handle2 = handle3;
            synchronized (handle4) {
                boolean bl2 = false;
                byArray2 = ZipImplementationKt.contentsToByteArray((MappedByteBuffer)((Pair)it.get()).getSecond(), zipEntryDescription);
            }
            byArray = byArray2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return byArray;
    }

    @NotNull
    public final FastJarFileSystem getFileSystem() {
        return this.fileSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public FastJarHandler(@NotNull FastJarFileSystem fileSystem, @NotNull String path2) {
        Intrinsics.checkNotNullParameter(fileSystem, "fileSystem");
        Intrinsics.checkNotNullParameter(path2, "path");
        this.fileSystem = fileSystem;
        this.file = new File(path2);
        List<ZipEntryDescription> entries = null;
        Closeable closeable = new RandomAccessFile(this.file, "r");
        Throwable throwable = null;
        try {
            Object object;
            RandomAccessFile randomAccessFile = (RandomAccessFile)closeable;
            boolean bl = false;
            MappedByteBuffer mappedByteBuffer = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, randomAccessFile.length());
            try {
                Object object2;
                Object object3;
                Object single$iv;
                FastJarHandler fastJarHandler;
                block17: {
                    void $this$singleOrNull$iv;
                    try {
                        MappedByteBuffer mappedByteBuffer2 = mappedByteBuffer;
                        Intrinsics.checkNotNullExpressionValue(mappedByteBuffer2, "mappedByteBuffer");
                        object = ZipImplementationKt.parseCentralDirectory(mappedByteBuffer2);
                    }
                    catch (Exception e) {
                        Logger.getInstance(this.getClass()).warn("Error while reading zip file: " + this.file.getPath() + ": " + e, e);
                        object = CollectionsKt.emptyList();
                    }
                    entries = object;
                    object = entries;
                    fastJarHandler = this;
                    boolean $i$f$singleOrNull = false;
                    single$iv = null;
                    boolean found$iv = false;
                    for (Object element$iv : $this$singleOrNull$iv) {
                        ZipEntryDescription it = (ZipEntryDescription)element$iv;
                        boolean bl2 = false;
                        if (!StringUtil.equals("META-INF/MANIFEST.MF", it.getRelativePath())) continue;
                        if (found$iv) {
                            object3 = null;
                            break block17;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    object3 = !found$iv ? null : single$iv;
                }
                Object object4 = object3;
                FastJarHandler fastJarHandler2 = fastJarHandler;
                ZipEntryDescription zipEntryDescription = (ZipEntryDescription)object4;
                if (zipEntryDescription != null) {
                    void p1;
                    object = zipEntryDescription;
                    MappedByteBuffer mappedByteBuffer3 = mappedByteBuffer;
                    Intrinsics.checkNotNullExpressionValue(mappedByteBuffer3, "mappedByteBuffer");
                    MappedByteBuffer $i$f$singleOrNull = mappedByteBuffer3;
                    single$iv = object;
                    fastJarHandler = fastJarHandler2;
                    boolean bl3 = false;
                    object4 = ZipImplementationKt.contentsToByteArray($i$f$singleOrNull, (ZipEntryDescription)p1);
                    fastJarHandler2 = fastJarHandler;
                    object2 = object4;
                } else {
                    object2 = null;
                }
                fastJarHandler2.cachedManifest = object2;
            }
            finally {
                Object $this$with = object = this.fileSystem;
                boolean bl4 = false;
                Function1<MappedByteBuffer, Unit> function1 = ((FastJarFileSystem)$this$with).getUnmapBuffer$cli_base();
                MappedByteBuffer mappedByteBuffer4 = mappedByteBuffer;
                Intrinsics.checkNotNullExpressionValue(mappedByteBuffer4, "mappedByteBuffer");
                function1.invoke(mappedByteBuffer4);
            }
            Iterator iterator2 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        this.myRoot = new FastJarVirtualFile(this, "", -1, null, null);
        HashMap filesByRelativePath = new HashMap(entries.size());
        ((Map)filesByRelativePath).put("", this.myRoot);
        for (ZipEntryDescription entryDescription : entries) {
            if (!entryDescription.isDirectory()) {
                this.createFile(entryDescription, filesByRelativePath);
                continue;
            }
            this.getOrCreateDirectory(entryDescription.getRelativePath(), filesByRelativePath);
        }
        for (FastJarVirtualFile node : filesByRelativePath.values()) {
            node.initChildrenArrayFromList();
        }
    }
}

