/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.binding;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.PsiType;
import com.intellij.ui.UIBundle;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.binding.BoundIconRenderer;
import com.intellij.uiDesigner.binding.ChangeBoundFieldTypeFix;
import com.intellij.uiDesigner.binding.ChangeFormComponentTypeFix;
import com.intellij.uiDesigner.binding.FormClassIndex;
import com.intellij.uiDesigner.binding.FormReferenceProvider;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FormClassAnnotator
implements Annotator {
    private static final Logger LOG = Logger.getInstance(FormClassAnnotator.class);

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        PsiClass aClass;
        List<PsiFile> formsBoundToClass;
        if (psiElement == null) {
            FormClassAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            FormClassAnnotator.$$$reportNull$$$0(1);
        }
        if (psiElement instanceof PsiField) {
            PsiField field = (PsiField)psiElement;
            PsiFile boundForm = FormReferenceProvider.getFormFile(field);
            if (boundForm != null) {
                FormClassAnnotator.annotateFormField(field, boundForm, holder);
            }
        } else if (psiElement instanceof PsiClass && (formsBoundToClass = FormClassIndex.findFormsBoundToClass((aClass = (PsiClass)psiElement).getProject(), aClass)).size() > 0) {
            holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range((PsiElement)aClass.getNameIdentifier()).gutterIconRenderer((GutterIconRenderer)new BoundIconRenderer((PsiElement)aClass)).create();
        }
    }

    private static void annotateFormField(final PsiField field, PsiFile boundForm, AnnotationHolder holder) {
        PsiType fieldType;
        holder.newSilentAnnotation(HighlightSeverity.INFORMATION).gutterIconRenderer((GutterIconRenderer)new BoundIconRenderer((PsiElement)field)).create();
        LOG.assertTrue(boundForm instanceof PsiPlainTextFile);
        PsiType guiComponentType = FormReferenceProvider.getGUIComponentType((PsiPlainTextFile)boundForm, field.getName());
        if (guiComponentType != null && !(fieldType = field.getType()).isAssignableFrom(guiComponentType)) {
            String message = UIDesignerBundle.message("bound.field.type.mismatch", guiComponentType.getCanonicalText(), fieldType.getCanonicalText());
            holder.newAnnotation(HighlightSeverity.ERROR, message).range((PsiElement)field.getTypeElement()).withFix((IntentionAction)new ChangeFormComponentTypeFix((PsiPlainTextFile)boundForm, field.getName(), field.getType())).withFix((ModCommandAction)new ChangeBoundFieldTypeFix(field, guiComponentType)).create();
        }
        if (field.hasInitializer()) {
            final String message = UIDesignerBundle.message("field.is.overwritten.by.generated.code", field.getName());
            holder.newAnnotation(HighlightSeverity.WARNING, message).range((PsiElement)field.getInitializer()).withFix(new IntentionAction(){

                @NotNull
                public String getText() {
                    String string = message;
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                @NotNull
                public String getFamilyName() {
                    String string = UIBundle.message((String)"remove.field.initializer.quick.fix", (Object[])new Object[0]);
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                    if (project == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return field.getInitializer() != null;
                }

                public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
                    PsiExpression initializer;
                    if (project == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    LOG.assertTrue((initializer = field.getInitializer()) != null);
                    initializer.delete();
                }

                public boolean startInWriteAction() {
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 2;
                        case 2, 3 -> 3;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/uiDesigner/binding/FormClassAnnotator$1";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getText";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getFamilyName";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/uiDesigner/binding/FormClassAnnotator$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "isAvailable";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray;
                            objectArray[2] = "invoke";
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalStateException(string);
                        case 2, 3 -> new IllegalArgumentException(string);
                    };
                }
            }).create();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/uiDesigner/binding/FormClassAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

