/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.designSurface;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.designSurface.ComponentDragObject;
import com.intellij.uiDesigner.designSurface.ComponentDropLocation;
import com.intellij.uiDesigner.designSurface.FeedbackLayer;
import com.intellij.uiDesigner.designSurface.GridInsertLocation;
import com.intellij.uiDesigner.designSurface.GridInsertMode;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.shared.XYLayoutManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridDropLocation
implements ComponentDropLocation {
    private static final Logger LOG = Logger.getInstance(GridDropLocation.class);
    protected final RadContainer myContainer;
    protected int myRow;
    protected int myColumn;

    public GridDropLocation(@NotNull RadContainer container, int row, int column) {
        if (container == null) {
            GridDropLocation.$$$reportNull$$$0(0);
        }
        this.myContainer = container;
        this.myRow = row;
        this.myColumn = column;
    }

    public int getRow() {
        return this.myRow;
    }

    public int getColumn() {
        return this.myColumn;
    }

    @Override
    public RadContainer getContainer() {
        return this.myContainer;
    }

    @Override
    public boolean canDrop(ComponentDragObject dragObject) {
        if (this.myRow == -1 || this.myColumn == -1) {
            LOG.debug("RadContainer.canDrop=false because no cell at mouse position");
            return false;
        }
        int colSpan = 1;
        int rowSpan = 1;
        for (int i = 0; i < dragObject.getComponentCount(); ++i) {
            int relativeCol = dragObject.getRelativeCol(i);
            int relativeRow = dragObject.getRelativeRow(i);
            LOG.debug("checking component: relativeRow" + relativeRow + ", relativeCol" + relativeCol + ", colSpan=" + colSpan + ", rowSpan=" + rowSpan);
            if (this.myRow + relativeRow < 0 || this.myColumn + relativeCol < 0 || this.myRow + relativeRow + rowSpan > this.myContainer.getGridRowCount() || this.myColumn + relativeCol + colSpan > this.myContainer.getGridColumnCount()) {
                LOG.debug("RadContainer.canDrop=false because range is outside grid: row=" + (this.myRow + relativeRow) + ", col=" + (this.myColumn + relativeCol) + ", colSpan=" + colSpan + ", rowSpan=" + rowSpan);
                return false;
            }
            RadComponent componentInRect = this.findOverlappingComponent(this.myRow + relativeRow, this.myColumn + relativeCol, rowSpan, colSpan);
            if (componentInRect == null) continue;
            LOG.debug("GridDropLocation.canDrop=false because found component " + componentInRect.getId() + " in rect (row=" + (this.myRow + relativeRow) + ", col=" + (this.myColumn + relativeCol) + ", rowSpan=" + rowSpan + ", colSpan=" + colSpan + ")");
            return false;
        }
        LOG.debug("canDrop=true");
        return true;
    }

    protected RadComponent findOverlappingComponent(int startRow, int startCol, int rowSpan, int colSpan) {
        return this.myContainer.findComponentInRect(startRow, startCol, rowSpan, colSpan);
    }

    @Override
    public void placeFeedback(FeedbackLayer feedbackLayer, ComponentDragObject dragObject) {
        Rectangle feedbackRect = null;
        if (this.getContainer().getLayoutManager().isGrid()) {
            feedbackRect = this.getGridFeedbackRect(dragObject, false, false, true);
        }
        if (feedbackRect != null) {
            JComponent component = this.getContainer().getDelegee();
            StringBuilder feedbackBuilder = new StringBuilder(this.getContainer().getDisplayName());
            feedbackBuilder.append(" (").append(this.myRow + this.getContainer().getGridLayoutManager().getCellIndexBase());
            feedbackBuilder.append(", ").append(this.myColumn + this.getContainer().getGridLayoutManager().getCellIndexBase());
            feedbackBuilder.append(")");
            feedbackLayer.putFeedback(component, feedbackRect, feedbackBuilder.toString());
        } else {
            feedbackLayer.removeFeedback();
        }
    }

    @Nullable
    protected Rectangle getGridFeedbackCellRect(ComponentDragObject dragObject, boolean ignoreWidth, boolean ignoreHeight, boolean overlapping) {
        if (dragObject.getComponentCount() == 0) {
            return null;
        }
        Rectangle rc = this.calculateGridFeedbackCellRect(dragObject, ignoreWidth, ignoreHeight, true);
        if (rc == null) {
            return this.calculateGridFeedbackCellRect(dragObject, ignoreWidth, ignoreHeight, false);
        }
        if (overlapping && this.findOverlappingComponent(rc.y, rc.x, rc.height + 1, rc.width + 1) != null) {
            return this.calculateGridFeedbackCellRect(dragObject, ignoreWidth, ignoreHeight, false);
        }
        return rc;
    }

    @Nullable
    private Rectangle calculateGridFeedbackCellRect(ComponentDragObject dragObject, boolean ignoreWidth, boolean ignoreHeight, boolean spans) {
        int h;
        Rectangle rc = this.getDragObjectDimensions(dragObject, spans);
        int w = ignoreWidth ? 1 : rc.width;
        int n = h = ignoreHeight ? 1 : rc.height;
        if (rc.x < 0 || rc.y < 0 || rc.y + h > this.getContainer().getGridRowCount() || rc.x + w > this.getContainer().getGridColumnCount()) {
            return null;
        }
        return new Rectangle(rc.x, rc.y, w - 1, h - 1);
    }

    protected Rectangle getDragObjectDimensions(ComponentDragObject dragObject, boolean spans) {
        int firstRow = this.getRow();
        int lastRow = this.getRow();
        int firstCol = this.getColumn();
        int lastCol = this.getColumn();
        for (int i = 0; i < dragObject.getComponentCount(); ++i) {
            int relRow = dragObject.getRelativeRow(i);
            int relCol = dragObject.getRelativeCol(i);
            firstRow = Math.min(firstRow, this.getRow() + relRow);
            firstCol = Math.min(firstCol, this.getColumn() + relCol);
            lastRow = Math.max(lastRow, this.getRow() + relRow + (spans ? dragObject.getRowSpan(i) : 1) - 1);
            lastCol = Math.max(lastCol, this.getColumn() + relCol + (spans ? dragObject.getColSpan(i) : 1) - 1);
        }
        return new Rectangle(firstCol, firstRow, lastCol - firstCol + 1, lastRow - firstRow + 1);
    }

    @Nullable
    protected Rectangle getGridFeedbackRect(ComponentDragObject dragObject, boolean ignoreWidth, boolean ignoreHeight, boolean overlapping) {
        Rectangle cellRect = this.getGridFeedbackCellRect(dragObject, ignoreWidth, ignoreHeight, overlapping);
        if (cellRect == null) {
            return null;
        }
        int h = ignoreHeight ? 0 : cellRect.height;
        int w = ignoreWidth ? 0 : cellRect.width;
        return this.getContainer().getGridLayoutManager().getGridCellRangeRect(this.getContainer(), cellRect.y, cellRect.x, cellRect.y + h, cellRect.x + w);
    }

    @Override
    public void processDrop(GuiEditor editor, RadComponent[] components, GridConstraints[] constraintsToAdjust, ComponentDragObject dragObject) {
        GridDropLocation.dropIntoGrid(this.myContainer, components, this.myRow, this.myColumn, dragObject);
    }

    @Override
    @Nullable
    public ComponentDropLocation getAdjacentLocation(ComponentDropLocation.Direction direction) {
        GridInsertMode insertMode = switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case ComponentDropLocation.Direction.LEFT -> GridInsertMode.ColumnBefore;
            case ComponentDropLocation.Direction.UP -> GridInsertMode.RowBefore;
            case ComponentDropLocation.Direction.RIGHT -> GridInsertMode.ColumnAfter;
            case ComponentDropLocation.Direction.DOWN -> GridInsertMode.RowAfter;
        };
        return new GridInsertLocation(this.myContainer, this.myRow, this.myColumn, insertMode);
    }

    @NonNls
    public String toString() {
        return "GridDropLocation(row=" + this.myRow + ",col=" + this.myColumn + ")";
    }

    protected static void dropIntoGrid(RadContainer container, RadComponent[] components, int row, int column, ComponentDragObject dragObject) {
        assert (components.length > 0);
        for (int i = 0; i < components.length; ++i) {
            RadComponent old;
            LayoutManager layout;
            RadComponent c = components[i];
            if (c instanceof RadContainer && (layout = ((RadContainer)c).getLayout()) instanceof XYLayoutManager) {
                ((XYLayoutManager)layout).setPreferredSize(c.getSize());
            }
            int relativeCol = dragObject.getRelativeCol(i);
            int relativeRow = dragObject.getRelativeRow(i);
            LOG.debug("dropIntoGrid: relativeRow=" + relativeRow + ", relativeCol=" + relativeCol);
            int colSpan = dragObject.getColSpan(i);
            int rowSpan = dragObject.getRowSpan(i);
            assert (row + relativeRow >= 0);
            assert (column + relativeCol >= 0);
            if ((rowSpan > 1 || colSpan > 1) && (row + relativeRow + rowSpan > container.getGridRowCount() && rowSpan > 1 || column + relativeCol + colSpan > container.getGridColumnCount() && colSpan > 1 || container.findComponentInRect(row + relativeRow, column + relativeCol, rowSpan, colSpan) != null)) {
                rowSpan = 1;
                colSpan = 1;
            }
            if (!container.getGridLayoutManager().isGridDefinedByComponents()) {
                assert (relativeRow + rowSpan <= container.getGridRowCount());
                assert (relativeCol + colSpan <= container.getGridColumnCount());
            }
            if ((old = container.findComponentInRect(row + relativeRow, column + relativeCol, rowSpan, colSpan)) != null) {
                LOG.error("Drop rectangle not empty: (" + (row + relativeRow) + ", " + (column + relativeCol) + ", " + rowSpan + ", " + colSpan + "), component ID=" + old.getId());
            }
            GridConstraints constraints = c.getConstraints();
            constraints.setRow(row + relativeRow);
            constraints.setColumn(column + relativeCol);
            constraints.setRowSpan(rowSpan);
            constraints.setColSpan(colSpan);
            LOG.info("GridDropLocation.dropIntoGrid() constraints=" + constraints);
            container.addComponent(c);
            c.revalidate();
        }
        container.revalidate();
        LOG.info("GridDropLocation.dropIntoGrid() done");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/uiDesigner/designSurface/GridDropLocation", "<init>"));
    }
}

