/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.core.convert.toClient;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.common.protocol.data.AlphaCompositeRule;
import org.jetbrains.projector.common.protocol.data.CommonAlphaComposite;
import org.jetbrains.projector.common.protocol.data.CommonComposite;
import org.jetbrains.projector.common.protocol.data.CommonIntSize;
import org.jetbrains.projector.common.protocol.data.CommonPath;
import org.jetbrains.projector.common.protocol.data.CommonRectangle;
import org.jetbrains.projector.common.protocol.data.CommonShape;
import org.jetbrains.projector.common.protocol.data.CursorType;
import org.jetbrains.projector.common.protocol.data.PaintValue;
import org.jetbrains.projector.common.protocol.data.PathSegment;
import org.jetbrains.projector.common.protocol.data.Point;
import org.jetbrains.projector.common.protocol.data.StrokeData;
import org.jetbrains.projector.common.protocol.data.UnknownComposite;
import org.jetbrains.projector.common.protocol.toClient.ServerSetClipEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerSetStrokeEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerSetUnknownStrokeEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerWindowStateEvent;
import org.jetbrains.projector.util.logging.Logger;
import org.jetbrains.projector.util.logging.LoggerKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0088\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u001a\n\u0010\t\u001a\u00020\n*\u00020\u000b\u001a\n\u0010\f\u001a\u00020\r*\u00020\u000e\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0011H\u0002\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\u0014\u001a\n\u0010\u0015\u001a\u00020\u0016*\u00020\u0017\u001a\n\u0010\u0018\u001a\u00020\u0019*\u00020\u0005\u001a\n\u0010\u001a\u001a\u00020\u001b*\u00020\u001c\u001a\n\u0010\u001d\u001a\u00020\u001e*\u00020\u001f\u001a\n\u0010 \u001a\u00020!*\u00020\"\u001a\n\u0010#\u001a\u00020$*\u00020%\u001a\n\u0010&\u001a\u00020\u0003*\u00020'\u001a\n\u0010(\u001a\u00020'*\u00020)\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"logger", "Lorg/jetbrains/projector/util/logging/Logger;", "createSetClipEvent", "Lorg/jetbrains/projector/common/protocol/toClient/ServerWindowStateEvent;", "identitySpaceClip", "Ljava/awt/Shape;", "roundToInfinity", "", "x", "toBasicStrokeData", "Lorg/jetbrains/projector/common/protocol/data/StrokeData$Basic;", "Ljava/awt/BasicStroke;", "toColor", "Ljava/awt/Color;", "", "toCommonAlphaComposite", "Lorg/jetbrains/projector/common/protocol/data/CommonAlphaComposite;", "Ljava/awt/AlphaComposite;", "toCommonComposite", "Lorg/jetbrains/projector/common/protocol/data/CommonComposite;", "Ljava/awt/Composite;", "toCommonIntSize", "Lorg/jetbrains/projector/common/protocol/data/CommonIntSize;", "Ljava/awt/Dimension;", "toCommonPath", "Lorg/jetbrains/projector/common/protocol/data/CommonPath;", "toCommonRectangle", "Lorg/jetbrains/projector/common/protocol/data/CommonRectangle;", "Ljava/awt/Rectangle;", "toCursorType", "Lorg/jetbrains/projector/common/protocol/data/CursorType;", "", "toPaintValue", "Lorg/jetbrains/projector/common/protocol/data/PaintValue;", "Ljava/awt/Paint;", "toPoint", "Lorg/jetbrains/projector/common/protocol/data/Point;", "Ljava/awt/geom/Point2D;", "toSetStrokeEvent", "Ljava/awt/Stroke;", "toStroke", "Lorg/jetbrains/projector/common/protocol/data/StrokeData;", "projector-server-core"})
public final class ConvertKt {
    @NotNull
    private static final Logger logger = LoggerKt.Logger("ConvertKt");

    @NotNull
    public static final Point toPoint(@NotNull Point2D $this$toPoint) {
        Intrinsics.checkNotNullParameter((Object)$this$toPoint, (String)"<this>");
        return new Point($this$toPoint.getX(), $this$toPoint.getY());
    }

    @NotNull
    public static final CommonIntSize toCommonIntSize(@NotNull Dimension $this$toCommonIntSize) {
        Intrinsics.checkNotNullParameter((Object)$this$toCommonIntSize, (String)"<this>");
        return new CommonIntSize($this$toCommonIntSize.width, $this$toCommonIntSize.height);
    }

    @NotNull
    public static final CommonRectangle toCommonRectangle(@NotNull Rectangle $this$toCommonRectangle) {
        Intrinsics.checkNotNullParameter((Object)$this$toCommonRectangle, (String)"<this>");
        return new CommonRectangle($this$toCommonRectangle.x, $this$toCommonRectangle.y, $this$toCommonRectangle.width, $this$toCommonRectangle.height);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final CommonPath toCommonPath(@NotNull Shape $this$toCommonPath) {
        CommonPath.WindingType windingType;
        Intrinsics.checkNotNullParameter((Object)$this$toCommonPath, (String)"<this>");
        List segments = new ArrayList();
        PathIterator pi = $this$toCommonPath.getPathIterator(null);
        while (!pi.isDone()) {
            PathSegment pathSegment;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            double[] coordinates = new double[6];
            int pathSegmentType = pi.currentSegment(coordinates);
            Iterable iterable = CollectionsKt.chunked((Iterable)ArraysKt.asList((double[])coordinates), (int)2);
            boolean $i$f$map = false;
            void var8_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $dstr$x$y;
                List list = (List)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                double x = ((Number)$dstr$x$y.get(0)).doubleValue();
                double y = ((Number)$dstr$x$y.get(1)).doubleValue();
                collection.add(new Point(x, y));
            }
            List points2 = (List)destination$iv$iv;
            switch (pathSegmentType) {
                case 0: {
                    pathSegment = new PathSegment.MoveTo((Point)points2.get(0));
                    break;
                }
                case 1: {
                    pathSegment = new PathSegment.LineTo((Point)points2.get(0));
                    break;
                }
                case 2: {
                    pathSegment = new PathSegment.QuadTo((Point)points2.get(0), (Point)points2.get(1));
                    break;
                }
                case 3: {
                    pathSegment = new PathSegment.CubicTo((Point)points2.get(0), (Point)points2.get(1), (Point)points2.get(2));
                    break;
                }
                case 4: {
                    pathSegment = PathSegment.Close.INSTANCE;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported path segment type: " + pathSegmentType);
                }
            }
            PathSegment segment = pathSegment;
            segments.add(segment);
            pi.next();
        }
        int windingRule = pi.getWindingRule();
        switch (windingRule) {
            case 0: {
                windingType = CommonPath.WindingType.EVEN_ODD;
                break;
            }
            case 1: {
                windingType = CommonPath.WindingType.NON_ZERO;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported winding rule: " + windingRule);
            }
        }
        CommonPath.WindingType windingType2 = windingType;
        return new CommonPath(segments, windingType2);
    }

    @NotNull
    public static final Color toColor(@NotNull Number $this$toColor) {
        Intrinsics.checkNotNullParameter((Object)$this$toColor, (String)"<this>");
        return new Color($this$toColor.intValue(), true);
    }

    @NotNull
    public static final Stroke toStroke(@NotNull StrokeData $this$toStroke) {
        Intrinsics.checkNotNullParameter((Object)$this$toStroke, (String)"<this>");
        if ($this$toStroke instanceof StrokeData.Basic) {
            int n;
            int n2;
            switch (WhenMappings.$EnumSwitchMapping$0[((StrokeData.Basic)$this$toStroke).getEndCap().ordinal()]) {
                case 1: {
                    n2 = 0;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
                case 3: {
                    n2 = 1;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            int cap = n2;
            switch (WhenMappings.$EnumSwitchMapping$1[((StrokeData.Basic)$this$toStroke).getLineJoin().ordinal()]) {
                case 1: {
                    n = 0;
                    break;
                }
                case 2: {
                    n = 2;
                    break;
                }
                case 3: {
                    n = 1;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            int join = n;
            List<Float> list = ((StrokeData.Basic)$this$toStroke).getDashArray();
            return new BasicStroke(((StrokeData.Basic)$this$toStroke).getLineWidth(), cap, join, ((StrokeData.Basic)$this$toStroke).getMiterLimit(), list == null ? null : CollectionsKt.toFloatArray((Collection)list), ((StrokeData.Basic)$this$toStroke).getDashPhase());
        }
        throw new NoWhenBranchMatchedException();
    }

    @NotNull
    public static final StrokeData.Basic toBasicStrokeData(@NotNull BasicStroke $this$toBasicStrokeData) {
        StrokeData.Basic.JoinType joinType;
        StrokeData.Basic.CapType capType;
        Intrinsics.checkNotNullParameter((Object)$this$toBasicStrokeData, (String)"<this>");
        int cap = $this$toBasicStrokeData.getEndCap();
        switch (cap) {
            case 0: {
                capType = StrokeData.Basic.CapType.BUTT;
                break;
            }
            case 2: {
                capType = StrokeData.Basic.CapType.SQUARE;
                break;
            }
            case 1: {
                capType = StrokeData.Basic.CapType.ROUND;
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad s.endCap: " + cap);
            }
        }
        StrokeData.Basic.CapType cap2 = capType;
        int join = $this$toBasicStrokeData.getLineJoin();
        switch (join) {
            case 0: {
                joinType = StrokeData.Basic.JoinType.MITER;
                break;
            }
            case 2: {
                joinType = StrokeData.Basic.JoinType.BEVEL;
                break;
            }
            case 1: {
                joinType = StrokeData.Basic.JoinType.ROUND;
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad s.lineJoin: " + join);
            }
        }
        StrokeData.Basic.JoinType join2 = joinType;
        float[] fArray = $this$toBasicStrokeData.getDashArray();
        return new StrokeData.Basic($this$toBasicStrokeData.getLineWidth(), join2, cap2, $this$toBasicStrokeData.getMiterLimit(), $this$toBasicStrokeData.getDashPhase(), (List<Float>)(fArray == null ? null : ArraysKt.toList((float[])fArray)));
    }

    @NotNull
    public static final CursorType toCursorType(int $this$toCursorType) {
        CursorType cursorType;
        switch ($this$toCursorType) {
            case 0: {
                cursorType = CursorType.DEFAULT;
                break;
            }
            case 1: {
                cursorType = CursorType.CROSSHAIR;
                break;
            }
            case 2: {
                cursorType = CursorType.TEXT;
                break;
            }
            case 3: {
                cursorType = CursorType.WAIT;
                break;
            }
            case 4: {
                cursorType = CursorType.SW_RESIZE;
                break;
            }
            case 5: {
                cursorType = CursorType.SE_RESIZE;
                break;
            }
            case 6: {
                cursorType = CursorType.NW_RESIZE;
                break;
            }
            case 7: {
                cursorType = CursorType.NE_RESIZE;
                break;
            }
            case 8: {
                cursorType = CursorType.N_RESIZE;
                break;
            }
            case 9: {
                cursorType = CursorType.S_RESIZE;
                break;
            }
            case 10: {
                cursorType = CursorType.W_RESIZE;
                break;
            }
            case 11: {
                cursorType = CursorType.E_RESIZE;
                break;
            }
            case 12: {
                cursorType = CursorType.HAND;
                break;
            }
            case 13: {
                cursorType = CursorType.MOVE;
                break;
            }
            case -1: {
                cursorType = CursorType.CUSTOM;
                break;
            }
            default: {
                Logger.DefaultImpls.error$default(logger, null, (Function0)new Function0<String>($this$toCursorType){
                    final /* synthetic */ int $this_toCursorType;
                    {
                        this.$this_toCursorType = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Int.toCursorType(): Bad cursor id: " + this.$this_toCursorType + ". Returning default.";
                    }
                }, 1, null);
                cursorType = CursorType.DEFAULT;
            }
        }
        return cursorType;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final PaintValue toPaintValue(@NotNull Paint $this$toPaintValue) {
        PaintValue paintValue;
        Intrinsics.checkNotNullParameter((Object)$this$toPaintValue, (String)"<this>");
        Paint paint = $this$toPaintValue;
        if (paint instanceof Color) {
            paintValue = new PaintValue.Color(((Color)$this$toPaintValue).getRGB());
        } else if (paint instanceof GradientPaint) {
            Object[] objectArray = ((GradientPaint)$this$toPaintValue).getPoint1();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"point1");
            Point point = ConvertKt.toPoint((Point2D)objectArray);
            objectArray = ((GradientPaint)$this$toPaintValue).getPoint2();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"point2");
            Point point2 = ConvertKt.toPoint((Point2D)objectArray);
            objectArray = new Double[]{0.0, 1.0};
            List list = CollectionsKt.listOf((Object[])objectArray);
            objectArray = new Integer[]{((GradientPaint)$this$toPaintValue).getColor1().getRGB(), ((GradientPaint)$this$toPaintValue).getColor2().getRGB()};
            paintValue = new PaintValue.Gradient(point, point2, list, CollectionsKt.listOf((Object[])objectArray));
        } else if (paint instanceof LinearGradientPaint) {
            Collection<Integer> collection;
            boolean bl;
            Collection<Double> collection2;
            Object[] $this$mapTo$iv$iv;
            Object[] $this$map$iv;
            Object object = ((LinearGradientPaint)$this$toPaintValue).getStartPoint();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"startPoint");
            Point point = ConvertKt.toPoint((Point2D)object);
            object = ((LinearGradientPaint)$this$toPaintValue).getEndPoint();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"endPoint");
            Point point3 = ConvertKt.toPoint((Point2D)object);
            object = ((LinearGradientPaint)$this$toPaintValue).getFractions();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fractions");
            Point point4 = point3;
            Point point5 = point;
            boolean $i$f$map = false;
            void var4_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void var10_13 : $this$mapTo$iv$iv) {
                void p0;
                void var11_15 = var10_13;
                collection2 = destination$iv$iv;
                bl = false;
                collection2.add((double)p0);
            }
            collection2 = (List)destination$iv$iv;
            $this$map$iv = ((LinearGradientPaint)$this$toPaintValue).getColors();
            Intrinsics.checkNotNullExpressionValue((Object)$this$map$iv, (String)"colors");
            $this$map$iv = $this$map$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.length);
            $i$f$mapTo = false;
            for (Object object2 : $this$mapTo$iv$iv) {
                void it;
                Color p0 = (Color)object2;
                collection = destination$iv$iv;
                bl = false;
                collection.add(it.getRGB());
            }
            collection = (List)destination$iv$iv;
            List list = collection;
            Collection<Double> collection3 = collection2;
            Point point6 = point4;
            Point point7 = point5;
            paintValue = new PaintValue.Gradient(point7, point6, (List<Double>)collection3, list);
        } else {
            paintValue = paint instanceof MultipleGradientPaint ? (PaintValue)new PaintValue.Unknown("MultipleGradientPaint, maybe split to Linear and Radial") : (paint instanceof TexturePaint ? (PaintValue)new PaintValue.Unknown("TexturePaint") : (PaintValue)new PaintValue.Unknown(String.valueOf(Reflection.getOrCreateKotlinClass($this$toPaintValue.getClass()).getQualifiedName())));
        }
        return paintValue;
    }

    @NotNull
    public static final ServerWindowStateEvent createSetClipEvent(@Nullable Shape identitySpaceClip) {
        Shape $this$createSetClipEvent_u24lambda_u2d2 = identitySpaceClip;
        boolean bl = false;
        Shape shape = $this$createSetClipEvent_u24lambda_u2d2;
        CommonShape commonShape = shape == null ? null : (shape instanceof Rectangle2D ? (CommonShape)new CommonRectangle(((Rectangle2D)$this$createSetClipEvent_u24lambda_u2d2).getX(), ((Rectangle2D)$this$createSetClipEvent_u24lambda_u2d2).getY(), ((Rectangle2D)$this$createSetClipEvent_u24lambda_u2d2).getWidth(), ((Rectangle2D)$this$createSetClipEvent_u24lambda_u2d2).getHeight()) : (CommonShape)ConvertKt.toCommonPath($this$createSetClipEvent_u24lambda_u2d2));
        return new ServerSetClipEvent(commonShape);
    }

    @NotNull
    public static final ServerWindowStateEvent toSetStrokeEvent(@NotNull Stroke $this$toSetStrokeEvent) {
        Intrinsics.checkNotNullParameter((Object)$this$toSetStrokeEvent, (String)"<this>");
        return $this$toSetStrokeEvent instanceof BasicStroke ? (ServerWindowStateEvent)new ServerSetStrokeEvent(ConvertKt.toBasicStrokeData((BasicStroke)$this$toSetStrokeEvent)) : (ServerWindowStateEvent)new ServerSetUnknownStrokeEvent(String.valueOf(Reflection.getOrCreateKotlinClass($this$toSetStrokeEvent.getClass()).getQualifiedName()));
    }

    private static final CommonAlphaComposite toCommonAlphaComposite(AlphaComposite $this$toCommonAlphaComposite) {
        AlphaCompositeRule alphaCompositeRule;
        switch ($this$toCommonAlphaComposite.getRule()) {
            case 3: {
                alphaCompositeRule = AlphaCompositeRule.SRC_OVER;
                break;
            }
            case 4: {
                alphaCompositeRule = AlphaCompositeRule.DST_OVER;
                break;
            }
            case 5: {
                alphaCompositeRule = AlphaCompositeRule.SRC_IN;
                break;
            }
            case 1: {
                alphaCompositeRule = AlphaCompositeRule.CLEAR;
                break;
            }
            case 2: {
                alphaCompositeRule = AlphaCompositeRule.SRC;
                break;
            }
            case 9: {
                alphaCompositeRule = AlphaCompositeRule.DST;
                break;
            }
            case 6: {
                alphaCompositeRule = AlphaCompositeRule.DST_IN;
                break;
            }
            case 7: {
                alphaCompositeRule = AlphaCompositeRule.SRC_OUT;
                break;
            }
            case 8: {
                alphaCompositeRule = AlphaCompositeRule.DST_OUT;
                break;
            }
            case 10: {
                alphaCompositeRule = AlphaCompositeRule.SRC_ATOP;
                break;
            }
            case 11: {
                alphaCompositeRule = AlphaCompositeRule.DST_ATOP;
                break;
            }
            case 12: {
                alphaCompositeRule = AlphaCompositeRule.XOR;
                break;
            }
            default: {
                Logger.DefaultImpls.error$default(logger, null, (Function0)new Function0<String>($this$toCommonAlphaComposite){
                    final /* synthetic */ AlphaComposite $this_toCommonAlphaComposite;
                    {
                        this.$this_toCommonAlphaComposite = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "AlphaComposite.toCommonAlphaComposite: Bad alpha composite rule: " + this.$this_toCommonAlphaComposite.getRule() + ". Returning SRC_OVER.";
                    }
                }, 1, null);
                alphaCompositeRule = AlphaCompositeRule.SRC_OVER;
            }
        }
        AlphaCompositeRule acRule2 = alphaCompositeRule;
        return new CommonAlphaComposite(acRule2, $this$toCommonAlphaComposite.getAlpha());
    }

    @NotNull
    public static final CommonComposite toCommonComposite(@NotNull Composite $this$toCommonComposite) {
        Intrinsics.checkNotNullParameter((Object)$this$toCommonComposite, (String)"<this>");
        return $this$toCommonComposite instanceof AlphaComposite ? (CommonComposite)ConvertKt.toCommonAlphaComposite((AlphaComposite)$this$toCommonComposite) : (CommonComposite)new UnknownComposite("Unknown composite class: " + $this$toCommonComposite.getClass().getCanonicalName());
    }

    public static final double roundToInfinity(double x) {
        return Double.isNaN(x) || Double.isInfinite(x) ? x : (x > 0.0 ? Math.ceil(x) : Math.floor(x));
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[StrokeData.Basic.CapType.values().length];
            nArray[StrokeData.Basic.CapType.BUTT.ordinal()] = 1;
            nArray[StrokeData.Basic.CapType.SQUARE.ordinal()] = 2;
            nArray[StrokeData.Basic.CapType.ROUND.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[StrokeData.Basic.JoinType.values().length];
            nArray[StrokeData.Basic.JoinType.MITER.ordinal()] = 1;
            nArray[StrokeData.Basic.JoinType.BEVEL.ordinal()] = 2;
            nArray[StrokeData.Basic.JoinType.ROUND.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

