/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.api;

import com.intellij.collaboration.api.ServerPath;
import com.intellij.collaboration.util.URIUtilKt;
import com.intellij.openapi.util.NlsSafe;
import java.net.URI;
import java.net.URL;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.GitLabServerPath$;

@Serializable
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 '2\u00020\u0001:\u0002&'B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B#\b\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u0017\u001a\u00020\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u0007H\u0016J\b\u0010\u001b\u001a\u00020\u0004H\u0017J\b\u0010\u001c\u001a\u00020\fH\u0016J\u0006\u0010\u001d\u001a\u00020\u001eJ!\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u00c7\u0001R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000eR\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006("}, d2={"Lorg/jetbrains/plugins/gitlab/api/GitLabServerPath;", "Lcom/intellij/collaboration/api/ServerPath;", "()V", "uri", "", "(Ljava/lang/String;)V", "seen1", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "gqlApiUri", "Ljava/net/URI;", "getGqlApiUri", "()Ljava/net/URI;", "isDefault", "", "()Z", "restApiUri", "getRestApiUri", "<set-?>", "getUri", "()Ljava/lang/String;", "equals", "other", "", "hashCode", "toString", "toURI", "toURL", "Ljava/net/URL;", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "$serializer", "Companion", "intellij.vcs.gitlab"})
public final class GitLabServerPath
implements ServerPath {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String uri;
    @NotNull
    private static final GitLabServerPath DEFAULT_SERVER = new GitLabServerPath("https://gitlab.com");

    @NotNull
    public final String getUri() {
        return this.uri;
    }

    public GitLabServerPath() {
        this.uri = "";
    }

    public GitLabServerPath(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.uri = "";
        if (!(((CharSequence)uri).length() > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(!StringsKt.endsWith$default((CharSequence)uri, (char)'/', (boolean)false, (int)2, null))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        URI validation = URI.create(uri);
        if (!(validation.getScheme() != null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        String string = validation.getScheme();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"validation.scheme");
        if (!StringsKt.startsWith$default((String)string, (String)"http", (boolean)false, (int)2, null)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.uri = uri;
    }

    @NotNull
    public final URI getGqlApiUri() {
        return URIUtilKt.resolveRelative((URI)this.toURI(), (String)"api/graphql/");
    }

    @NotNull
    public final URI getRestApiUri() {
        return URIUtilKt.resolveRelative((URI)this.toURI(), (String)"api/v4/");
    }

    public final boolean isDefault() {
        return StringsKt.startsWith((String)this.uri, (String)"gitlab.com", (boolean)true) || StringsKt.contains((CharSequence)this.uri, (CharSequence)"/gitlab.com", (boolean)true);
    }

    @NotNull
    public final URL toURL() {
        return new URL(this.uri + "/");
    }

    @NotNull
    public URI toURI() {
        URI uRI = URI.create(this.uri + "/");
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(\"$uri/\")");
        return uRI;
    }

    @NlsSafe
    @NotNull
    public String toString() {
        return this.uri;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GitLabServerPath)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.uri, (Object)((GitLabServerPath)other).uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self(GitLabServerPath self, CompositeEncoder output, SerialDescriptor serialDesc) {
        if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : !Intrinsics.areEqual((Object)self.uri, (Object)"")) {
            output.encodeStringElement(serialDesc, 0, self.uri);
        }
    }

    @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
    public /* synthetic */ GitLabServerPath(int seen1, String uri, SerializationConstructorMarker serializationConstructorMarker) {
        if ((0 & seen1) != 0) {
            PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)0, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.uri = (seen1 & 1) == 0 ? "" : uri;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u00c6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/gitlab/api/GitLabServerPath$Companion;", "", "()V", "DEFAULT_SERVER", "Lorg/jetbrains/plugins/gitlab/api/GitLabServerPath;", "getDEFAULT_SERVER", "()Lorg/jetbrains/plugins/gitlab/api/GitLabServerPath;", "serializer", "Lkotlinx/serialization/KSerializer;", "intellij.vcs.gitlab"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GitLabServerPath getDEFAULT_SERVER() {
            return DEFAULT_SERVER;
        }

        @NotNull
        public final KSerializer<GitLabServerPath> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

