/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.mergerequest.ui.list;

import com.intellij.collaboration.ui.codereview.list.NamedCollection;
import com.intellij.collaboration.ui.codereview.list.ReviewListComponentFactory;
import com.intellij.collaboration.ui.codereview.list.ReviewListItemPresentation;
import com.intellij.collaboration.ui.codereview.list.TagPresentation;
import com.intellij.collaboration.ui.codereview.list.UserPresentation;
import com.intellij.collaboration.ui.icon.IconsProvider;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.components.JBList;
import icons.CollaborationToolsIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ListModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gitlab.api.dto.GitLabUserDTO;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabMergeRequestDetails;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabMergeRequestState;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabMergeStatus;
import org.jetbrains.plugins.gitlab.util.GitLabBundle;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001f\u0010\u000f\u001a\t\u0018\u00010\u000e\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\n2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/list/GitLabMergeRequestsListComponentFactory;", "", "()V", "create", "Lcom/intellij/ui/components/JBList;", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequestDetails;", "listModel", "Lcom/intellij/ui/CollectionListModel;", "avatarIconsProvider", "Lcom/intellij/collaboration/ui/icon/IconsProvider;", "Lorg/jetbrains/plugins/gitlab/api/dto/GitLabUserDTO;", "getLabelPresentation", "Lcom/intellij/collaboration/ui/codereview/list/TagPresentation;", "label", "", "getMergeStateText", "Lcom/intellij/openapi/util/NlsSafe;", "mergeRequestState", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequestState;", "isDraft", "", "getMergeableStatus", "Lcom/intellij/collaboration/ui/codereview/list/ReviewListItemPresentation$Status;", "mergeStatus", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeStatus;", "userPresentation", "Lcom/intellij/collaboration/ui/codereview/list/UserPresentation;", "user", "intellij.vcs.gitlab"})
public final class GitLabMergeRequestsListComponentFactory {
    @NotNull
    public static final GitLabMergeRequestsListComponentFactory INSTANCE = new GitLabMergeRequestsListComponentFactory();

    private GitLabMergeRequestsListComponentFactory() {
    }

    @NotNull
    public final JBList<GitLabMergeRequestDetails> create(@NotNull CollectionListModel<GitLabMergeRequestDetails> listModel, @NotNull IconsProvider<GitLabUserDTO> avatarIconsProvider) {
        Intrinsics.checkNotNullParameter(listModel, (String)"listModel");
        Intrinsics.checkNotNullParameter(avatarIconsProvider, (String)"avatarIconsProvider");
        return new ReviewListComponentFactory((ListModel)listModel).create((Function1)new Function1<GitLabMergeRequestDetails, ReviewListItemPresentation>(avatarIconsProvider){
            final /* synthetic */ IconsProvider<GitLabUserDTO> $avatarIconsProvider;
            {
                this.$avatarIconsProvider = $avatarIconsProvider;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ReviewListItemPresentation invoke(GitLabMergeRequestDetails mergeRequest) {
                Collection<UserPresentation> collection;
                GitLabUserDTO assignee;
                Object object;
                GitLabUserDTO p0;
                Collection<TagPresentation> collection2;
                T item$iv$iv;
                Object $this$mapTo$iv$iv;
                Object $this$map$iv;
                Object object2 = new Object[]{mergeRequest.getLabels().size()};
                String string = GitLabBundle.message("merge.request.list.renderer.labels.popup", object2);
                object2 = mergeRequest.getLabels();
                IconsProvider<GitLabUserDTO> iconsProvider = GitLabMergeRequestsListComponentFactory.INSTANCE;
                String string2 = string;
                NamedCollection.Companion companion = NamedCollection.Companion;
                UserPresentation userPresentation = GitLabMergeRequestsListComponentFactory.access$userPresentation(GitLabMergeRequestsListComponentFactory.INSTANCE, mergeRequest.getAuthor(), this.$avatarIconsProvider);
                Date date = mergeRequest.getCreatedAt();
                String string3 = "!" + mergeRequest.getIid();
                String string4 = mergeRequest.getTitle();
                boolean $i$f$map = false;
                void var5_11 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    item$iv$iv = iterator.next();
                    String string5 = (String)item$iv$iv;
                    collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(GitLabMergeRequestsListComponentFactory.access$getLabelPresentation((GitLabMergeRequestsListComponentFactory)iconsProvider, (String)((Object)p0)));
                }
                collection2 = (List)destination$iv$iv;
                NamedCollection namedCollection = companion.create(string2, (List)collection2);
                $this$map$iv = new Object[]{mergeRequest.getAssignees().size()};
                String string6 = GitLabBundle.message("merge.request.list.renderer.user.assignees", (Object[])$this$map$iv);
                $this$map$iv = mergeRequest.getAssignees();
                iconsProvider = this.$avatarIconsProvider;
                String string7 = string6;
                NamedCollection.Companion companion2 = NamedCollection.Companion;
                String string8 = GitLabMergeRequestsListComponentFactory.access$getMergeStateText(GitLabMergeRequestsListComponentFactory.INSTANCE, mergeRequest.getState(), mergeRequest.getDraft());
                collection2 = null;
                string2 = GitLabMergeRequestsListComponentFactory.access$getMergeableStatus(GitLabMergeRequestsListComponentFactory.INSTANCE, mergeRequest.getMergeStatus());
                companion = namedCollection;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    item$iv$iv = iterator.next();
                    p0 = (GitLabUserDTO)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl = false;
                    object.add(GitLabMergeRequestsListComponentFactory.access$userPresentation(GitLabMergeRequestsListComponentFactory.INSTANCE, assignee, iconsProvider));
                }
                object = (List)destination$iv$iv;
                NamedCollection namedCollection2 = companion2.create(string7, (List)object);
                $this$map$iv = new Object[]{mergeRequest.getReviewers().size()};
                String string9 = GitLabBundle.message("merge.request.list.renderer.user.reviewers", (Object[])$this$map$iv);
                $this$map$iv = mergeRequest.getReviewers();
                iconsProvider = this.$avatarIconsProvider;
                object = string9;
                string7 = NamedCollection.Companion;
                companion2 = namedCollection2;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void reviewer;
                    item$iv$iv = iterator.next();
                    assignee = (GitLabUserDTO)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(GitLabMergeRequestsListComponentFactory.access$userPresentation(GitLabMergeRequestsListComponentFactory.INSTANCE, (GitLabUserDTO)reviewer, iconsProvider));
                }
                collection = (List)destination$iv$iv;
                ReviewListItemPresentation.CommentsCounter commentsCounter = null;
                NamedCollection namedCollection3 = string7.create((String)object, collection);
                NamedCollection.Companion companion3 = companion2;
                String string10 = string8;
                Collection<TagPresentation> collection3 = collection2;
                String string11 = string2;
                NamedCollection.Companion companion4 = companion;
                UserPresentation userPresentation2 = userPresentation;
                Date date2 = date;
                String string12 = string3;
                String string13 = string4;
                return (ReviewListItemPresentation)new ReviewListItemPresentation.Simple(string13, string12, date2, userPresentation2, (NamedCollection)companion4, (ReviewListItemPresentation.Status)string11, collection3, string10, (NamedCollection)companion3, namedCollection3, commentsCounter);
            }
        });
    }

    private final TagPresentation getLabelPresentation(String label) {
        return (TagPresentation)new TagPresentation.Simple(label, null);
    }

    private final UserPresentation userPresentation(GitLabUserDTO user2, IconsProvider<GitLabUserDTO> avatarIconsProvider) {
        return (UserPresentation)new UserPresentation.Simple(user2.getUsername(), user2.getName(), avatarIconsProvider.getIcon((Object)user2, 20));
    }

    private final ReviewListItemPresentation.Status getMergeableStatus(GitLabMergeStatus mergeStatus) {
        if (mergeStatus == GitLabMergeStatus.CANNOT_BE_MERGED) {
            Icon icon = CollaborationToolsIcons.Review.NonMergeable;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"NonMergeable");
            return new ReviewListItemPresentation.Status(icon, GitLabBundle.message("merge.request.list.renderer.merge.conflict.tooltip", new Object[0]));
        }
        return null;
    }

    private final String getMergeStateText(GitLabMergeRequestState mergeRequestState, boolean isDraft) {
        if (mergeRequestState == GitLabMergeRequestState.OPENED && !isDraft) {
            return null;
        }
        if (isDraft) {
            return GitLabBundle.message("merge.request.list.renderer.state.draft", new Object[0]);
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[mergeRequestState.ordinal()]) {
            case 1 -> GitLabBundle.message("merge.request.list.renderer.state.closed", new Object[0]);
            case 2 -> GitLabBundle.message("merge.request.list.renderer.state.merged", new Object[0]);
            default -> null;
        };
    }

    public static final /* synthetic */ UserPresentation access$userPresentation(GitLabMergeRequestsListComponentFactory $this, GitLabUserDTO user2, IconsProvider avatarIconsProvider) {
        return $this.userPresentation(user2, (IconsProvider<GitLabUserDTO>)avatarIconsProvider);
    }

    public static final /* synthetic */ ReviewListItemPresentation.Status access$getMergeableStatus(GitLabMergeRequestsListComponentFactory $this, GitLabMergeStatus mergeStatus) {
        return $this.getMergeableStatus(mergeStatus);
    }

    public static final /* synthetic */ String access$getMergeStateText(GitLabMergeRequestsListComponentFactory $this, GitLabMergeRequestState mergeRequestState, boolean isDraft) {
        return $this.getMergeStateText(mergeRequestState, isDraft);
    }

    public static final /* synthetic */ TagPresentation access$getLabelPresentation(GitLabMergeRequestsListComponentFactory $this, String label) {
        return $this.getLabelPresentation(label);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GitLabMergeRequestState.values().length];
            try {
                nArray[GitLabMergeRequestState.CLOSED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GitLabMergeRequestState.MERGED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

