/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.mergerequest.ui.toolwindow;

import com.intellij.collaboration.auth.ServerAccount;
import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.collaboration.ui.ExceptionUtil;
import com.intellij.collaboration.ui.codereview.list.error.ErrorStatusPresenter;
import com.intellij.openapi.project.Project;
import git4idea.remote.hosting.ui.RepositoryAndAccountSelectorViewModel;
import javax.swing.Action;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.authentication.accounts.GitLabAccount;
import org.jetbrains.plugins.gitlab.authentication.accounts.GitLabAccountManager;
import org.jetbrains.plugins.gitlab.exception.GitLabHttpStatusErrorAction;
import org.jetbrains.plugins.gitlab.util.GitLabBundle;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/toolwindow/GitLabSelectorErrorStatusPresenter;", "Lcom/intellij/collaboration/ui/codereview/list/error/ErrorStatusPresenter;", "Lgit4idea/remote/hosting/ui/RepositoryAndAccountSelectorViewModel$Error;", "project", "Lcom/intellij/openapi/project/Project;", "parentScope", "Lkotlinx/coroutines/CoroutineScope;", "accountManager", "Lorg/jetbrains/plugins/gitlab/authentication/accounts/GitLabAccountManager;", "resetAction", "Lkotlin/Function0;", "", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;Lorg/jetbrains/plugins/gitlab/authentication/accounts/GitLabAccountManager;Lkotlin/jvm/functions/Function0;)V", "getErrorAction", "Ljavax/swing/Action;", "error", "getErrorDescription", "", "getErrorTitle", "intellij.vcs.gitlab"})
public final class GitLabSelectorErrorStatusPresenter
implements ErrorStatusPresenter<RepositoryAndAccountSelectorViewModel.Error> {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope parentScope;
    @NotNull
    private final GitLabAccountManager accountManager;
    @NotNull
    private final Function0<Unit> resetAction;

    public GitLabSelectorErrorStatusPresenter(@NotNull Project project, @NotNull CoroutineScope parentScope, @NotNull GitLabAccountManager accountManager, @NotNull Function0<Unit> resetAction) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
        Intrinsics.checkNotNullParameter((Object)accountManager, (String)"accountManager");
        Intrinsics.checkNotNullParameter(resetAction, (String)"resetAction");
        this.project = project;
        this.parentScope = parentScope;
        this.accountManager = accountManager;
        this.resetAction = resetAction;
    }

    @NotNull
    public String getErrorTitle(@NotNull RepositoryAndAccountSelectorViewModel.Error error) {
        String string;
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        RepositoryAndAccountSelectorViewModel.Error error2 = error;
        if (error2 instanceof RepositoryAndAccountSelectorViewModel.Error.SubmissionError) {
            Object[] objectArray = new Object[]{((RepositoryAndAccountSelectorViewModel.Error.SubmissionError)error).getRepo().getRepository(), ((RepositoryAndAccountSelectorViewModel.Error.SubmissionError)error).getAccount()};
            String string2 = CollaborationToolsBundle.message((String)"review.list.connection.failed.repository.account", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\n      \"review.l\u2026      error.account\n    )");
            string = string2;
        } else if (error2 instanceof RepositoryAndAccountSelectorViewModel.Error.MissingCredentials) {
            String string3 = CollaborationToolsBundle.message((String)"review.list.connection.failed", (Object[])new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"review.list.connection.failed\")");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public String getErrorDescription(@NotNull RepositoryAndAccountSelectorViewModel.Error error) {
        String string;
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        RepositoryAndAccountSelectorViewModel.Error error2 = error;
        if (error2 instanceof RepositoryAndAccountSelectorViewModel.Error.SubmissionError) {
            string = ExceptionUtil.INSTANCE.getPresentableMessage(((RepositoryAndAccountSelectorViewModel.Error.SubmissionError)error).getException());
        } else if (error2 instanceof RepositoryAndAccountSelectorViewModel.Error.MissingCredentials) {
            string = GitLabBundle.message("account.token.missing", new Object[0]);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @Nullable
    public Action getErrorAction(@NotNull RepositoryAndAccountSelectorViewModel.Error error) {
        Action action;
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        if (error instanceof RepositoryAndAccountSelectorViewModel.Error.SubmissionError) {
            ServerAccount serverAccount = ((RepositoryAndAccountSelectorViewModel.Error.SubmissionError)error).getAccount();
            Intrinsics.checkNotNull((Object)serverAccount, (String)"null cannot be cast to non-null type org.jetbrains.plugins.gitlab.authentication.accounts.GitLabAccount");
            action = new GitLabHttpStatusErrorAction.LogInAgain(this.project, this.parentScope, (GitLabAccount)serverAccount, this.accountManager, this.resetAction);
        } else {
            action = null;
        }
        return action;
    }
}

