/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.runtime.repository.serialization.impl;

import com.intellij.platform.runtime.repository.IncludedRuntimeModule;
import com.intellij.platform.runtime.repository.ModuleImportance;
import com.intellij.platform.runtime.repository.ProductModules;
import com.intellij.platform.runtime.repository.RuntimeModuleGroup;
import com.intellij.platform.runtime.repository.RuntimeModuleId;
import com.intellij.platform.runtime.repository.RuntimeModuleRepository;
import com.intellij.platform.runtime.repository.impl.IncludedRuntimeModuleImpl;
import com.intellij.platform.runtime.repository.impl.MainRuntimeModuleGroup;
import com.intellij.platform.runtime.repository.impl.PluginModuleGroup;
import com.intellij.platform.runtime.repository.impl.ProductModulesImpl;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jetbrains.annotations.NotNull;

public final class ProductModulesXmlLoader {
    @NotNull
    public static ProductModules parseModuleXml(@NotNull InputStream inputStream, @NotNull String debugName, @NotNull RuntimeModuleRepository repository) throws XMLStreamException {
        if (inputStream == null) {
            ProductModulesXmlLoader.$$$reportNull$$$0(0);
        }
        if (debugName == null) {
            ProductModulesXmlLoader.$$$reportNull$$$0(1);
        }
        if (repository == null) {
            ProductModulesXmlLoader.$$$reportNull$$$0(2);
        }
        XMLStreamReader reader = XMLInputFactory.newDefaultFactory().createXMLStreamReader(inputStream);
        int level = 0;
        ModuleImportance importance = null;
        String moduleName = null;
        ArrayList<IncludedRuntimeModule> rootMainGroupModules = new ArrayList<IncludedRuntimeModule>();
        ArrayList<RuntimeModuleGroup> bundledPluginModuleGroups = new ArrayList<RuntimeModuleGroup>();
        String parentTag = null;
        while (reader.hasNext()) {
            int event = reader.next();
            if (event == 1) {
                String tagName = reader.getLocalName();
                if (++level == 2) {
                    parentTag = tagName;
                    continue;
                }
                if (level != 3 || !tagName.equals("module")) continue;
                if (reader.getAttributeCount() > 0) {
                    String attributeName = reader.getAttributeLocalName(0);
                    if (!"importance".equals(attributeName)) {
                        throw new XMLStreamException("Unexpected attribute '" + attributeName + "'");
                    }
                    importance = ModuleImportance.valueOf(reader.getAttributeValue(0).toUpperCase(Locale.US));
                    continue;
                }
                importance = ModuleImportance.FUNCTIONAL;
                continue;
            }
            if (event == 4) {
                if (level != 3) continue;
                moduleName = reader.getText().trim();
                continue;
            }
            if (event != 2) continue;
            if (--level == 2) {
                if (moduleName == null || moduleName.isEmpty()) {
                    throw new XMLStreamException("Module name is not specified");
                }
                if ("main-root-modules".equals(parentTag)) {
                    assert (importance != null);
                    rootMainGroupModules.add(new IncludedRuntimeModuleImpl(repository.getModule(RuntimeModuleId.raw(moduleName)), importance, Collections.emptySet()));
                } else {
                    bundledPluginModuleGroups.add(new PluginModuleGroup(repository.getModule(RuntimeModuleId.raw(moduleName))));
                }
                moduleName = null;
                importance = null;
            }
            if (level != 0) continue;
            break;
        }
        reader.close();
        MainRuntimeModuleGroup mainGroup = new MainRuntimeModuleGroup(rootMainGroupModules);
        return new ProductModulesImpl(debugName, mainGroup, bundledPluginModuleGroups);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "inputStream";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "debugName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "repository";
                break;
            }
        }
        objectArray[1] = "com/intellij/platform/runtime/repository/serialization/impl/ProductModulesXmlLoader";
        objectArray[2] = "parseModuleXml";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

