/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import java.util.Collection;
import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.internal.DelegatingDomainObjectSet;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.MutationValidator;
import org.gradle.api.internal.artifacts.dependencies.AbstractModuleDependency;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.Actions;

public class DefaultDependencySet
extends DelegatingDomainObjectSet<Dependency>
implements DependencySet {
    private final Describable displayName;
    private final ConfigurationInternal clientConfiguration;
    private final Action<? super ModuleDependency> mutationValidator;

    public DefaultDependencySet(Describable displayName, ConfigurationInternal clientConfiguration, DomainObjectSet<Dependency> backingSet) {
        super(backingSet);
        this.displayName = displayName;
        this.clientConfiguration = clientConfiguration;
        this.mutationValidator = this.toMutationValidator(clientConfiguration);
    }

    protected Action<ModuleDependency> toMutationValidator(Configuration clientConfiguration) {
        return clientConfiguration instanceof MutationValidator ? new MutationValidationAction(clientConfiguration) : Actions.doNothing();
    }

    public String toString() {
        return this.displayName.getDisplayName();
    }

    @Override
    public TaskDependency getBuildDependencies() {
        return this.clientConfiguration.getBuildDependencies();
    }

    @Override
    public boolean add(Dependency o) {
        this.assertConfigurationIsDeclarable();
        this.clientConfiguration.maybeEmitDeclarationDeprecation();
        if (o instanceof AbstractModuleDependency) {
            ((AbstractModuleDependency)o).addMutationValidator(this.mutationValidator);
        }
        return super.add(o);
    }

    private void assertConfigurationIsDeclarable() {
        if (!this.clientConfiguration.isCanBeDeclared()) {
            throw new GradleException("Dependencies can not be declared against the `" + this.clientConfiguration.getName() + "` configuration.");
        }
    }

    @Override
    public boolean addAll(Collection<? extends Dependency> dependencies) {
        boolean added = false;
        for (Dependency dependency : dependencies) {
            added |= this.add(dependency);
        }
        return added;
    }

    private static class MutationValidationAction
    implements Action<ModuleDependency> {
        private final Configuration clientConfiguration;

        public MutationValidationAction(Configuration clientConfiguration) {
            this.clientConfiguration = clientConfiguration;
        }

        @Override
        public void execute(ModuleDependency moduleDependency) {
            ((MutationValidator)((Object)this.clientConfiguration)).validateMutation(MutationValidator.MutationType.DEPENDENCY_ATTRIBUTES);
        }
    }
}

