/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import org.gradle.api.artifacts.ComponentMetadataContext;
import org.gradle.api.artifacts.ComponentMetadataDetails;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.dsl.MetadataDescriptorFactory;
import org.gradle.api.internal.artifacts.dsl.dependencies.PlatformSupport;
import org.gradle.api.internal.artifacts.repositories.resolver.ComponentMetadataDetailsAdapter;
import org.gradle.api.internal.artifacts.repositories.resolver.DependencyConstraintMetadataImpl;
import org.gradle.api.internal.artifacts.repositories.resolver.DirectDependencyMetadataImpl;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.VariantDerivationStrategy;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;

class WrappingComponentMetadataContext
implements ComponentMetadataContext {
    private final ModuleComponentResolveMetadata metadata;
    private final Instantiator instantiator;
    private final NotationParser<Object, DirectDependencyMetadataImpl> dependencyMetadataNotationParser;
    private final NotationParser<Object, DependencyConstraintMetadataImpl> dependencyConstraintMetadataNotationParser;
    private final NotationParser<Object, ComponentIdentifier> componentIdentifierParser;
    private final PlatformSupport platformSupport;
    private final MetadataDescriptorFactory descriptorFactory;
    private MutableModuleComponentResolveMetadata mutableMetadata;
    private ComponentMetadataDetails details;

    public WrappingComponentMetadataContext(ModuleComponentResolveMetadata metadata, Instantiator instantiator2, NotationParser<Object, DirectDependencyMetadataImpl> dependencyMetadataNotationParser, NotationParser<Object, DependencyConstraintMetadataImpl> dependencyConstraintMetadataNotationParser, NotationParser<Object, ComponentIdentifier> componentIdentifierParser, PlatformSupport platformSupport) {
        this.metadata = metadata;
        this.instantiator = instantiator2;
        this.dependencyMetadataNotationParser = dependencyMetadataNotationParser;
        this.dependencyConstraintMetadataNotationParser = dependencyConstraintMetadataNotationParser;
        this.componentIdentifierParser = componentIdentifierParser;
        this.platformSupport = platformSupport;
        this.descriptorFactory = new MetadataDescriptorFactory(metadata);
    }

    @Override
    public <T> T getDescriptor(Class<T> descriptorClass) {
        return this.descriptorFactory.createDescriptor(descriptorClass);
    }

    @Override
    public ComponentMetadataDetails getDetails() {
        this.createMutableMetadataIfNeeded();
        if (this.details == null) {
            this.details = this.instantiator.newInstance(ComponentMetadataDetailsAdapter.class, this.mutableMetadata, this.instantiator, this.dependencyMetadataNotationParser, this.dependencyConstraintMetadataNotationParser, this.componentIdentifierParser, this.platformSupport);
        }
        return this.details;
    }

    VariantDerivationStrategy getVariantDerivationStrategy() {
        return this.metadata.getVariantDerivationStrategy();
    }

    ModuleComponentResolveMetadata getImmutableMetadataWithDerivationStrategy(VariantDerivationStrategy variantDerivationStrategy) {
        return this.createMutableMetadataIfNeeded().asImmutable().withDerivationStrategy(variantDerivationStrategy);
    }

    private MutableModuleComponentResolveMetadata createMutableMetadataIfNeeded() {
        if (this.mutableMetadata == null) {
            this.mutableMetadata = this.metadata.asMutable();
        }
        return this.mutableMetadata;
    }
}

