/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.internal.DisplayName;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public class ResolvedFilesCollectingVisitor
implements ArtifactVisitor {
    private final Set<File> files = Sets.newLinkedHashSet();
    private final Set<Throwable> failures = Sets.newLinkedHashSet();

    @Override
    public void visitArtifact(DisplayName variantName, AttributeContainer variantAttributes, List<? extends Capability> capabilities, ResolvableArtifact artifact) {
        try {
            File file = artifact.getFile();
            this.files.add(file);
        }
        catch (Exception t) {
            this.failures.add(t);
        }
    }

    @Override
    public boolean requireArtifactFiles() {
        return true;
    }

    @Override
    public void visitFailure(Throwable failure) {
        this.failures.add(failure);
    }

    public Set<File> getFiles() {
        return this.files;
    }

    public Collection<Throwable> getFailures() {
        return this.failures;
    }
}

