/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import javax.annotation.Nullable;
import org.gradle.api.Describable;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformDependencies;
import org.gradle.api.internal.artifacts.transform.TransformUpstreamDependencies;
import org.gradle.api.internal.artifacts.transform.TransformationSubject;
import org.gradle.api.internal.artifacts.transform.Transformer;
import org.gradle.api.internal.artifacts.transform.TransformerInvocationFactory;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.internal.Cast;
import org.gradle.internal.Deferrable;
import org.gradle.internal.Try;
import org.gradle.internal.execution.InputFingerprinter;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformationStep
implements TaskDependencyContainer,
Describable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformationStep.class);
    private final Transformer transformer;
    private final TransformerInvocationFactory transformerInvocationFactory;
    private final ProjectInternal owningProject;
    private final InputFingerprinter globalInputFingerprinter;

    public TransformationStep(Transformer transformer, TransformerInvocationFactory transformerInvocationFactory, DomainObjectContext owner, InputFingerprinter globalInputFingerprinter) {
        this.transformer = transformer;
        this.transformerInvocationFactory = transformerInvocationFactory;
        this.globalInputFingerprinter = globalInputFingerprinter;
        this.owningProject = owner.getProject();
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    @Nullable
    public ProjectInternal getOwningProject() {
        return this.owningProject;
    }

    public Deferrable<Try<TransformationSubject>> createInvocation(TransformationSubject subjectToTransform, TransformUpstreamDependencies upstreamDependencies, @Nullable NodeExecutionContext context) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Transforming {} with {}", (Object)subjectToTransform.getDisplayName(), (Object)this.transformer.getDisplayName());
        }
        InputFingerprinter inputFingerprinter = context != null ? context.getService(InputFingerprinter.class) : this.globalInputFingerprinter;
        Try<ArtifactTransformDependencies> resolvedDependencies = upstreamDependencies.computeArtifacts();
        return resolvedDependencies.map(dependencies -> {
            ImmutableList<File> inputArtifacts = subjectToTransform.getFiles();
            if (inputArtifacts.isEmpty()) {
                return Deferrable.completed(Try.successful(subjectToTransform.createSubjectFromResult((ImmutableList<File>)ImmutableList.of())));
            }
            if (inputArtifacts.size() > 1) {
                return Deferrable.deferred(() -> this.doTransform(subjectToTransform, inputFingerprinter, (ArtifactTransformDependencies)dependencies, inputArtifacts));
            }
            File inputArtifact = (File)inputArtifacts.get(0);
            return this.transformerInvocationFactory.createInvocation(this.transformer, inputArtifact, (ArtifactTransformDependencies)dependencies, subjectToTransform, inputFingerprinter).map(result2 -> result2.map(subjectToTransform::createSubjectFromResult));
        }).getOrMapFailure(failure -> Deferrable.completed(Try.failure(failure)));
    }

    private Try<TransformationSubject> doTransform(TransformationSubject subjectToTransform, InputFingerprinter inputFingerprinter, ArtifactTransformDependencies dependencies, ImmutableList<File> inputArtifacts) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (File inputArtifact : inputArtifacts) {
            Try<ImmutableList<File>> result2 = this.transformerInvocationFactory.createInvocation(this.transformer, inputArtifact, dependencies, subjectToTransform, inputFingerprinter).completeAndGet();
            if (result2.getFailure().isPresent()) {
                return (Try)Cast.uncheckedCast(result2);
            }
            builder.addAll((Iterable)result2.get());
        }
        return Try.successful(subjectToTransform.createSubjectFromResult((ImmutableList<File>)builder.build()));
    }

    public void isolateParametersIfNotAlready() {
        this.transformer.isolateParametersIfNotAlready();
    }

    public boolean requiresDependencies() {
        return this.transformer.requiresDependencies();
    }

    @Override
    public String getDisplayName() {
        return this.transformer.getDisplayName();
    }

    public ImmutableAttributes getFromAttributes() {
        return this.transformer.getFromAttributes();
    }

    public String toString() {
        return this.transformer.getDisplayName();
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        this.transformer.visitDependencies(context);
    }
}

