/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.notations;

import javax.annotation.Nullable;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.internal.artifacts.dsl.dependencies.ModuleFactoryHelper;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.MapKey;
import org.gradle.internal.typeconversion.MapNotationConverter;

public class DependencyMapNotationConverter<T>
extends MapNotationConverter<T> {
    private final Instantiator instantiator;
    private final Class<T> resultingType;

    public DependencyMapNotationConverter(Instantiator instantiator2, Class<T> resultingType) {
        this.instantiator = instantiator2;
        this.resultingType = resultingType;
    }

    @Override
    public void describe(DiagnosticsVisitor visitor) {
        visitor.candidate("Maps").example("[group: 'org.gradle', name: 'gradle-core', version: '1.0']");
    }

    protected T parseMap(@MapKey(value="group") @Nullable String group, @MapKey(value="name") @Nullable String name, @MapKey(value="version") @Nullable String version, @MapKey(value="configuration") @Nullable String configuration, @MapKey(value="ext") @Nullable String ext, @MapKey(value="classifier") @Nullable String classifier) {
        T dependency = configuration == null ? this.instantiator.newInstance(this.resultingType, group, name, version) : this.instantiator.newInstance(this.resultingType, group, name, version, configuration);
        if (dependency instanceof ExternalDependency) {
            ModuleFactoryHelper.addExplicitArtifactsIfDefined((ExternalDependency)dependency, ext, classifier);
        }
        return dependency;
    }
}

