/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.properties.PropertyValidationContext;
import org.gradle.api.internal.tasks.properties.ValidatingProperty;
import org.gradle.api.internal.tasks.properties.ValidationAction;
import org.gradle.api.provider.Provider;
import org.gradle.internal.impldep.com.google.common.base.Suppliers;
import org.gradle.internal.properties.PropertyValue;
import org.gradle.internal.reflect.problems.ValidationProblemId;
import org.gradle.internal.reflect.validation.PropertyProblemBuilder;
import org.gradle.internal.reflect.validation.Severity;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.util.internal.DeferredUtil;

public abstract class AbstractValidatingProperty
implements ValidatingProperty {
    private final String propertyName;
    private final PropertyValue value;
    private final boolean optional;
    private final ValidationAction validationAction;

    public AbstractValidatingProperty(String propertyName, PropertyValue value, boolean optional, ValidationAction validationAction) {
        this.propertyName = propertyName;
        this.value = value;
        this.optional = optional;
        this.validationAction = validationAction;
    }

    public static void reportValueNotSet(String propertyName, TypeValidationContext context) {
        context.visitPropertyProblem(problem2 -> ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)problem2.withId(ValidationProblemId.VALUE_NOT_SET)).reportAs(Severity.ERROR)).forProperty(propertyName).withDescription("doesn't have a configured value")).happensBecause("This property isn't marked as optional and no value has been configured")).addPossibleSolution(() -> "Assign a value to '" + propertyName + "'")).addPossibleSolution(() -> "Mark property '" + propertyName + "' as optional")).documentedAt("validation_problems", "value_not_set"));
    }

    @Override
    public void validate(PropertyValidationContext context) {
        Object unnested = DeferredUtil.unpackNestableDeferred(this.value.call());
        if (AbstractValidatingProperty.isPresent(unnested)) {
            org.gradle.internal.impldep.com.google.common.base.Supplier valueSupplier = Suppliers.memoize(() -> DeferredUtil.unpack(unnested));
            this.validationAction.validate(this.propertyName, (Supplier<Object>)valueSupplier, context);
        } else if (!this.optional) {
            AbstractValidatingProperty.reportValueNotSet(this.propertyName, context);
        }
    }

    private static boolean isPresent(@Nullable Object value) {
        if (value instanceof Provider) {
            return ((Provider)value).isPresent();
        }
        return value != null;
    }

    @Override
    public void prepareValue() {
        this.value.maybeFinalizeValue();
    }

    @Override
    public void cleanupValue() {
    }
}

