/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit.result;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.junit.result.TestClassResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestMethodResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestOutputStore;
import org.gradle.api.tasks.testing.TestDescriptor;
import org.gradle.api.tasks.testing.TestListener;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestOutputListener;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.impldep.com.google.common.collect.ArrayListMultimap;
import org.gradle.internal.impldep.com.google.common.collect.ListMultimap;
import org.gradle.internal.serialize.PlaceholderExceptionSupport;

public class TestReportDataCollector
implements TestListener,
TestOutputListener {
    public static final String EXECUTION_FAILURE = "failed to execute tests";
    private final Map<String, TestClassResult> results;
    private final TestOutputStore.Writer outputWriter;
    private final Map<TestDescriptor, TestMethodResult> currentTestMethods = new HashMap<TestDescriptor, TestMethodResult>();
    private final ListMultimap<Object, TestOutputEvent> pendingOutputEvents = ArrayListMultimap.create();
    private long internalIdCounter = 1L;

    public TestReportDataCollector(Map<String, TestClassResult> results, TestOutputStore.Writer outputWriter) {
        this.results = results;
        this.outputWriter = outputWriter;
    }

    @Override
    public void beforeSuite(TestDescriptor suite) {
    }

    @Override
    public void afterSuite(TestDescriptor suite, TestResult result2) {
        List outputEvents = this.pendingOutputEvents.removeAll(((TestDescriptorInternal)suite).getId());
        if (result2.getResultType() == TestResult.ResultType.FAILURE && !result2.getExceptions().isEmpty()) {
            TestMethodResult methodResult = new TestMethodResult(this.internalIdCounter++, EXECUTION_FAILURE);
            TestClassResult classResult = new TestClassResult(this.internalIdCounter++, suite.getName(), result2.getStartTime());
            for (Throwable throwable : result2.getExceptions()) {
                methodResult.addFailure(this.failureMessage(throwable), this.stackTrace(throwable), this.exceptionClassName(throwable));
            }
            for (TestOutputEvent outputEvent : outputEvents) {
                this.outputWriter.onOutput(classResult.getId(), methodResult.getId(), outputEvent);
            }
            methodResult.completed(result2);
            classResult.add(methodResult);
            this.results.put(suite.getName(), classResult);
        } else if (result2.getResultType() == TestResult.ResultType.SKIPPED) {
            String parentClassName = TestReportDataCollector.findEnclosingClassName(suite.getParent());
            String classDisplayName = ((TestDescriptorInternal)suite).getClassDisplayName();
            if (parentClassName != null) {
                TestClassResult classResult = this.results.get(parentClassName);
                if (classResult == null) {
                    classResult = new TestClassResult(this.internalIdCounter++, parentClassName, classDisplayName, result2.getStartTime());
                    this.results.put(parentClassName, classResult);
                }
                TestMethodResult methodResult = new TestMethodResult(this.internalIdCounter++, suite.getName());
                methodResult.completed(result2);
                classResult.add(methodResult);
            }
        }
    }

    @Override
    public void beforeTest(TestDescriptor testDescriptor) {
        TestDescriptorInternal testDescriptorInternal = (TestDescriptorInternal)testDescriptor;
        TestMethodResult methodResult = new TestMethodResult(this.internalIdCounter++, testDescriptorInternal.getName(), testDescriptorInternal.getDisplayName());
        this.currentTestMethods.put(testDescriptor, methodResult);
    }

    @Override
    public void afterTest(TestDescriptor testDescriptor, TestResult result2) {
        String className = testDescriptor.getClassName();
        String classDisplayName = ((TestDescriptorInternal)testDescriptor).getClassDisplayName();
        TestMethodResult methodResult = this.currentTestMethods.remove(testDescriptor).completed(result2);
        for (Throwable throwable : result2.getExceptions()) {
            methodResult.addFailure(this.failureMessage(throwable), this.stackTrace(throwable), this.exceptionClassName(throwable));
        }
        TestClassResult classResult = this.results.get(className);
        if (classResult == null) {
            classResult = new TestClassResult(this.internalIdCounter++, className, classDisplayName, result2.getStartTime());
            this.results.put(className, classResult);
        } else if (classResult.getStartTime() == 0L) {
            classResult.setStartTime(result2.getStartTime());
        }
        classResult.add(methodResult);
    }

    private String failureMessage(Throwable throwable) {
        try {
            return throwable.toString();
        }
        catch (Throwable t) {
            String exceptionClassName = this.exceptionClassName(throwable);
            return String.format("Could not determine failure message for exception of type %s: %s", exceptionClassName, t);
        }
    }

    private String exceptionClassName(Throwable throwable) {
        return throwable instanceof PlaceholderExceptionSupport ? ((PlaceholderExceptionSupport)((Object)throwable)).getExceptionClassName() : throwable.getClass().getName();
    }

    private String stackTrace(Throwable throwable) {
        try {
            return this.getStacktrace(throwable);
        }
        catch (Throwable t) {
            return this.getStacktrace(t);
        }
    }

    private String getStacktrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer2 = new PrintWriter(stringWriter);
        throwable.printStackTrace(writer2);
        writer2.close();
        return stringWriter.toString();
    }

    @Override
    public void onOutput(TestDescriptor testDescriptor, TestOutputEvent outputEvent) {
        TestMethodResult methodResult;
        String className = TestReportDataCollector.findEnclosingClassName(testDescriptor);
        if (className == null) {
            this.pendingOutputEvents.put(((TestDescriptorInternal)testDescriptor).getId(), (Object)outputEvent);
            return;
        }
        TestClassResult classResult = this.results.get(className);
        if (classResult == null) {
            classResult = new TestClassResult(this.internalIdCounter++, className, ((TestDescriptorInternal)testDescriptor).getClassDisplayName(), 0L);
            this.results.put(className, classResult);
        }
        if ((methodResult = this.currentTestMethods.get(testDescriptor)) == null) {
            this.outputWriter.onOutput(classResult.getId(), outputEvent);
        } else {
            this.outputWriter.onOutput(classResult.getId(), methodResult.getId(), outputEvent);
        }
    }

    private static String findEnclosingClassName(TestDescriptor testDescriptor) {
        if (testDescriptor == null) {
            return null;
        }
        String className = testDescriptor.getClassName();
        if (className != null) {
            return className;
        }
        return TestReportDataCollector.findEnclosingClassName(testDescriptor.getParent());
    }
}

