/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.testng;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestClassRunInfo;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.filter.TestFilterSpec;
import org.gradle.api.internal.tasks.testing.filter.TestSelectionMatcher;
import org.gradle.api.internal.tasks.testing.testng.TestNGListenerAdapterFactory;
import org.gradle.api.internal.tasks.testing.testng.TestNGSpec;
import org.gradle.api.internal.tasks.testing.testng.TestNGTestResultProcessorAdapter;
import org.gradle.internal.actor.Actor;
import org.gradle.internal.actor.ActorFactory;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.impldep.org.testng.IMethodInstance;
import org.gradle.internal.impldep.org.testng.IMethodInterceptor;
import org.gradle.internal.impldep.org.testng.ISuite;
import org.gradle.internal.impldep.org.testng.ITestContext;
import org.gradle.internal.impldep.org.testng.ITestListener;
import org.gradle.internal.impldep.org.testng.TestNG;
import org.gradle.internal.reflect.JavaMethod;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.reflect.NoSuchMethodException;
import org.gradle.internal.time.Clock;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.util.internal.GFileUtils;

public class TestNGTestClassProcessor
implements TestClassProcessor {
    public static final String DEFAULT_CONFIG_FAILURE_POLICY = "skip";
    private final List<Class<?>> testClasses = new ArrayList();
    private final File testReportDir;
    private final TestNGSpec spec;
    private final List<File> suiteFiles;
    private final IdGenerator<?> idGenerator;
    private final Clock clock;
    private final ActorFactory actorFactory;
    private ClassLoader applicationClassLoader;
    private Actor resultProcessorActor;
    private TestResultProcessor resultProcessor;

    public TestNGTestClassProcessor(File testReportDir, TestNGSpec spec, List<File> suiteFiles, IdGenerator<?> idGenerator, Clock clock, ActorFactory actorFactory) {
        this.testReportDir = testReportDir;
        this.spec = spec;
        this.suiteFiles = suiteFiles;
        this.idGenerator = idGenerator;
        this.clock = clock;
        this.actorFactory = actorFactory;
    }

    @Override
    public void startProcessing(TestResultProcessor resultProcessor) {
        this.resultProcessorActor = this.actorFactory.createBlockingActor(resultProcessor);
        this.resultProcessor = this.resultProcessorActor.getProxy(TestResultProcessor.class);
        this.applicationClassLoader = Thread.currentThread().getContextClassLoader();
    }

    @Override
    public void processTestClass(TestClassRunInfo testClass) {
        try {
            this.testClasses.add(this.applicationClassLoader.loadClass(testClass.getTestClassName()));
        }
        catch (Throwable e) {
            throw new GradleException(String.format("Could not load test class '%s'.", testClass.getTestClassName()), e);
        }
    }

    @Override
    public void stop() {
        try {
            this.runTests();
        }
        finally {
            this.resultProcessorActor.stop();
        }
    }

    @Override
    public void stopNow() {
        throw new UnsupportedOperationException("stopNow() should not be invoked on remote worker TestClassProcessor");
    }

    private void runTests() {
        TestNG testNg = new TestNG();
        testNg.setOutputDirectory(this.testReportDir.getAbsolutePath());
        testNg.setDefaultSuiteName(this.spec.getDefaultSuiteName());
        testNg.setDefaultTestName(this.spec.getDefaultTestName());
        if (this.spec.getParallel() != null) {
            testNg.setParallel(this.spec.getParallel());
        }
        if (this.spec.getThreadCount() > 0) {
            testNg.setThreadCount(this.spec.getThreadCount());
        }
        this.setConfigFailurePolicy(testNg, this.spec.getConfigFailurePolicy());
        this.setPreserveOrder(testNg, this.spec.getPreserveOrder());
        this.setGroupByInstances(testNg, this.spec.getGroupByInstances());
        testNg.setUseDefaultListeners(this.spec.getUseDefaultListeners());
        testNg.setVerbose(0);
        testNg.setGroups(CollectionUtils.join(",", this.spec.getIncludeGroups()));
        testNg.setExcludedGroups(CollectionUtils.join(",", this.spec.getExcludeGroups()));
        for (String listenerClass : this.spec.getListeners()) {
            try {
                testNg.addListener(JavaReflectionUtil.newInstance(this.applicationClassLoader.loadClass(listenerClass)));
            }
            catch (Throwable e) {
                throw new GradleException(String.format("Could not add a test listener with class '%s'.", listenerClass), e);
            }
        }
        TestFilterSpec filter = this.spec.getFilter();
        if (!(filter.getIncludedTests().isEmpty() && filter.getIncludedTestsCommandLine().isEmpty() && filter.getExcludedTests().isEmpty())) {
            testNg.addListener((Object)new SelectedTestsFilter(filter));
        }
        if (!this.suiteFiles.isEmpty()) {
            testNg.setTestSuites(GFileUtils.toPaths(this.suiteFiles));
        } else {
            testNg.setTestClasses(this.testClasses.toArray(new Class[0]));
        }
        testNg.addListener((Object)this.adaptListener(new TestNGTestResultProcessorAdapter(this.resultProcessor, this.idGenerator, this.clock)));
        testNg.run();
    }

    private void setConfigFailurePolicy(TestNG testNg, String value) {
        block4: {
            Object argValue;
            Class argType;
            try {
                argType = Class.forName("org.gradle.internal.impldep.org.testng.xml.XmlSuite$FailurePolicy", false, testNg.getClass().getClassLoader());
                argValue = argType.getMethod("getValidPolicy", String.class).invoke(null, value);
            }
            catch (Exception e) {
                argType = String.class;
                argValue = value;
            }
            try {
                JavaMethod.of(TestNG.class, Object.class, "setConfigFailurePolicy", new Class[]{argType}).invoke((Class<TestNG>)testNg, argValue);
            }
            catch (NoSuchMethodException e) {
                if (argValue.equals(DEFAULT_CONFIG_FAILURE_POLICY)) break block4;
                String message2 = String.format("The version of TestNG used does not support setting config failure policy to '%s'.", value);
                throw new InvalidUserDataException(message2);
            }
        }
    }

    private void setPreserveOrder(TestNG testNg, boolean value) {
        block2: {
            try {
                JavaMethod.of(TestNG.class, Object.class, "setPreserveOrder", new Class[]{Boolean.TYPE}).invoke((Class<TestNG>)testNg, value);
            }
            catch (NoSuchMethodException e) {
                if (!value) break block2;
                throw new InvalidUserDataException("Preserving the order of tests is not supported by this version of TestNG.");
            }
        }
    }

    private void setGroupByInstances(TestNG testNg, boolean value) {
        block2: {
            try {
                JavaMethod.of(TestNG.class, Object.class, "setGroupByInstances", new Class[]{Boolean.TYPE}).invoke((Class<TestNG>)testNg, value);
            }
            catch (NoSuchMethodException e) {
                if (!value) break block2;
                throw new InvalidUserDataException("Grouping tests by instances is not supported by this version of TestNG.");
            }
        }
    }

    private ITestListener adaptListener(ITestListener listener2) {
        TestNGListenerAdapterFactory factory = new TestNGListenerAdapterFactory(this.applicationClassLoader);
        return factory.createAdapter(listener2);
    }

    private static class SelectedTestsFilter
    implements IMethodInterceptor {
        private final TestSelectionMatcher matcher;

        public SelectedTestsFilter(TestFilterSpec filter) {
            this.matcher = new TestSelectionMatcher(filter);
        }

        public List<IMethodInstance> intercept(List<IMethodInstance> methods, ITestContext context) {
            ISuite suite = context.getSuite();
            LinkedList<IMethodInstance> filtered = new LinkedList<IMethodInstance>();
            for (IMethodInstance candidate : methods) {
                if (!this.matcher.matchesTest(candidate.getMethod().getTestClass().getName(), candidate.getMethod().getMethodName()) && !this.matcher.matchesTest(suite.getName(), null)) continue;
                filtered.add(candidate);
            }
            return filtered;
        }
    }
}

