/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.util.HashSet;
import java.util.Set;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DefaultDependencySubstitutions;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionsInternal;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.composite.CompositeBuildContext;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.build.CompositeBuildParticipantBuildState;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.build.RootBuildState;
import org.gradle.internal.buildtree.GlobalDependencySubstitutionRegistry;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;

public class IncludedBuildDependencySubstitutionsBuilder
implements GlobalDependencySubstitutionRegistry {
    private final CompositeBuildContext context;
    private final Instantiator instantiator;
    private final ObjectFactory objectFactory;
    private final ImmutableAttributesFactory attributesFactory;
    private final NotationParser<Object, ComponentSelector> moduleSelectorNotationParser;
    private final NotationParser<Object, Capability> capabilitiesParser;
    private final Set<IncludedBuildState> processed = new HashSet<IncludedBuildState>();

    public IncludedBuildDependencySubstitutionsBuilder(CompositeBuildContext context, Instantiator instantiator2, ObjectFactory objectFactory, ImmutableAttributesFactory attributesFactory, NotationParser<Object, ComponentSelector> moduleSelectorNotationParser, NotationParser<Object, Capability> capabilitiesParser) {
        this.context = context;
        this.instantiator = instantiator2;
        this.objectFactory = objectFactory;
        this.attributesFactory = attributesFactory;
        this.moduleSelectorNotationParser = moduleSelectorNotationParser;
        this.capabilitiesParser = capabilitiesParser;
    }

    @Override
    public void registerSubstitutionsFor(CompositeBuildParticipantBuildState build) {
        if (build instanceof IncludedBuildState) {
            this.build((IncludedBuildState)build);
        } else if (build instanceof RootBuildState) {
            this.build((RootBuildState)build);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void build(IncludedBuildState build) {
        if (this.processed.contains(build)) {
            return;
        }
        this.processed.add(build);
        DependencySubstitutionsInternal substitutions = this.resolveDependencySubstitutions(build);
        if (!substitutions.rulesMayAddProjectDependency()) {
            this.context.addAvailableModules(build.getAvailableModules());
        } else {
            this.context.registerSubstitution(substitutions.getRuleAction());
        }
    }

    private void build(RootBuildState build) {
        this.context.addAvailableModules(build.getAvailableModules());
    }

    private DependencySubstitutionsInternal resolveDependencySubstitutions(IncludedBuildState build) {
        DefaultDependencySubstitutions dependencySubstitutions = DefaultDependencySubstitutions.forIncludedBuild(build, this.instantiator, this.objectFactory, this.attributesFactory, this.moduleSelectorNotationParser, this.capabilitiesParser);
        build.getRegisteredDependencySubstitutions().execute(dependencySubstitutions);
        return dependencySubstitutions;
    }
}

