/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.properties;

import java.util.Map;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.properties.GradleProperties;
import org.gradle.initialization.EnvironmentChangeTracker;
import org.gradle.initialization.properties.SystemPropertiesInstaller;
import org.gradle.internal.Cast;

public class DefaultSystemPropertiesInstaller
implements SystemPropertiesInstaller {
    private final EnvironmentChangeTracker environmentChangeTracker;
    private final StartParameterInternal startParameter;
    private final GradleInternal gradleInternal;

    public DefaultSystemPropertiesInstaller(EnvironmentChangeTracker environmentChangeTracker, StartParameterInternal startParameter, GradleInternal gradleInternal) {
        this.environmentChangeTracker = environmentChangeTracker;
        this.startParameter = startParameter;
        this.gradleInternal = gradleInternal;
    }

    @Override
    public void setSystemPropertiesFrom(GradleProperties gradleProperties2) {
        this.setSystemPropertiesFromGradleProperties(gradleProperties2.getProperties());
        this.setSystemPropertiesFromStartParameter();
    }

    private void setSystemPropertiesFromStartParameter() {
        Map<String, String> systemPropertiesArgs = this.startParameter.getSystemPropertiesArgs();
        for (String key : systemPropertiesArgs.keySet()) {
            this.environmentChangeTracker.systemPropertyOverridden(key);
        }
        System.getProperties().putAll(systemPropertiesArgs);
    }

    private void setSystemPropertiesFromGradleProperties(Map<String, Object> properties) {
        if (properties.isEmpty()) {
            return;
        }
        String prefix = "systemProp.";
        int prefixLength = prefix.length();
        for (String key : properties.keySet()) {
            if (key.length() <= prefixLength || !key.startsWith(prefix)) continue;
            String systemPropertyKey = key.substring(prefixLength);
            if (!this.gradleInternal.isRootBuild()) {
                this.environmentChangeTracker.systemPropertyLoaded(systemPropertyKey, properties.get(key), System.getProperty(systemPropertyKey));
            }
            System.setProperty(systemPropertyKey, (String)Cast.uncheckedNonnullCast(properties.get(key)));
        }
    }
}

