/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component;

import java.util.Set;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.ConfigurationGraphResolveMetadata;
import org.gradle.internal.impldep.com.google.common.base.Supplier;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;

public class LegacyConfigurationsSupplier
implements Supplier<ImmutableList<? extends ConfigurationGraphResolveMetadata>> {
    private final ComponentGraphResolveMetadata targetComponent;

    public LegacyConfigurationsSupplier(ComponentGraphResolveMetadata targetComponent) {
        this.targetComponent = targetComponent;
    }

    public ImmutableList<? extends ConfigurationGraphResolveMetadata> get() {
        Set<String> configurationNames = this.targetComponent.getConfigurationNames();
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (String configurationName : configurationNames) {
            ConfigurationGraphResolveMetadata configuration = this.targetComponent.getConfiguration(configurationName);
            if (!configuration.isCanBeConsumed()) continue;
            builder.add((Object)configuration);
        }
        return builder.build();
    }
}

