/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.console;

import java.util.Collections;
import java.util.List;
import org.gradle.internal.logging.console.ProgressOperation;
import org.gradle.internal.logging.events.StyledTextOutputEvent;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.nativeintegration.console.ConsoleMetaData;

public class DefaultWorkInProgressFormatter {
    private static final List<StyledTextOutputEvent.Span> IDLE_SPANS = Collections.singletonList(new StyledTextOutputEvent.Span("> IDLE"));
    private final ConsoleMetaData consoleMetaData;

    public DefaultWorkInProgressFormatter(ConsoleMetaData consoleMetaData) {
        this.consoleMetaData = consoleMetaData;
    }

    public List<StyledTextOutputEvent.Span> format(ProgressOperation op) {
        StringBuilder builder = new StringBuilder();
        for (ProgressOperation current = op; current != null && !"org.gradle.internal.progress.BuildProgressLogger".equals(current.getCategory()); current = current.getParent()) {
            String message2 = current.getMessage();
            if (message2 == null) continue;
            builder.insert(0, " > ").insert(3, message2);
        }
        if (builder.length() <= 0) {
            return IDLE_SPANS;
        }
        builder.delete(0, 1);
        return Collections.singletonList(new StyledTextOutputEvent.Span(StyledTextOutput.Style.Header, this.trim(builder)));
    }

    public List<StyledTextOutputEvent.Span> format() {
        return IDLE_SPANS;
    }

    private String trim(StringBuilder formattedString) {
        int cols = this.consoleMetaData.getCols();
        int maxWidth = cols > 0 ? cols - 1 : 79;
        if (maxWidth < formattedString.length()) {
            return formattedString.substring(0, maxWidth);
        }
        return formattedString.toString();
    }
}

