/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.vfs.impl;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.internal.jni.InotifyInstanceLimitTooLowException;
import net.rubygrapefruit.platform.internal.jni.InotifyWatchesLimitTooLowException;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.snapshot.FileSystemNode;
import org.gradle.internal.snapshot.SnapshotHierarchy;
import org.gradle.internal.vfs.impl.AbstractVirtualFileSystem;
import org.gradle.internal.watch.WatchingNotSupportedException;
import org.gradle.internal.watch.registry.FileWatcherRegistry;
import org.gradle.internal.watch.registry.FileWatcherRegistryFactory;
import org.gradle.internal.watch.registry.WatchMode;
import org.gradle.internal.watch.registry.impl.DaemonDocumentationIndex;
import org.gradle.internal.watch.registry.impl.SnapshotCollectingDiffListener;
import org.gradle.internal.watch.vfs.BuildFinishedFileSystemWatchingBuildOperationType;
import org.gradle.internal.watch.vfs.BuildLifecycleAwareVirtualFileSystem;
import org.gradle.internal.watch.vfs.BuildStartedFileSystemWatchingBuildOperationType;
import org.gradle.internal.watch.vfs.FileChangeListeners;
import org.gradle.internal.watch.vfs.FileSystemWatchingInformation;
import org.gradle.internal.watch.vfs.FileSystemWatchingStatistics;
import org.gradle.internal.watch.vfs.VfsLogging;
import org.gradle.internal.watch.vfs.WatchLogging;
import org.gradle.internal.watch.vfs.WatchableFileSystemDetector;
import org.gradle.internal.watch.vfs.impl.DefaultFileSystemWatchingStatistics;
import org.gradle.internal.watch.vfs.impl.LocationsWrittenByCurrentBuild;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchingVirtualFileSystem
extends AbstractVirtualFileSystem
implements BuildLifecycleAwareVirtualFileSystem,
FileSystemWatchingInformation,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(WatchingVirtualFileSystem.class);
    private static final String FILE_WATCHING_ERROR_MESSAGE_DURING_BUILD = "Unable to watch the file system for changes";
    private static final String FILE_WATCHING_ERROR_MESSAGE_AT_END_OF_BUILD = "Gradle was unable to watch the file system for changes";
    private final FileWatcherRegistryFactory watcherRegistryFactory;
    private final DaemonDocumentationIndex daemonDocumentationIndex;
    private final LocationsWrittenByCurrentBuild locationsWrittenByCurrentBuild;
    private final WatchableFileSystemDetector watchableFileSystemDetector;
    private final FileChangeListeners fileChangeListeners;
    private final List<File> unsupportedFileSystems = new ArrayList<File>();
    private Logger warningLogger = LOGGER;
    private final Set<File> watchableHierarchiesRegisteredEarly = new LinkedHashSet<File>();
    private FileWatcherRegistry watchRegistry;
    private Exception reasonForNotWatchingFiles;
    private boolean stateInvalidatedAtStartOfBuild;

    public WatchingVirtualFileSystem(FileWatcherRegistryFactory watcherRegistryFactory, SnapshotHierarchy root, DaemonDocumentationIndex daemonDocumentationIndex, LocationsWrittenByCurrentBuild locationsWrittenByCurrentBuild, WatchableFileSystemDetector watchableFileSystemDetector, FileChangeListeners fileChangeListeners) {
        super(root);
        this.watcherRegistryFactory = watcherRegistryFactory;
        this.daemonDocumentationIndex = daemonDocumentationIndex;
        this.locationsWrittenByCurrentBuild = locationsWrittenByCurrentBuild;
        this.watchableFileSystemDetector = watchableFileSystemDetector;
        this.fileChangeListeners = fileChangeListeners;
    }

    @Override
    protected SnapshotHierarchy updateNotifyingListeners(AbstractVirtualFileSystem.UpdateFunction updateFunction) {
        if (this.watchRegistry == null) {
            return updateFunction.update(SnapshotHierarchy.NodeDiffListener.NOOP);
        }
        SnapshotCollectingDiffListener diffListener = new SnapshotCollectingDiffListener();
        SnapshotHierarchy newRoot = updateFunction.update(diffListener);
        return this.withWatcherChangeErrorHandling(newRoot, () -> diffListener.publishSnapshotDiff((removedSnapshots, addedSnapshots) -> this.watchRegistry.virtualFileSystemContentsChanged(removedSnapshots, addedSnapshots, newRoot)));
    }

    @Override
    public boolean afterBuildStarted(final WatchMode watchMode, final VfsLogging vfsLogging, final WatchLogging watchLogging, BuildOperationRunner buildOperationRunner) {
        this.warningLogger = watchMode.loggerForWarnings(LOGGER);
        this.stateInvalidatedAtStartOfBuild = false;
        this.reasonForNotWatchingFiles = null;
        this.updateRootUnderLock(currentRoot -> buildOperationRunner.call(new CallableBuildOperation<SnapshotHierarchy>(){

            @Override
            public SnapshotHierarchy call(BuildOperationContext context) {
                if (watchMode.isEnabled()) {
                    DefaultFileSystemWatchingStatistics statisticsSinceLastBuild;
                    SnapshotHierarchy newRoot;
                    boolean couldDetectUnsupportedFileSystems;
                    try {
                        WatchingVirtualFileSystem.this.unsupportedFileSystems.clear();
                        if (watchMode == WatchMode.DEFAULT) {
                            WatchingVirtualFileSystem.this.watchableFileSystemDetector.detectUnsupportedFileSystems().forEach(WatchingVirtualFileSystem.this.unsupportedFileSystems::add);
                        }
                        couldDetectUnsupportedFileSystems = true;
                    }
                    catch (NativeException e) {
                        couldDetectUnsupportedFileSystems = false;
                        LOGGER.info("Unable to list file systems to check whether they can be watched. Disabling watching. Reason: {}", (Object)e.getMessage());
                    }
                    if (WatchingVirtualFileSystem.this.watchRegistry == null) {
                        if (couldDetectUnsupportedFileSystems) {
                            context.setStatus("Starting file system watching");
                            newRoot = WatchingVirtualFileSystem.this.startWatching(currentRoot, watchMode, WatchingVirtualFileSystem.this.unsupportedFileSystems);
                        } else {
                            newRoot = currentRoot.empty();
                        }
                        statisticsSinceLastBuild = null;
                    } else {
                        FileWatcherRegistry.FileWatchingStatistics statistics = WatchingVirtualFileSystem.this.watchRegistry.getAndResetStatistics();
                        newRoot = WatchingVirtualFileSystem.this.hasDroppedStateBecauseOfErrorsReceivedWhileWatching(statistics) || !couldDetectUnsupportedFileSystems ? WatchingVirtualFileSystem.this.stopWatchingAndInvalidateHierarchyAfterError(currentRoot) : WatchingVirtualFileSystem.this.watchRegistry.updateVfsOnBuildStarted(currentRoot, watchMode, WatchingVirtualFileSystem.this.unsupportedFileSystems);
                        WatchingVirtualFileSystem.this.stateInvalidatedAtStartOfBuild = newRoot != currentRoot;
                        statisticsSinceLastBuild = new DefaultFileSystemWatchingStatistics(statistics, newRoot);
                        if (vfsLogging == VfsLogging.VERBOSE) {
                            LOGGER.warn("Received {} file system events since last build while watching {} locations", (Object)statisticsSinceLastBuild.getNumberOfReceivedEvents(), (Object)statisticsSinceLastBuild.getNumberOfWatchedHierarchies());
                            LOGGER.warn("Virtual file system retained information about {} files, {} directories and {} missing files since last build", new Object[]{statisticsSinceLastBuild.getRetainedRegularFiles(), statisticsSinceLastBuild.getRetainedDirectories(), statisticsSinceLastBuild.getRetainedMissingFiles()});
                            if (WatchingVirtualFileSystem.this.stateInvalidatedAtStartOfBuild) {
                                LOGGER.warn("Parts of the virtual file system have been invalidated since they didn't support watching");
                            }
                        }
                    }
                    if (WatchingVirtualFileSystem.this.watchRegistry != null) {
                        WatchingVirtualFileSystem.this.watchRegistry.setDebugLoggingEnabled(watchLogging == WatchLogging.DEBUG);
                    }
                    context.setResult(new BuildStartedFileSystemWatchingBuildOperationType.Result(){

                        @Override
                        public boolean isWatchingEnabled() {
                            return true;
                        }

                        @Override
                        public boolean isStartedWatching() {
                            return statisticsSinceLastBuild == null;
                        }

                        @Override
                        public FileSystemWatchingStatistics getStatistics() {
                            return statisticsSinceLastBuild;
                        }
                    });
                    return newRoot;
                }
                context.setResult(BuildStartedFileSystemWatchingBuildOperationType.Result.WATCHING_DISABLED);
                return WatchingVirtualFileSystem.this.stopWatchingAndInvalidateHierarchy(currentRoot);
            }

            @Override
            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName("Build started for file system watching").details(BuildStartedFileSystemWatchingBuildOperationType.Details.INSTANCE);
            }
        }));
        return this.watchRegistry != null;
    }

    @Override
    public void registerWatchableHierarchy(File watchableHierarchy) {
        this.updateRootUnderLock(currentRoot -> {
            if (this.watchRegistry == null) {
                this.watchableHierarchiesRegisteredEarly.add(watchableHierarchy);
                return currentRoot;
            }
            return this.withWatcherChangeErrorHandling((SnapshotHierarchy)currentRoot, () -> this.watchRegistry.registerWatchableHierarchy(watchableHierarchy, (SnapshotHierarchy)currentRoot));
        });
    }

    @Override
    public void beforeBuildFinished(final WatchMode watchMode, final VfsLogging vfsLogging, WatchLogging watchLogging, BuildOperationRunner buildOperationRunner, final int maximumNumberOfWatchedHierarchies) {
        this.updateRootUnderLock(currentRoot -> buildOperationRunner.call(new CallableBuildOperation<SnapshotHierarchy>(){

            @Override
            public SnapshotHierarchy call(BuildOperationContext context) {
                WatchingVirtualFileSystem.this.watchableHierarchiesRegisteredEarly.clear();
                if (watchMode.isEnabled()) {
                    SnapshotHierarchy newRoot;
                    DefaultFileSystemWatchingStatistics statisticsDuringBuild;
                    if (WatchingVirtualFileSystem.this.reasonForNotWatchingFiles != null) {
                        WatchingVirtualFileSystem.this.logWatchingError(WatchingVirtualFileSystem.this.reasonForNotWatchingFiles, WatchingVirtualFileSystem.FILE_WATCHING_ERROR_MESSAGE_AT_END_OF_BUILD, watchMode);
                        WatchingVirtualFileSystem.this.reasonForNotWatchingFiles = null;
                    }
                    if (WatchingVirtualFileSystem.this.watchRegistry == null) {
                        statisticsDuringBuild = null;
                        newRoot = currentRoot.empty();
                    } else {
                        FileWatcherRegistry.FileWatchingStatistics statistics = WatchingVirtualFileSystem.this.watchRegistry.getAndResetStatistics();
                        newRoot = WatchingVirtualFileSystem.this.hasDroppedStateBecauseOfErrorsReceivedWhileWatching(statistics) ? WatchingVirtualFileSystem.this.stopWatchingAndInvalidateHierarchyAfterError(currentRoot) : WatchingVirtualFileSystem.this.withWatcherChangeErrorHandling(currentRoot, () -> WatchingVirtualFileSystem.this.watchRegistry.updateVfsOnBuildFinished(currentRoot, watchMode, maximumNumberOfWatchedHierarchies, WatchingVirtualFileSystem.this.unsupportedFileSystems));
                        statisticsDuringBuild = new DefaultFileSystemWatchingStatistics(statistics, newRoot);
                        if (vfsLogging == VfsLogging.VERBOSE) {
                            LOGGER.warn("Received {} file system events during the current build while watching {} locations", (Object)statisticsDuringBuild.getNumberOfReceivedEvents(), (Object)statisticsDuringBuild.getNumberOfWatchedHierarchies());
                            LOGGER.warn("Virtual file system retains information about {} files, {} directories and {} missing files until next build", new Object[]{statisticsDuringBuild.getRetainedRegularFiles(), statisticsDuringBuild.getRetainedDirectories(), statisticsDuringBuild.getRetainedMissingFiles()});
                            if (WatchingVirtualFileSystem.this.stateInvalidatedAtStartOfBuild) {
                                LOGGER.warn("Parts of the virtual file system have been removed at the start of the build since they didn't support watching");
                            }
                        }
                    }
                    final boolean stoppedWatchingDuringTheBuild = WatchingVirtualFileSystem.this.watchRegistry == null;
                    context.setResult(new BuildFinishedFileSystemWatchingBuildOperationType.Result(){
                        private final boolean stateInvalidatedAtStartOfBuild;
                        {
                            this.stateInvalidatedAtStartOfBuild = WatchingVirtualFileSystem.this.stateInvalidatedAtStartOfBuild;
                        }

                        @Override
                        public boolean isWatchingEnabled() {
                            return true;
                        }

                        @Override
                        public boolean isStoppedWatchingDuringTheBuild() {
                            return stoppedWatchingDuringTheBuild;
                        }

                        @Override
                        public boolean isStateInvalidatedAtStartOfBuild() {
                            return this.stateInvalidatedAtStartOfBuild;
                        }

                        @Override
                        public FileSystemWatchingStatistics getStatistics() {
                            return statisticsDuringBuild;
                        }
                    });
                    return newRoot;
                }
                context.setResult(BuildFinishedFileSystemWatchingBuildOperationType.Result.WATCHING_DISABLED);
                return currentRoot.empty();
            }

            @Override
            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName("Build finished for file system watching").details(BuildFinishedFileSystemWatchingBuildOperationType.Details.INSTANCE);
            }
        }));
        this.warningLogger = LOGGER;
    }

    @CheckReturnValue
    private SnapshotHierarchy startWatching(SnapshotHierarchy currentRoot, WatchMode watchMode, List<File> unsupportedFileSystems) {
        try {
            this.watchRegistry = this.watcherRegistryFactory.createFileWatcherRegistry(new FilterChangesToOutputsChangesHandler(this.locationsWrittenByCurrentBuild, new CompositeChangeHandler(new InvalidateVfsChangeHandler(), new BroadcastingChangeHandler())));
            SnapshotHierarchy newRoot = this.watchRegistry.updateVfsOnBuildStarted(currentRoot.empty(), watchMode, unsupportedFileSystems);
            this.watchableHierarchiesRegisteredEarly.forEach(watchableHierarchy -> this.watchRegistry.registerWatchableHierarchy((File)watchableHierarchy, newRoot));
            this.watchableHierarchiesRegisteredEarly.clear();
            return newRoot;
        }
        catch (Exception ex) {
            this.logWatchingError(ex, FILE_WATCHING_ERROR_MESSAGE_DURING_BUILD, null);
            this.closeUnderLock();
            return currentRoot.empty();
        }
    }

    @Override
    public boolean isWatchingAnyLocations() {
        FileWatcherRegistry watchRegistry = this.watchRegistry;
        if (watchRegistry != null) {
            return watchRegistry.isWatchingAnyLocations();
        }
        return false;
    }

    private SnapshotHierarchy withWatcherChangeErrorHandling(SnapshotHierarchy currentRoot, Runnable runnable) {
        return this.withWatcherChangeErrorHandling(currentRoot, () -> {
            runnable.run();
            return currentRoot;
        });
    }

    private SnapshotHierarchy withWatcherChangeErrorHandling(SnapshotHierarchy currentRoot, Supplier<SnapshotHierarchy> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception ex) {
            this.logWatchingError(ex, FILE_WATCHING_ERROR_MESSAGE_DURING_BUILD, null);
            return this.stopWatchingAndInvalidateHierarchyAfterError(currentRoot);
        }
    }

    private void logWatchingError(Exception exception, String fileWatchingErrorMessage, @Nullable WatchMode watchMode) {
        if (exception instanceof InotifyInstanceLimitTooLowException) {
            this.warningLogger.warn("{}. The inotify instance limit is too low. {}", (Object)fileWatchingErrorMessage, (Object)this.daemonDocumentationIndex.getLinkToSection("sec:inotify_instances_limit"));
        } else if (exception instanceof InotifyWatchesLimitTooLowException) {
            this.warningLogger.warn("{}. The inotify watches limit is too low.", (Object)fileWatchingErrorMessage);
        } else if (exception instanceof WatchingNotSupportedException) {
            this.warningLogger.warn("{}. {}.", (Object)fileWatchingErrorMessage, (Object)exception.getMessage());
        } else {
            this.warningLogger.warn(fileWatchingErrorMessage, (Throwable)exception);
        }
        this.reasonForNotWatchingFiles = exception;
    }

    private void stopWatchingAndInvalidateHierarchyAfterError() {
        this.updateRootUnderLock(this::stopWatchingAndInvalidateHierarchyAfterError);
    }

    private SnapshotHierarchy stopWatchingAndInvalidateHierarchyAfterError(SnapshotHierarchy currentRoot) {
        this.warningLogger.error("Stopping file watching and invalidating VFS after an error happened");
        return this.stopWatchingAndInvalidateHierarchy(currentRoot);
    }

    private SnapshotHierarchy stopWatchingAndInvalidateHierarchy(SnapshotHierarchy currentRoot) {
        if (this.watchRegistry != null) {
            try {
                FileWatcherRegistry toBeClosed = this.watchRegistry;
                this.watchRegistry = null;
                toBeClosed.close();
            }
            catch (IOException ex) {
                LOGGER.error("Unable to close file watcher registry", (Throwable)ex);
            }
        }
        return currentRoot.empty();
    }

    private boolean hasDroppedStateBecauseOfErrorsReceivedWhileWatching(FileWatcherRegistry.FileWatchingStatistics statistics) {
        if (statistics.isUnknownEventEncountered()) {
            this.warningLogger.warn("Dropped VFS state due to lost state");
            return true;
        }
        if (statistics.getErrorWhileReceivingFileChanges().isPresent()) {
            this.warningLogger.warn("Dropped VFS state due to error while receiving file changes", statistics.getErrorWhileReceivingFileChanges().get());
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        LOGGER.debug("Closing VFS, dropping state");
        this.updateRootUnderLock(currentRoot -> {
            this.closeUnderLock();
            return currentRoot.empty();
        });
    }

    private void closeUnderLock() {
        if (this.watchRegistry != null) {
            try {
                this.watchRegistry.close();
            }
            catch (IOException ex) {
                LOGGER.error("Couldn't close watch service", (Throwable)ex);
            }
            finally {
                this.watchRegistry = null;
            }
        }
    }

    private static class VfsChangeLoggingNodeDiffListener
    implements SnapshotHierarchy.NodeDiffListener {
        private final FileWatcherRegistry.Type type;
        private final Path path;
        private final SnapshotHierarchy.NodeDiffListener delegate;
        private boolean alreadyLogged;

        public VfsChangeLoggingNodeDiffListener(FileWatcherRegistry.Type type, Path path, SnapshotHierarchy.NodeDiffListener delegate) {
            this.type = type;
            this.path = path;
            this.delegate = delegate;
        }

        @Override
        public void nodeRemoved(FileSystemNode node) {
            this.maybeLogVfsChangeMessage();
            this.delegate.nodeRemoved(node);
        }

        @Override
        public void nodeAdded(FileSystemNode node) {
            this.maybeLogVfsChangeMessage();
            this.delegate.nodeAdded(node);
        }

        private void maybeLogVfsChangeMessage() {
            if (!this.alreadyLogged) {
                this.alreadyLogged = true;
                LOGGER.debug("Handling VFS change {} {}", (Object)this.type, (Object)this.path);
            }
        }
    }

    private static class CompositeChangeHandler
    implements FileWatcherRegistry.ChangeHandler {
        private final List<FileWatcherRegistry.ChangeHandler> handlers;

        public CompositeChangeHandler(FileWatcherRegistry.ChangeHandler ... handlers) {
            this.handlers = ImmutableList.copyOf((Object[])handlers);
        }

        @Override
        public void handleChange(FileWatcherRegistry.Type type, Path path) {
            this.handlers.forEach(handler -> handler.handleChange(type, path));
        }

        @Override
        public void stopWatchingAfterError() {
            this.handlers.forEach(FileWatcherRegistry.ChangeHandler::stopWatchingAfterError);
        }
    }

    private class BroadcastingChangeHandler
    implements FileWatcherRegistry.ChangeHandler {
        private BroadcastingChangeHandler() {
        }

        @Override
        public void handleChange(FileWatcherRegistry.Type type, Path path) {
            WatchingVirtualFileSystem.this.fileChangeListeners.broadcastChange(type, path);
        }

        @Override
        public void stopWatchingAfterError() {
            WatchingVirtualFileSystem.this.fileChangeListeners.broadcastWatchingError();
        }
    }

    private class InvalidateVfsChangeHandler
    implements FileWatcherRegistry.ChangeHandler {
        private InvalidateVfsChangeHandler() {
        }

        @Override
        public void handleChange(FileWatcherRegistry.Type type, Path path) {
            WatchingVirtualFileSystem.this.updateRootUnderLock(root -> WatchingVirtualFileSystem.this.updateNotifyingListeners(diffListener -> root.invalidate(path.toString(), new VfsChangeLoggingNodeDiffListener(type, path, diffListener))));
        }

        @Override
        public void stopWatchingAfterError() {
            WatchingVirtualFileSystem.this.stopWatchingAndInvalidateHierarchyAfterError();
        }
    }

    private static class FilterChangesToOutputsChangesHandler
    implements FileWatcherRegistry.ChangeHandler {
        private final LocationsWrittenByCurrentBuild locationsWrittenByCurrentBuild;
        private final FileWatcherRegistry.ChangeHandler delegate;

        public FilterChangesToOutputsChangesHandler(LocationsWrittenByCurrentBuild locationsWrittenByCurrentBuild, FileWatcherRegistry.ChangeHandler delegate) {
            this.locationsWrittenByCurrentBuild = locationsWrittenByCurrentBuild;
            this.delegate = delegate;
        }

        @Override
        public void handleChange(FileWatcherRegistry.Type type, Path path) {
            if (!this.locationsWrittenByCurrentBuild.wasLocationWritten(path.toString())) {
                this.delegate.handleChange(type, path);
            }
        }

        @Override
        public void stopWatchingAfterError() {
            this.delegate.stopWatchingAfterError();
        }
    }
}

