/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.GradleGroovyRunnerUtil;
import org.jetbrains.plugins.gradle.execution.GradleRunnerUtil;
import org.jetbrains.plugins.gradle.service.execution.GradleExternalTaskConfigurationType;
import org.jetbrains.plugins.gradle.util.GradleConstants;

final class GradleGroovyScriptRunConfigurationProducer
extends LazyRunConfigurationProducer<ExternalSystemRunConfiguration> {
    GradleGroovyScriptRunConfigurationProducer() {
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = GradleExternalTaskConfigurationType.getInstance().getFactory();
        if (configurationFactory == null) {
            GradleGroovyScriptRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        return configurationFactory;
    }

    protected boolean setupConfigurationFromContext(@NotNull ExternalSystemRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        ExternalSystemTaskExecutionSettings taskExecutionSettings;
        if (configuration == null) {
            GradleGroovyScriptRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            GradleGroovyScriptRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (sourceElement == null) {
            GradleGroovyScriptRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (!GradleConstants.SYSTEM_ID.equals((Object)(taskExecutionSettings = configuration.getSettings()).getExternalSystemId())) {
            return false;
        }
        Location contextLocation = context.getLocation();
        if (!GradleRunnerUtil.isFromGroovyGradleScript(contextLocation)) {
            return false;
        }
        Module module = context.getModule();
        if (module == null) {
            return false;
        }
        String projectPath = GradleRunnerUtil.resolveProjectPath(module);
        if (projectPath == null) {
            VirtualFile virtualFile = contextLocation.getVirtualFile();
            String string = projectPath = virtualFile != null ? virtualFile.getPath() : null;
        }
        if (projectPath == null) {
            return false;
        }
        List<String> tasksToRun = GradleGroovyRunnerUtil.getTasksTarget(contextLocation);
        taskExecutionSettings.setExternalProjectPath(projectPath);
        taskExecutionSettings.setTaskNames(tasksToRun);
        configuration.setName(AbstractExternalSystemTaskConfigurationType.generateName((Project)module.getProject(), (ExternalSystemTaskExecutionSettings)taskExecutionSettings));
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull ExternalSystemRunConfiguration configuration, @NotNull ConfigurationContext context) {
        if (configuration == null) {
            GradleGroovyScriptRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (context == null) {
            GradleGroovyScriptRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        if (!GradleConstants.SYSTEM_ID.equals((Object)configuration.getSettings().getExternalSystemId())) {
            return false;
        }
        Location contextLocation = context.getLocation();
        if (!GradleRunnerUtil.isFromGroovyGradleScript(contextLocation)) {
            return false;
        }
        if (context.getModule() == null) {
            return false;
        }
        String projectPath = GradleRunnerUtil.resolveProjectPath(context.getModule());
        if (projectPath == null) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)projectPath, (CharSequence)configuration.getSettings().getExternalProjectPath())) {
            return false;
        }
        List<String> tasks = GradleGroovyRunnerUtil.getTasksTarget(contextLocation);
        List taskNames = configuration.getSettings().getTaskNames();
        if (tasks.isEmpty() && taskNames.isEmpty()) {
            return true;
        }
        return tasks.containsAll(taskNames) && !taskNames.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/execution/GradleGroovyScriptRunConfigurationProducer";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/execution/GradleGroovyScriptRunConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

