/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security.model.impl;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleNavigatable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.model.Dependency;
import org.jetbrains.security.model.ModuleModel;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\n\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0096\u0002J\b\u0010#\u001a\u00020$H\u0016J\u0014\u0010%\u001a\u00020\u00002\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000e0'J\b\u0010(\u001a\u00020\u0003H\u0016R\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R \u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/security/model/impl/MutableModuleModel;", "Lorg/jetbrains/security/model/ModuleModel;", "id", "", "platformModule", "Lcom/intellij/openapi/module/Module;", "buildFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/lang/String;Lcom/intellij/openapi/module/Module;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;)V", "_dependencies", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "Lorg/jetbrains/security/model/Dependency;", "getBuildFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getDataContext", "()Lcom/intellij/openapi/actionSystem/DataContext;", "dependencies", "Lkotlinx/coroutines/flow/StateFlow;", "getDependencies", "()Lkotlinx/coroutines/flow/StateFlow;", "getId", "()Ljava/lang/String;", "getPlatformModule", "()Lcom/intellij/openapi/module/Module;", "createNavigatable", "Lcom/intellij/pom/Navigatable;", "equals", "", "other", "", "hashCode", "", "setDependencies", "dependencyList", "", "toString", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nMutableModuleModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutableModuleModel.kt\norg/jetbrains/security/model/impl/MutableModuleModel\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,75:1\n230#2,5:76\n*S KotlinDebug\n*F\n+ 1 MutableModuleModel.kt\norg/jetbrains/security/model/impl/MutableModuleModel\n*L\n35#1:76,5\n*E\n"})
public class MutableModuleModel
implements ModuleModel {
    @NotNull
    private final String id;
    @Nullable
    private final Module platformModule;
    @Nullable
    private final VirtualFile buildFile;
    @NotNull
    private final Project project;
    @NotNull
    private final MutableStateFlow<Set<Dependency>> _dependencies;
    @NotNull
    private final StateFlow<Set<Dependency>> dependencies;
    @NotNull
    private final DataContext dataContext;

    public MutableModuleModel(@NotNull String id, @Nullable Module platformModule, @Nullable VirtualFile buildFile, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.id = id;
        this.platformModule = platformModule;
        this.buildFile = buildFile;
        this.project = project;
        this._dependencies = StateFlowKt.MutableStateFlow((Object)SetsKt.emptySet());
        this.dependencies = (StateFlow)this._dependencies;
        this.dataContext = arg_0 -> MutableModuleModel.dataContext$lambda$0(this, arg_0);
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public Module getPlatformModule() {
        return this.platformModule;
    }

    @Override
    @Nullable
    public VirtualFile getBuildFile() {
        return this.buildFile;
    }

    @Override
    @NotNull
    public StateFlow<Set<Dependency>> getDependencies() {
        return this.dependencies;
    }

    @Override
    @NotNull
    public DataContext getDataContext() {
        return this.dataContext;
    }

    @NotNull
    public final MutableModuleModel setDependencies(@NotNull Iterable<Dependency> dependencyList) {
        Set nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter(dependencyList, (String)"dependencyList");
        MutableStateFlow<Set<Dependency>> $this$update$iv = this._dependencies;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            Set it = (Set)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = CollectionsKt.toSet(dependencyList))));
        return this;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.jetbrains.security.model.impl.MutableModuleModel");
        MutableModuleModel cfr_ignored_0 = (MutableModuleModel)other;
        if (!Intrinsics.areEqual((Object)this.getId(), (Object)((MutableModuleModel)other).getId())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getPlatformModule(), (Object)((MutableModuleModel)other).getPlatformModule())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getBuildFile(), (Object)((MutableModuleModel)other).getBuildFile());
    }

    public int hashCode() {
        int result = this.getId().hashCode();
        Module module = this.getPlatformModule();
        result = 31 * result + (module != null ? module.hashCode() : 0);
        VirtualFile virtualFile = this.getBuildFile();
        result = 31 * result + (virtualFile != null ? virtualFile.hashCode() : 0);
        return result;
    }

    private final Navigatable createNavigatable() {
        if (this.getBuildFile() != null) {
            PsiManager psiManager = PsiManager.getInstance((Project)this.project);
            VirtualFile virtualFile = this.getBuildFile();
            Intrinsics.checkNotNull((Object)virtualFile);
            PsiFile psiFile = psiManager.findFile(virtualFile);
            return (Navigatable)psiFile;
        }
        if (this.getPlatformModule() != null) {
            Module module = this.getPlatformModule();
            Intrinsics.checkNotNull((Object)module);
            return (Navigatable)new ModuleNavigatable(module);
        }
        return null;
    }

    @NotNull
    public String toString() {
        return "MutableModuleModel(id='" + this.getId() + "', platformModule=" + this.getPlatformModule() + ", buildFile=" + this.getBuildFile() + ")";
    }

    private static final Object dataContext$lambda$0(MutableModuleModel this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CommonDataKeys.NAVIGATABLE.is(it) ? this$0.createNavigatable() : (CommonDataKeys.PROJECT.is(it) ? this$0.project : null);
    }
}

