/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security.toolwindow.tree.nodes;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.project.Project;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.ObsoleteCoroutinesApi;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.PackageUtilKt;
import org.jetbrains.security.model.Dependency;
import org.jetbrains.security.package.Package;
import org.jetbrains.security.problems.vulnerabilities.Severity;
import org.jetbrains.security.service.Checked;
import org.jetbrains.security.service.PackageChecker;
import org.jetbrains.security.service.PackageStatus;
import org.jetbrains.security.service.Safe;
import org.jetbrains.security.service.Unchecked;
import org.jetbrains.security.service.Vulnerable;
import org.jetbrains.security.toolwindow.tree.nodes.PackageCheckerNodeBase;
import org.jetbrains.security.toolwindow.tree.nodes.State;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eJ\u0010\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\"H\u0014J\u000e\u0010 \u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010#\u001a\u00020\tH\u0002R \u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/security/toolwindow/tree/nodes/DependencyNode;", "Lorg/jetbrains/security/toolwindow/tree/nodes/PackageCheckerNodeBase;", "project", "Lcom/intellij/openapi/project/Project;", "dependencyTreeNode", "dependency", "Lorg/jetbrains/security/model/Dependency;", "viewContext", "Lkotlinx/coroutines/channels/Channel;", "", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/security/toolwindow/tree/nodes/PackageCheckerNodeBase;Lorg/jetbrains/security/model/Dependency;Lkotlinx/coroutines/channels/Channel;)V", "childrenStateFlow", "Lkotlinx/coroutines/flow/StateFlow;", "", "getChildrenStateFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "getDependency", "()Lorg/jetbrains/security/model/Dependency;", "state", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lorg/jetbrains/security/toolwindow/tree/nodes/State;", "getData", "", "dataId", "", "hasVulnerability", "", "includeTransitive", "update", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "vulnerableChild", "intellij.packageChecker"})
@ObsoleteCoroutinesApi
@SourceDebugExtension(value={"SMAP\nDependencyNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyNode.kt\norg/jetbrains/security/toolwindow/tree/nodes/DependencyNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1549#2:137\n1620#2,3:138\n1603#2,9:144\n1855#2:153\n1856#2:155\n1612#2:156\n1963#2,14:157\n230#3,3:141\n233#3,2:171\n230#3,5:173\n1#4:154\n*S KotlinDebug\n*F\n+ 1 DependencyNode.kt\norg/jetbrains/security/toolwindow/tree/nodes/DependencyNode\n*L\n77#1:137\n77#1:138,3\n62#1:144,9\n62#1:153\n62#1:155\n62#1:156\n64#1:157,14\n44#1:141,3\n44#1:171,2\n109#1:173,5\n62#1:154\n*E\n"})
public final class DependencyNode
extends PackageCheckerNodeBase {
    @NotNull
    private final Dependency dependency;
    @NotNull
    private final CoroutineContext coroutineContext;
    @NotNull
    private final MutableStateFlow<State> state;
    @NotNull
    private final StateFlow<List<PackageCheckerNodeBase>> childrenStateFlow;

    /*
     * WARNING - void declaration
     */
    public DependencyNode(@NotNull Project project, @NotNull PackageCheckerNodeBase dependencyTreeNode, @NotNull Dependency dependency, @NotNull Channel<Unit> viewContext) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)dependencyTreeNode), (String)"dependencyTreeNode");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        Intrinsics.checkNotNullParameter(viewContext, (String)"viewContext");
        super(project, dependencyTreeNode, dependencyTreeNode.getChangesCallbackChannel(), dependencyTreeNode.getCoroutineContext());
        this.dependency = dependency;
        this.coroutineContext = dependencyTreeNode.getCoroutineContext();
        this.state = StateFlowKt.MutableStateFlow((Object)new State(false, false, new Unchecked(this.dependency.getPkg()), Severity.Companion.fromScore(0.0f)));
        Iterable iterable = this.dependency.getChildren();
        DependencyNode dependencyNode = this;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Dependency dependency2 = (Dependency)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            DependencyNode dependencyNode2 = new DependencyNode(project, (PackageCheckerNodeBase)this, (Dependency)it, viewContext);
            collection.add(dependencyNode2);
        }
        dependencyNode.childrenStateFlow = (StateFlow)StateFlowKt.MutableStateFlow((Object)((List)destination$iv$iv));
        this.update(project);
        FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((Flow)PackageChecker.Companion.getInstance(project).getVulnerabilitiesFlow()), (Function2)((Function2)new Function2<Map<Package, ? extends PackageStatus>, Continuation<? super Unit>, Object>(this, project, null){
            int label;
            final /* synthetic */ DependencyNode this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.this$0.update(this.$project);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull Map<Package, ? extends PackageStatus> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)this);
        this.init();
    }

    @NotNull
    public final Dependency getDependency() {
        return this.dependency;
    }

    @Override
    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    /*
     * WARNING - void declaration
     */
    public final void update(@NotNull Project project) {
        Severity severity;
        PackageStatus packageStatus;
        boolean hasTransitive;
        boolean hasVulnerability;
        State nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        MutableStateFlow<State> $this$update$iv = this.state;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            State it = (State)prevValue$iv;
            boolean bl = false;
            packageStatus = PackageChecker.Companion.getInstance(project).packageStatus(this.dependency.getPkg());
            hasVulnerability = it.component1();
            hasTransitive = it.component2();
            PackageStatus oldStatus = it.component3();
            severity = it.component4();
            if (packageStatus instanceof Checked) {
                Checked checked = (Checked)packageStatus;
                if (checked instanceof Vulnerable) {
                    severity = (Severity)ComparisonsKt.maxOf((Object)severity, (Object)((Vulnerable)packageStatus).getMaxSeverity(), (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            Severity it = (Severity)a;
                            boolean bl = false;
                            Comparable comparable = Float.valueOf(it.getScore());
                            it = (Severity)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Float.valueOf(it.getScore()));
                        }
                    });
                    hasVulnerability = true;
                    PackageCheckerNodeBase packageCheckerNodeBase = this.getParent();
                    DependencyNode dependencyNode = packageCheckerNodeBase instanceof DependencyNode ? (DependencyNode)packageCheckerNodeBase : null;
                    if (dependencyNode != null) {
                        dependencyNode.vulnerableChild();
                    }
                } else if (checked instanceof Safe) {
                    hasVulnerability = false;
                    if (oldStatus instanceof Vulnerable || hasTransitive) {
                        Severity severity2;
                        Object v2;
                        void $this$maxByOrNull$iv;
                        void $this$mapNotNullTo$iv$iv;
                        Iterable $this$mapNotNull$iv = (Iterable)this.getChildrenStateFlow().getValue();
                        boolean $i$f$mapNotNull = false;
                        Iterable iterable = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            Severity it$iv$iv;
                            Object element$iv$iv$iv;
                            Object element$iv$iv = element$iv$iv$iv = iterator.next();
                            boolean bl2 = false;
                            PackageCheckerNodeBase it2 = (PackageCheckerNodeBase)((Object)element$iv$iv);
                            boolean bl3 = false;
                            Object object = it2 instanceof DependencyNode ? (MutableStateFlow<State>)it2 : null;
                            if ((object != null && (object = ((DependencyNode)((Object)object)).state) != null && (object = (State)object.getValue()) != null ? ((State)object).getMaxSeverity() : null) == null) continue;
                            it$iv$iv = it$iv$iv;
                            boolean bl4 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        $this$mapNotNull$iv = (List)destination$iv$iv;
                        boolean $i$f$maxByOrNull = false;
                        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
                        if (!iterator$iv.hasNext()) {
                            v2 = null;
                        } else {
                            Object maxElem$iv = iterator$iv.next();
                            if (!iterator$iv.hasNext()) {
                                v2 = maxElem$iv;
                            } else {
                                Severity it3 = (Severity)maxElem$iv;
                                boolean bl5 = false;
                                float maxValue$iv = it3.getScore();
                                do {
                                    Object e$iv = iterator$iv.next();
                                    Severity it4 = (Severity)e$iv;
                                    $i$a$-maxByOrNull-DependencyNode$update$1$3 = false;
                                    float v$iv = it4.getScore();
                                    if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                                    maxElem$iv = e$iv;
                                    maxValue$iv = v$iv;
                                } while (iterator$iv.hasNext());
                                v2 = maxElem$iv;
                            }
                        }
                        if ((severity2 = (Severity)v2) == null) {
                            severity2 = Severity.Companion.fromScore(0.0f);
                        }
                        severity = severity2;
                    }
                }
            }
            BuildersKt.launch$default((CoroutineScope)this, (CoroutineContext)this.getCoroutineContext(), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ DependencyNode this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = this.this$0.getChangesCallbackChannel().send((Object)Unit.INSTANCE, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = new State(hasVulnerability, hasTransitive, packageStatus, severity))));
    }

    @Override
    @NotNull
    public StateFlow<List<PackageCheckerNodeBase>> getChildrenStateFlow() {
        return this.childrenStateFlow;
    }

    protected void update(@NotNull PresentationData presentation) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        String humanReadableCoordinates = this.dependency.getPkg().getHumanReadableCoordinates();
        presentation.addText(humanReadableCoordinates, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        State stateValue = (State)this.state.getValue();
        if (this.hasVulnerability(false)) {
            icon = PackageUtilKt.severityTreeIcon(stateValue.getMaxSeverity());
        } else if (this.hasVulnerability(true)) {
            icon = PackageUtilKt.transitiveSeverityTreeIcon(stateValue.getMaxSeverity());
        } else if (stateValue.getPackageStatus() instanceof Unchecked) {
            icon = (Icon)new AnimatedIcon.FS();
        } else {
            Icon icon2 = AllIcons.General.InspectionsOK;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"InspectionsOK");
        }
        Icon icon3 = icon;
        presentation.setIcon(icon3);
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return this.dependency.getDataContext().getData(dataId);
    }

    private final void vulnerableChild() {
        State state;
        State nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<State> $this$update$iv = this.state;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            State state2 = (State)prevValue$iv;
            boolean bl = false;
            boolean hasVulnerability = state2.component1();
            boolean hasTransitiveVulnerability = state2.component2();
            PackageStatus packageStatus = state2.component3();
            Severity maxSeverity2 = state2.component4();
            if (hasVulnerability || hasTransitiveVulnerability) {
                state = state2;
                continue;
            }
            PackageCheckerNodeBase packageCheckerNodeBase = this.getParent();
            DependencyNode dependencyNode = packageCheckerNodeBase instanceof DependencyNode ? (DependencyNode)packageCheckerNodeBase : null;
            if (dependencyNode != null) {
                dependencyNode.vulnerableChild();
            }
            state = new State(false, true, packageStatus, maxSeverity2);
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = state)));
    }

    public final boolean hasVulnerability(boolean includeTransitive) {
        State stateValue = (State)this.state.getValue();
        return stateValue.getHasVulnerability() || includeTransitive && stateValue.getHasTransitiveVulnerability();
    }
}

