/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.eval4j;

import java.util.ArrayList;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.eval4j.BrokenCode;
import org.jetbrains.eval4j.Eval;
import org.jetbrains.eval4j.ExceptionThrown;
import org.jetbrains.eval4j.IntValue;
import org.jetbrains.eval4j.InterpretationEventHandler;
import org.jetbrains.eval4j.InterpreterLoopKt;
import org.jetbrains.eval4j.InterpreterResult;
import org.jetbrains.eval4j.LabelValue;
import org.jetbrains.eval4j.ObjectValue;
import org.jetbrains.eval4j.SingleInstructionInterpreter;
import org.jetbrains.eval4j.ThrownFromEvalExceptionBase;
import org.jetbrains.eval4j.ThrownFromEvaluatedCodeException;
import org.jetbrains.eval4j.UnsupportedByteCodeException;
import org.jetbrains.eval4j.VOID_VALUE;
import org.jetbrains.eval4j.Value;
import org.jetbrains.eval4j.ValueReturned;
import org.jetbrains.eval4j.ValuesKt;
import org.jetbrains.eval4j.jdi.JdiEvalKt;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;
import org.jetbrains.org.objectweb.asm.util.Printer;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u001a#\u0010\u0000\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u001a.\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u001a+\u0010\u0010\u001a\u0002H\u0011\"\b\b\u0000\u0010\u0011*\u00020\u000b*\b\u0012\u0004\u0012\u0002H\u00110\n2\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"computeHandlers", "", "", "Lorg/jetbrains/org/objectweb/asm/tree/TryCatchBlockNode;", "m", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "(Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;)[Ljava/util/List;", "interpreterLoop", "Lorg/jetbrains/eval4j/InterpreterResult;", "initialState", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "Lorg/jetbrains/eval4j/Value;", "eval", "Lorg/jetbrains/eval4j/Eval;", "handler", "Lorg/jetbrains/eval4j/InterpretationEventHandler;", "getStackTop", "T", "i", "", "(Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;I)Lorg/jetbrains/eval4j/Value;", "kotlin.jvm-debugger.eval4j"})
@SourceDebugExtension(value={"SMAP\ninterpreterLoop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 interpreterLoop.kt\norg/jetbrains/eval4j/InterpreterLoopKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,260:1\n1#2:261\n*E\n"})
public final class InterpreterLoopKt {
    @NotNull
    public static final InterpreterResult interpreterLoop(@NotNull MethodNode m, @NotNull Frame<Value> initialState, @NotNull Eval eval2, @NotNull InterpretationEventHandler handler) {
        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u0000\b\n\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"org/jetbrains/eval4j/InterpreterLoopKt$interpreterLoop$ResultException", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "result", "Lorg/jetbrains/eval4j/InterpreterResult;", "(Lorg/jetbrains/eval4j/InterpreterResult;)V", "getResult", "()Lorg/jetbrains/eval4j/InterpreterResult;", "kotlin.jvm-debugger.eval4j"})
        public final class ResultException
        extends RuntimeException {
            @NotNull
            private final InterpreterResult result;

            public ResultException(@NotNull InterpreterResult result2) {
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                this.result = result2;
            }

            @NotNull
            public final InterpreterResult getResult() {
                return this.result;
            }
        }
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Intrinsics.checkNotNullParameter(initialState, (String)"initialState");
        Intrinsics.checkNotNullParameter((Object)eval2, (String)"eval");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        AbstractInsnNode firstInsn = m.instructions.getFirst();
        if (firstInsn == null) {
            throw new IllegalArgumentException("Empty method");
        }
        Ref.ObjectRef currentInsn = new Ref.ObjectRef();
        currentInsn.element = firstInsn;
        SingleInstructionInterpreter interpreter = new SingleInstructionInterpreter(eval2);
        Frame frame = new Frame(initialState);
        List<TryCatchBlockNode>[] handlers = InterpreterLoopKt.computeHandlers(m);
        try {
            block26: while (true) {
                InterpreterResult handled;
                int insnOpcode = ((AbstractInsnNode)currentInsn.element).getOpcode();
                switch (((AbstractInsnNode)currentInsn.element).getType()) {
                    case 8: 
                    case 14: 
                    case 15: {
                        break;
                    }
                    default: {
                        switch (insnOpcode) {
                            case 167: {
                                Object object = currentInsn.element;
                                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
                                InterpreterLoopKt.interpreterLoop$goto((Ref.ObjectRef<AbstractInsnNode>)currentInsn, (AbstractInsnNode)((JumpInsnNode)object).label);
                                continue block26;
                            }
                            case 169: {
                                Object object = currentInsn.element;
                                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
                                VarInsnNode varNode = (VarInsnNode)object;
                                Value address = (Value)frame.getLocal(varNode.var);
                                Intrinsics.checkNotNull((Object)address, (String)"null cannot be cast to non-null type org.jetbrains.eval4j.LabelValue");
                                InterpreterLoopKt.interpreterLoop$goto((Ref.ObjectRef<AbstractInsnNode>)currentInsn, (AbstractInsnNode)((LabelValue)address).getValue());
                                continue block26;
                            }
                            case 171: {
                                throw new UnsupportedByteCodeException("LOOKUPSWITCH is not supported yet");
                            }
                            case 170: {
                                throw new UnsupportedByteCodeException("TABLESWITCH is not supported yet");
                            }
                            case 172: 
                            case 173: 
                            case 174: 
                            case 175: 
                            case 176: {
                                Value value2 = InterpreterLoopKt.getStackTop$default(frame, 0, 1, null);
                                Type expectedType = Type.getReturnType((String)m.desc);
                                if (expectedType.getSort() == 10 || expectedType.getSort() == 9) {
                                    Value value3;
                                    if (!Intrinsics.areEqual((Object)value2, (Object)ValuesKt.getNULL_VALUE()) && !Intrinsics.areEqual((Object)value2.getAsmType(), (Object)expectedType)) {
                                        Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"value");
                                        Object object = ValuesKt.obj$default(value2, null, 1, null);
                                        Intrinsics.checkNotNullExpressionValue((Object)expectedType, (String)"expectedType");
                                        value3 = new ObjectValue(object, expectedType);
                                    } else {
                                        value3 = value2;
                                    }
                                    Value coerced = value3;
                                    Intrinsics.checkNotNullExpressionValue((Object)coerced, (String)"coerced");
                                    return new ValueReturned(coerced);
                                }
                                if (!Intrinsics.areEqual((Object)value2.getAsmType(), (Object)expectedType)) {
                                    boolean coerced;
                                    boolean bl = coerced = insnOpcode == 172;
                                    if (_Assertions.ENABLED && !coerced) {
                                        boolean $i$a$-assert-InterpreterLoopKt$interpreterLoop$22 = false;
                                        String $i$a$-assert-InterpreterLoopKt$interpreterLoop$22 = "Only ints should be coerced: " + Printer.OPCODES[insnOpcode];
                                        throw new AssertionError((Object)$i$a$-assert-InterpreterLoopKt$interpreterLoop$22);
                                    }
                                    IntValue coerced2 = switch (expectedType.getSort()) {
                                        case 1 -> {
                                            Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"value");
                                            yield ValuesKt.boolean(ValuesKt.getBoolean(value2));
                                        }
                                        case 3 -> {
                                            Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"value");
                                            yield ValuesKt.byte((byte)ValuesKt.getInt(value2));
                                        }
                                        case 4 -> {
                                            Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"value");
                                            yield ValuesKt.short((short)ValuesKt.getInt(value2));
                                        }
                                        case 2 -> {
                                            Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"value");
                                            yield ValuesKt.char((char)ValuesKt.getInt(value2));
                                        }
                                        case 5 -> {
                                            Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"value");
                                            yield ValuesKt.int(ValuesKt.getInt(value2));
                                        }
                                        default -> throw new UnsupportedByteCodeException("Should not be coerced: " + expectedType);
                                    };
                                    return new ValueReturned(coerced2);
                                }
                                Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"value");
                                return new ValueReturned(value2);
                            }
                            case 177: {
                                return new ValueReturned(VOID_VALUE.INSTANCE);
                            }
                            case 153: 
                            case 154: 
                            case 155: 
                            case 156: 
                            case 157: 
                            case 158: 
                            case 198: 
                            case 199: {
                                Value value4 = InterpreterLoopKt.getStackTop$default(frame, 0, 1, null);
                                Intrinsics.checkNotNullExpressionValue((Object)value4, (String)"frame.getStackTop()");
                                if (!interpreter.checkUnaryCondition(value4, insnOpcode)) break;
                                frame.execute((AbstractInsnNode)currentInsn.element, (Interpreter)interpreter);
                                Object object = currentInsn.element;
                                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
                                InterpreterLoopKt.interpreterLoop$goto((Ref.ObjectRef<AbstractInsnNode>)currentInsn, (AbstractInsnNode)((JumpInsnNode)object).label);
                                continue block26;
                            }
                            case 159: 
                            case 160: 
                            case 161: 
                            case 162: 
                            case 163: 
                            case 164: 
                            case 165: 
                            case 166: {
                                Object t = InterpreterLoopKt.getStackTop(frame, 1);
                                Intrinsics.checkNotNullExpressionValue(t, (String)"frame.getStackTop(1)");
                                Object t2 = InterpreterLoopKt.getStackTop(frame, 0);
                                Intrinsics.checkNotNullExpressionValue(t2, (String)"frame.getStackTop(0)");
                                if (!interpreter.checkBinaryCondition((Value)t, (Value)t2, insnOpcode)) break;
                                frame.execute((AbstractInsnNode)currentInsn.element, (Interpreter)interpreter);
                                Object object = currentInsn.element;
                                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
                                InterpreterLoopKt.interpreterLoop$goto((Ref.ObjectRef<AbstractInsnNode>)currentInsn, (AbstractInsnNode)((JumpInsnNode)object).label);
                                continue block26;
                            }
                            case 191: {
                                InterpreterResult handled2;
                                Value value5 = InterpreterLoopKt.getStackTop$default(frame, 0, 1, null);
                                Intrinsics.checkNotNull((Object)value5, (String)"null cannot be cast to non-null type org.jetbrains.eval4j.ObjectValue");
                                ObjectValue exceptionValue = (ObjectValue)value5;
                                Object object = currentInsn.element;
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"currentInsn");
                                InterpreterResult interpreterResult = handled2 = handler.exceptionThrown((Frame<Value>)frame, (AbstractInsnNode)object, exceptionValue);
                                if (interpreterResult != null) {
                                    return interpreterResult;
                                }
                                if (InterpreterLoopKt.interpreterLoop$exceptionCaught$0(eval2, handlers, m, (Ref.ObjectRef<AbstractInsnNode>)currentInsn, handler, (Frame<Value>)frame, exceptionValue)) continue block26;
                                return new ExceptionThrown(exceptionValue, ExceptionThrown.ExceptionKind.FROM_EVALUATED_CODE);
                            }
                        }
                        try {
                            frame.execute((AbstractInsnNode)currentInsn.element, (Interpreter)interpreter);
                            break;
                        }
                        catch (ThrownFromEvalExceptionBase e) {
                            InterpreterResult handled3;
                            Throwable exception;
                            Intrinsics.checkNotNull((Object)e.getCause());
                            Type type2 = Type.getType(exception.getClass());
                            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"getType(exception::class.java)");
                            ObjectValue exceptionValue = new ObjectValue(exception, type2);
                            Object object = currentInsn.element;
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"currentInsn");
                            InterpreterResult interpreterResult = handled3 = handler.exceptionThrown((Frame<Value>)frame, (AbstractInsnNode)object, exceptionValue);
                            if (interpreterResult != null) {
                                return interpreterResult;
                            }
                            if (InterpreterLoopKt.interpreterLoop$exceptionFromEvalCaught(handlers, m, (Ref.ObjectRef<AbstractInsnNode>)currentInsn, handler, (Frame<Value>)frame, exception, exceptionValue)) continue block26;
                            ExceptionThrown.ExceptionKind exceptionType = e instanceof BrokenCode ? ExceptionThrown.ExceptionKind.BROKEN_CODE : ExceptionThrown.ExceptionKind.FROM_EVALUATOR;
                            return new ExceptionThrown(exceptionValue, exceptionType);
                        }
                        catch (ThrownFromEvaluatedCodeException e) {
                            InterpreterResult handled4;
                            Object object = currentInsn.element;
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"currentInsn");
                            InterpreterResult interpreterResult = handled4 = handler.exceptionThrown((Frame<Value>)frame, (AbstractInsnNode)object, e.getException());
                            if (interpreterResult != null) {
                                return interpreterResult;
                            }
                            if (InterpreterLoopKt.interpreterLoop$exceptionCaught$0(eval2, handlers, m, (Ref.ObjectRef<AbstractInsnNode>)currentInsn, handler, (Frame<Value>)frame, e.getException())) continue block26;
                            return new ExceptionThrown(e.getException(), ExceptionThrown.ExceptionKind.FROM_EVALUATED_CODE);
                        }
                    }
                }
                Object object = currentInsn.element;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"currentInsn");
                InterpreterResult interpreterResult = handled = handler.instructionProcessed((AbstractInsnNode)object);
                if (interpreterResult != null) {
                    return interpreterResult;
                }
                InterpreterLoopKt.interpreterLoop$goto((Ref.ObjectRef<AbstractInsnNode>)currentInsn, ((AbstractInsnNode)currentInsn.element).getNext());
            }
        }
        catch (ResultException e) {
            return e.getResult();
        }
    }

    public static /* synthetic */ InterpreterResult interpreterLoop$default(MethodNode methodNode, Frame frame, Eval eval2, InterpretationEventHandler interpretationEventHandler, int n, Object object) {
        if ((n & 8) != 0) {
            interpretationEventHandler = InterpretationEventHandler.NONE.INSTANCE;
        }
        return InterpreterLoopKt.interpreterLoop(methodNode, (Frame<Value>)frame, eval2, interpretationEventHandler);
    }

    private static final <T extends Value> T getStackTop(Frame<T> $this$getStackTop, int i2) {
        Value value2 = (Value)$this$getStackTop.getStack($this$getStackTop.getStackSize() - 1 - i2);
        if (value2 == null) {
            ValuesKt.throwBrokenCodeException(new IllegalArgumentException("Couldn't get value with index = " + i2 + " from top of stack"));
            throw new KotlinNothingValueException();
        }
        return (T)value2;
    }

    static /* synthetic */ Value getStackTop$default(Frame frame, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return InterpreterLoopKt.getStackTop(frame, n);
    }

    @NotNull
    public static final List<TryCatchBlockNode>[] computeHandlers(@NotNull MethodNode m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        InsnList instructions = m.instructions;
        int n = 0;
        int n2 = instructions.size();
        List[] listArray = new List[n2];
        while (n < n2) {
            int n3 = n++;
            listArray[n3] = null;
        }
        List[] handlers = listArray;
        for (TryCatchBlockNode tcb : m.tryCatchBlocks) {
            int begin = instructions.indexOf((AbstractInsnNode)tcb.start);
            int end = instructions.indexOf((AbstractInsnNode)tcb.end);
            for (int i2 = begin; i2 < end; ++i2) {
                List insnHandlers;
                List list2 = handlers[i2];
                if (list2 == null) {
                    list2 = new ArrayList();
                }
                handlers[i2] = insnHandlers = list2;
                Intrinsics.checkNotNullExpressionValue((Object)tcb, (String)"tcb");
                insnHandlers.add(tcb);
            }
        }
        return handlers;
    }

    private static final void interpreterLoop$goto(Ref.ObjectRef<AbstractInsnNode> currentInsn, AbstractInsnNode nextInsn) {
        if (nextInsn == null) {
            throw new IllegalArgumentException("Instruction flow ended with no RETURN");
        }
        currentInsn.element = nextInsn;
    }

    private static final boolean interpreterLoop$exceptionCaught(List<? extends TryCatchBlockNode>[] handlers, MethodNode $m, Ref.ObjectRef<AbstractInsnNode> currentInsn, InterpretationEventHandler $handler, Frame<Value> frame, Value exceptionValue, Function1<? super Type, Boolean> instanceOf) {
        List list2 = handlers[$m.instructions.indexOf((AbstractInsnNode)currentInsn.element)];
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List catchBlocks = list2;
        for (TryCatchBlockNode tryCatchBlockNode : catchBlocks) {
            String exceptionTypeInternalName = tryCatchBlockNode.type;
            if (exceptionTypeInternalName == null) continue;
            Type exceptionType = Type.getObjectType((String)exceptionTypeInternalName);
            Intrinsics.checkNotNullExpressionValue((Object)exceptionType, (String)"exceptionType");
            if (!((Boolean)instanceOf.invoke((Object)exceptionType)).booleanValue()) continue;
            Object object = currentInsn.element;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"currentInsn");
            InterpreterResult handled = $handler.exceptionCaught(frame, (AbstractInsnNode)object, exceptionValue);
            if (handled != null) {
                throw new ResultException(handled);
            }
            frame.clearStack();
            frame.push((org.jetbrains.org.objectweb.asm.tree.analysis.Value)exceptionValue);
            InterpreterLoopKt.interpreterLoop$goto(currentInsn, (AbstractInsnNode)tryCatchBlockNode.handler);
            return true;
        }
        return false;
    }

    private static final boolean interpreterLoop$exceptionCaught$0(Eval $eval, List<? extends TryCatchBlockNode>[] handlers, MethodNode $m, Ref.ObjectRef<AbstractInsnNode> currentInsn, InterpretationEventHandler $handler, Frame<Value> frame, Value exceptionValue) {
        return InterpreterLoopKt.interpreterLoop$exceptionCaught(handlers, $m, currentInsn, $handler, frame, exceptionValue, (Function1<? super Type, Boolean>)((Function1)new Function1<Type, Boolean>($eval, exceptionValue){
            final /* synthetic */ Eval $eval;
            final /* synthetic */ Value $exceptionValue;
            {
                this.$eval = $eval;
                this.$exceptionValue = $exceptionValue;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Type exceptionType) {
                Intrinsics.checkNotNullParameter((Object)exceptionType, (String)"exceptionType");
                return this.$eval.isInstanceOf(this.$exceptionValue, exceptionType);
            }
        }));
    }

    private static final boolean interpreterLoop$exceptionFromEvalCaught(List<? extends TryCatchBlockNode>[] handlers, MethodNode $m, Ref.ObjectRef<AbstractInsnNode> currentInsn, InterpretationEventHandler $handler, Frame<Value> frame, Throwable exception, Value exceptionValue) {
        return InterpreterLoopKt.interpreterLoop$exceptionCaught(handlers, $m, currentInsn, $handler, frame, exceptionValue, (Function1<? super Type, Boolean>)((Function1)new Function1<Type, Boolean>(exception){
            final /* synthetic */ Throwable $exception;
            {
                this.$exception = $exception;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Type exceptionType) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)exceptionType, (String)"exceptionType");
                try {
                    Class<?> exceptionClass = this.$exception.getClass();
                    Class<?> clazz = Class.forName(JdiEvalKt.getJdiName(exceptionType), true, exceptionClass.getClassLoader());
                    bl = clazz.isAssignableFrom(exceptionClass);
                }
                catch (ClassNotFoundException e) {
                    bl = false;
                }
                return bl;
            }
        }));
    }
}

