/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.annotations.KtAnnotationValue;
import org.jetbrains.kotlin.analysis.api.base.KtConstantValue;
import org.jetbrains.kotlin.analysis.api.components.KtCompileTimeConstantProvider;
import org.jetbrains.kotlin.analysis.api.components.KtConstantEvaluationMode;
import org.jetbrains.kotlin.analysis.api.fir.KtFirAnalysisSession;
import org.jetbrains.kotlin.analysis.api.fir.components.KtFirAnalysisSessionComponent;
import org.jetbrains.kotlin.analysis.api.fir.evaluate.FirAnnotationValueConverter;
import org.jetbrains.kotlin.analysis.api.fir.evaluate.FirCompileTimeConstantEvaluator;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeToken;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LowLevelFirApiFacadeKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u0014\u001a\u0004\u0018\u00010\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/KtFirCompileTimeConstantProvider;", "Lorg/jetbrains/kotlin/analysis/api/components/KtCompileTimeConstantProvider;", "Lorg/jetbrains/kotlin/analysis/api/fir/components/KtFirAnalysisSessionComponent;", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;", "token", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "(Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;)V", "getAnalysisSession", "()Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;", "getToken", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "evaluate", "Lorg/jetbrains/kotlin/analysis/api/base/KtConstantValue;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "mode", "Lorg/jetbrains/kotlin/analysis/api/components/KtConstantEvaluationMode;", "evaluateAsAnnotationValue", "Lorg/jetbrains/kotlin/analysis/api/annotations/KtAnnotationValue;", "evaluateFir", "fir", "Lorg/jetbrains/kotlin/fir/FirElement;", "sourcePsi", "analysis-api-fir"})
public final class KtFirCompileTimeConstantProvider
extends KtCompileTimeConstantProvider
implements KtFirAnalysisSessionComponent {
    @NotNull
    private final KtFirAnalysisSession analysisSession;
    @NotNull
    private final KtLifetimeToken token;

    public KtFirCompileTimeConstantProvider(@NotNull KtFirAnalysisSession analysisSession, @NotNull KtLifetimeToken token) {
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.analysisSession = analysisSession;
        this.token = token;
    }

    @Override
    @NotNull
    public KtFirAnalysisSession getAnalysisSession() {
        return this.analysisSession;
    }

    @Override
    @NotNull
    protected KtLifetimeToken getToken() {
        return this.token;
    }

    @Override
    @Nullable
    public KtConstantValue evaluate(@NotNull KtExpression expression2, @NotNull KtConstantEvaluationMode mode) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        return this.evaluateFir(LowLevelFirApiFacadeKt.getOrBuildFir((KtElement)expression2, this.getFirResolveSession()), expression2, mode);
    }

    @Override
    @Nullable
    public KtAnnotationValue evaluateAsAnnotationValue(@NotNull KtExpression expression2) {
        KtAnnotationValue ktAnnotationValue;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        FirElement firElement = LowLevelFirApiFacadeKt.getOrBuildFir((KtElement)expression2, this.getFirResolveSession());
        FirExpression firExpression2 = firElement instanceof FirExpression ? (FirExpression)firElement : null;
        if (firExpression2 != null) {
            FirExpression it = firExpression2;
            boolean bl = false;
            ktAnnotationValue = FirAnnotationValueConverter.INSTANCE.toConstantValue(it, this.getFirResolveSession().getUseSiteFirSession());
        } else {
            ktAnnotationValue = null;
        }
        return ktAnnotationValue;
    }

    private final KtConstantValue evaluateFir(FirElement fir, KtExpression sourcePsi, KtConstantEvaluationMode mode) {
        KtConstantValue ktConstantValue;
        if (fir instanceof FirPropertyAccessExpression || fir instanceof FirExpression || fir instanceof FirNamedReference) {
            KtConstantValue ktConstantValue2;
            try {
                ktConstantValue2 = FirCompileTimeConstantEvaluator.INSTANCE.evaluateAsKtConstantValue(fir, mode);
            }
            catch (ArithmeticException e) {
                String string2 = e.getLocalizedMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLocalizedMessage(...)");
                ktConstantValue2 = new KtConstantValue.KtErrorConstantValue(string2, (KtElement)sourcePsi);
            }
            ktConstantValue = ktConstantValue2;
        } else {
            ktConstantValue = null;
        }
        return ktConstantValue;
    }
}

