/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.impl.FirContractCallBlock;
import org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\f\u001a\u00020\r*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirContractNotFirstStatementChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isCorrectlyPlacedIn", "", "functionDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "checkers"})
public final class FirContractNotFirstStatementChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirContractNotFirstStatementChecker INSTANCE = new FirContractNotFirstStatementChecker();

    private FirContractNotFirstStatementChecker() {
    }

    @Override
    public void check(@NotNull FirFunctionCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirCallableSymbol<?> firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(expression2);
        if (!Intrinsics.areEqual((Object)StandardClassIds.Callables.INSTANCE.getContract(), (Object)(firCallableSymbol != null ? firCallableSymbol.getCallableId() : null))) {
            return;
        }
        FirDeclaration containingDeclaration2 = (FirDeclaration)CollectionsKt.last(context2.getContainingDeclarations());
        if (!(containingDeclaration2 instanceof FirFunction) || !this.isCorrectlyPlacedIn(expression2, (FirFunction)containingDeclaration2)) {
            String message2 = containingDeclaration2 instanceof FirFunction && ((FirFunction)containingDeclaration2).getBody() instanceof FirSingleExpressionBlock ? "Contracts are only allowed in function body blocks" : "Contract should be the first statement";
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)expression2.getSource()), FirErrors.INSTANCE.getCONTRACT_NOT_ALLOWED(), (Object)message2, (DiagnosticContext)context2, null, (int)16, null);
        }
    }

    private final boolean isCorrectlyPlacedIn(FirFunctionCall $this$isCorrectlyPlacedIn, FirFunction functionDeclaration) {
        Object object = functionDeclaration.getBody();
        FirStatement firstStatement = object != null && (object = ((FirBlock)object).getStatements()) != null ? (FirStatement)CollectionsKt.first((List)object) : null;
        return firstStatement instanceof FirContractCallBlock && Intrinsics.areEqual((Object)((FirContractCallBlock)firstStatement).getCall(), (Object)$this$isCorrectlyPlacedIn);
    }
}

