/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.fir.analysisApiProviders;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.element.builder.FirElementBuilderKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileElementFactoryKt;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.base.fir.analysisApiProviders.FirIdeModificationTrackerService;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.psi.KtDeclaration;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\f\u0010\u0010\u001a\u00020\u0006*\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/base/fir/analysisApiProviders/FirIdeOutOfBlockPsiTreeChangePreprocessor;", "Lcom/intellij/psi/impl/PsiTreeChangePreprocessor;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "isOutOfBlockChange", "", "psi", "Lcom/intellij/psi/PsiElement;", "isOutOfCodeBlockChange", "rootElement", "child", "treeChanged", "", "event", "Lcom/intellij/psi/impl/PsiTreeChangeEventImpl;", "isGlobalChange", "kotlin.base.fir.analysis-api-providers"})
public final class FirIdeOutOfBlockPsiTreeChangePreprocessor
implements PsiTreeChangePreprocessor {
    @NotNull
    private final Project project;

    public FirIdeOutOfBlockPsiTreeChangePreprocessor(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
        PsiElement child2;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!PsiModificationTrackerImpl.canAffectPsi((PsiTreeChangeEventImpl)event) || event.isGenericChange() || event.getCode() == PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_ADDITION) {
            return;
        }
        if (this.isGlobalChange(event)) {
            ((FirIdeModificationTrackerService)this.project.getService(FirIdeModificationTrackerService.class)).increaseModificationCountForAllModules();
            return;
        }
        PsiElement rootElement = event.getParent();
        PsiTreeChangeEventImpl.PsiEventType psiEventType = event.getCode();
        switch (psiEventType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[psiEventType.ordinal()]) {
            case 1: {
                PsiElement psiElement2 = rootElement;
                break;
            }
            case 2: {
                PsiElement psiElement2 = event.getOldChild();
                break;
            }
            default: {
                PsiElement psiElement2 = child2 = event.getChild();
            }
        }
        if (rootElement == null || !rootElement.isPhysical()) {
            return;
        }
        if (this.isOutOfCodeBlockChange(rootElement, child2)) {
            ((FirIdeModificationTrackerService)this.project.getService(FirIdeModificationTrackerService.class)).increaseModificationCountForModuleAndProject(GenericPsiUtils.getModule(rootElement));
        }
    }

    private final boolean isOutOfCodeBlockChange(PsiElement rootElement, PsiElement child2) {
        boolean bl;
        Language language = rootElement.getLanguage();
        if (Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE)) {
            PsiElement psiElement2 = child2;
            if (psiElement2 == null) {
                psiElement2 = rootElement;
            }
            bl = this.isOutOfBlockChange(psiElement2);
        } else {
            bl = Intrinsics.areEqual((Object)language, (Object)JavaLanguage.INSTANCE) ? true : true;
        }
        return bl;
    }

    private final boolean isOutOfBlockChange(PsiElement psi2) {
        if (!psi2.isValid()) {
            return true;
        }
        if (psi2 instanceof PsiWhiteSpace || psi2 instanceof PsiComment) {
            return false;
        }
        KtDeclaration ktDeclaration = FirElementBuilderKt.getNonLocalContainingInBodyDeclarationWith(psi2);
        if (ktDeclaration == null) {
            return true;
        }
        KtDeclaration container2 = ktDeclaration;
        return !FileElementFactoryKt.isReanalyzableContainer(container2);
    }

    private final boolean isGlobalChange(PsiTreeChangeEventImpl $this$isGlobalChange) {
        PsiTreeChangeEventImpl.PsiEventType psiEventType = $this$isGlobalChange.getCode();
        return switch (psiEventType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[psiEventType.ordinal()]) {
            case 3 -> {
                if ($this$isGlobalChange.getPropertyName() == "propUnloadedPsi" || $this$isGlobalChange.getPropertyName() == "roots") {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if ($this$isGlobalChange.getOldParent() instanceof PsiDirectory || $this$isGlobalChange.getNewParent() instanceof PsiDirectory) {
                    yield true;
                }
                yield false;
            }
            default -> $this$isGlobalChange.getParent() instanceof PsiDirectory;
        };
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PsiTreeChangeEventImpl.PsiEventType.values().length];
            try {
                nArray[PsiTreeChangeEventImpl.PsiEventType.CHILD_REMOVED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_REPLACEMENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PsiTreeChangeEventImpl.PsiEventType.PROPERTY_CHANGED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PsiTreeChangeEventImpl.PsiEventType.CHILD_MOVED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

