/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.projectStructure;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.project.structure.KtSourceModule;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinResolveScopeEnlarger;
import org.jetbrains.kotlin.idea.base.projectStructure.KtModuleByModuleInfoBase;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleDependencyCollector;
import org.jetbrains.kotlin.idea.base.projectStructure.ProjectModuleByModuleInfoKt;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleTestSourceInfo;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0016\u0010\u001f\u001a\u0004\u0018\u00010\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001a\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/KtSourceModuleByModuleInfo;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KtModuleByModuleInfoBase;", "Lorg/jetbrains/kotlin/analysis/project/structure/KtSourceModule;", "moduleInfo", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/ModuleSourceInfo;", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/ModuleSourceInfo;)V", "contentScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getContentScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "directRegularDependencies", "", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "getDirectRegularDependencies", "()Ljava/util/List;", "ideaModule", "Lcom/intellij/openapi/module/Module;", "getIdeaModule", "()Lcom/intellij/openapi/module/Module;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "moduleName", "", "getModuleName", "()Ljava/lang/String;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "stableModuleName", "getStableModuleName", "kotlin.base.project-structure"})
@ApiStatus.Internal
public class KtSourceModuleByModuleInfo
extends KtModuleByModuleInfoBase
implements KtSourceModule {
    @NotNull
    private final ModuleSourceInfo moduleInfo;

    public KtSourceModuleByModuleInfo(@NotNull ModuleSourceInfo moduleInfo) {
        Intrinsics.checkNotNullParameter((Object)moduleInfo, (String)"moduleInfo");
        super(moduleInfo);
        this.moduleInfo = moduleInfo;
    }

    @NotNull
    public final Module getIdeaModule() {
        return this.moduleInfo.getModule();
    }

    @Override
    @NotNull
    public String getModuleName() {
        String string2 = this.getIdeaModule().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ideaModule.name");
        return string2;
    }

    @Override
    @Nullable
    public String getStableModuleName() {
        Name name2 = this.moduleInfo.getStableName();
        return name2 != null ? name2.asString() : null;
    }

    @Override
    @NotNull
    public List<KtModule> getDirectRegularDependencies() {
        return ProjectModuleByModuleInfoKt.collectDependencies(this.moduleInfo, ModuleDependencyCollector.CollectionMode.COLLECT_NON_IGNORED);
    }

    @Override
    @NotNull
    public GlobalSearchScope getContentScope() {
        GlobalSearchScope globalSearchScope;
        if (this.moduleInfo instanceof ModuleTestSourceInfo) {
            GlobalSearchScope globalSearchScope2 = GlobalSearchScopes.projectTestScope((Project)this.getProject()).intersectWith(this.getIdeaModule().getModuleTestSourceScope());
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope2, (String)"projectTestScope(project\u2026le.moduleTestSourceScope)");
            GlobalSearchScope testOnlyScope = globalSearchScope2;
            globalSearchScope = KotlinResolveScopeEnlarger.Companion.enlargeScope(testOnlyScope, this.getIdeaModule(), true);
        } else {
            globalSearchScope = this.moduleInfo.getContentScope();
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public LanguageVersionSettings getLanguageVersionSettings() {
        return LanguageVersionSettingsProviderUtils.getLanguageVersionSettings(this.moduleInfo.getModule());
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project2 = this.getIdeaModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"ideaModule.project");
        return project2;
    }
}

