/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsights.impl.base;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/RemoveEmptyParenthesesFromLambdaCallUtils;", "", "()V", "canRemoveByPsi", "", "list", "Lorg/jetbrains/kotlin/psi/KtValueArgumentList;", "removeArgumentList", "", "removeEmptyArgumentListIfApplicable", "kotlin.code-insight.impl-base"})
public final class RemoveEmptyParenthesesFromLambdaCallUtils {
    @NotNull
    public static final RemoveEmptyParenthesesFromLambdaCallUtils INSTANCE = new RemoveEmptyParenthesesFromLambdaCallUtils();

    private RemoveEmptyParenthesesFromLambdaCallUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canRemoveByPsi(@NotNull KtValueArgumentList list2) {
        Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
        List list3 = list2.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"list.arguments");
        if (!((Collection)list3).isEmpty()) {
            return false;
        }
        boolean bl = false;
        if (bl) {
            return false;
        }
        PsiElement psiElement2 = list2.getParent();
        if (!(psiElement2 instanceof KtCallExpression)) return false;
        KtCallExpression ktCallExpression = (KtCallExpression)psiElement2;
        if (ktCallExpression == null) {
            return false;
        }
        KtCallExpression parent2 = ktCallExpression;
        KtExpression ktExpression = parent2.getCalleeExpression();
        if (Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getText() : null), (Object)KtTokens.SUSPEND_KEYWORD.getValue())) {
            return false;
        }
        List list4 = parent2.getLambdaArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"parent.lambdaArguments");
        KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.singleOrNull((List)list4);
        if (ktLambdaArgument == null) {
            return false;
        }
        KtLambdaArgument singleLambdaArgument = ktLambdaArgument;
        if (PsiLinesUtilsKt.getLineNumber((PsiElement)list2, false) != PsiLinesUtilsKt.getLineNumber((PsiElement)singleLambdaArgument, true)) {
            return false;
        }
        PsiElement prev2 = PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments$default((PsiElement)((PsiElement)list2), (boolean)false, (int)1, null);
        if (prev2 instanceof KtCallExpression) return false;
        KtQualifiedExpression ktQualifiedExpression = prev2 instanceof KtQualifiedExpression ? (KtQualifiedExpression)prev2 : null;
        if ((ktQualifiedExpression != null ? ktQualifiedExpression.getSelectorExpression() : null) instanceof KtCallExpression) return false;
        return true;
    }

    public final void removeArgumentList(@NotNull KtValueArgumentList list2) {
        Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
        list2.delete();
    }

    public final void removeEmptyArgumentListIfApplicable(@NotNull KtValueArgumentList list2) {
        Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
        if (this.canRemoveByPsi(list2)) {
            this.removeArgumentList(list2);
        }
    }
}

