/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler.configuration;

import com.intellij.compiler.server.BuildProcessParametersProvider;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.PluginStartupApplicationService;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCompilerWorkspaceSettings;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/KotlinBuildProcessParametersProvider;", "Lcom/intellij/compiler/server/BuildProcessParametersProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getVMArguments", "", "", "kotlin.jvm"})
public final class KotlinBuildProcessParametersProvider
extends BuildProcessParametersProvider {
    @NotNull
    private final Project project;

    public KotlinBuildProcessParametersProvider(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @NotNull
    public List<String> getVMArguments() {
        KotlinCompilerWorkspaceSettings compilerWorkspaceSettings = KotlinCompilerWorkspaceSettings.Companion.getInstance(this.project);
        List arguments2 = new ArrayList();
        if (compilerWorkspaceSettings.getPreciseIncrementalEnabled()) {
            ((Collection)arguments2).add("-Dkotlin.incremental.compilation=true");
        }
        if (compilerWorkspaceSettings.getIncrementalCompilationForJsEnabled()) {
            ((Collection)arguments2).add("-Dkotlin.incremental.compilation.js=true");
        }
        if (compilerWorkspaceSettings.getEnableDaemon()) {
            ((Collection)arguments2).add("-Dkotlin.daemon.enabled");
        }
        String it = PluginStartupApplicationService.Companion.getInstance().getAliveFlagPath();
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)it)) {
            ((Collection)arguments2).add("-Dkotlin.daemon.client.alive.path=\"" + it + "\"");
        }
        return arguments2;
    }
}

