/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.impl.k2;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.symbols.KtCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtClassKind;
import org.jetbrains.kotlin.analysis.api.symbols.KtClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtClassOrObjectSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtClassifierSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.markers.KtSymbolKind;
import org.jetbrains.kotlin.analysis.api.types.KtFunctionalType;
import org.jetbrains.kotlin.analysis.api.types.KtType;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.compositeAnalysis.PlatformAnalyzerServicesUtils;
import org.jetbrains.kotlin.idea.base.utils.fqname.FqNameUtilKt;
import org.jetbrains.kotlin.idea.completion.lookups.ImportStrategy;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.ImportPath;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015R\u00020\u0011\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\u001a\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0018R\u00020\u0011\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019J\f\u0010\u001a\u001a\u00020\u0015*\u00020\u000eH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00b1\u00140\u0001\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/completion/impl/k2/ImportStrategyDetector;", "", "originalKtFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "project", "Lcom/intellij/openapi/project/Project;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/openapi/project/Project;)V", "analyzerServices", "Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "defaultImports", "", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "excludedImports", "", "Lorg/jetbrains/kotlin/name/FqName;", "detectImportStrategyForCallableSymbol", "Lorg/jetbrains/kotlin/idea/completion/lookups/ImportStrategy;", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtCallableSymbol;", "isFunctionalVariableCall", "", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/symbols/KtCallableSymbol;Z)Lorg/jetbrains/kotlin/idea/completion/lookups/ImportStrategy;", "detectImportStrategyForClassifierSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtClassifierSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/symbols/KtClassifierSymbol;)Lorg/jetbrains/kotlin/idea/completion/lookups/ImportStrategy;", "isAlreadyImported", "kotlin.completion.impl-k2"})
@ApiStatus.Internal
public final class ImportStrategyDetector {
    @NotNull
    private final PlatformDependentAnalyzerServices analyzerServices;
    @NotNull
    private final Set<ImportPath> defaultImports;
    @NotNull
    private final List<FqName> excludedImports;

    public ImportStrategyDetector(@NotNull KtFile originalKtFile, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)originalKtFile, (String)"originalKtFile");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.analyzerServices = PlatformAnalyzerServicesUtils.findAnalyzerServices(TargetPlatformDetectorUtils.getPlatform((KtElement)originalKtFile), project2);
        this.defaultImports = CollectionsKt.toSet((Iterable)this.analyzerServices.getDefaultImports(LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)originalKtFile), true));
        this.excludedImports = this.analyzerServices.getExcludedImports();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final ImportStrategy detectImportStrategyForCallableSymbol(@NotNull KtAnalysisSession _context_receiver_0, @NotNull KtCallableSymbol symbol2, boolean isFunctionalVariableCall) {
        ImportStrategy importStrategy;
        CallableId callableId;
        block7: {
            block6: {
                boolean containingClassIsObject;
                Intrinsics.checkNotNullParameter((Object)_context_receiver_0, (String)"_context_receiver_0");
                Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
                Object object = _context_receiver_0.getOriginalContainingClassForOverride(symbol2);
                boolean bl = object != null && (object = ((KtClassOrObjectSymbol)object).getClassKind()) != null ? ((KtClassKind)((Object)object)).isObject() : (containingClassIsObject = false);
                if (symbol2.getSymbolKind() == KtSymbolKind.CLASS_MEMBER && !containingClassIsObject) {
                    return ImportStrategy.DoNothing.INSTANCE;
                }
                CallableId callableId2 = symbol2.getCallableIdIfNonLocal();
                CallableId callableId3 = callableId2;
                if (callableId2 == null) return ImportStrategy.DoNothing.INSTANCE;
                if ((callableId3 = callableId3.asSingleFqName()) == null) {
                    return ImportStrategy.DoNothing.INSTANCE;
                }
                callableId = callableId3;
                if (this.isAlreadyImported((FqName)callableId)) {
                    return ImportStrategy.DoNothing.INSTANCE;
                }
                if (symbol2.isExtension()) break block6;
                if (!isFunctionalVariableCall) break block7;
                KtType ktType = symbol2.getReturnType();
                KtFunctionalType ktFunctionalType = ktType instanceof KtFunctionalType ? (KtFunctionalType)ktType : null;
                boolean bl2 = ktFunctionalType != null ? ktFunctionalType.getHasReceiver() : false;
                if (!bl2) break block7;
            }
            importStrategy = new ImportStrategy.AddImport((FqName)callableId);
            return importStrategy;
        }
        importStrategy = new ImportStrategy.InsertFqNameAndShorten((FqName)callableId);
        return importStrategy;
    }

    public static /* synthetic */ ImportStrategy detectImportStrategyForCallableSymbol$default(ImportStrategyDetector importStrategyDetector, KtAnalysisSession ktAnalysisSession, KtCallableSymbol ktCallableSymbol, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return importStrategyDetector.detectImportStrategyForCallableSymbol(ktAnalysisSession, ktCallableSymbol, bl);
    }

    @NotNull
    public final ImportStrategy detectImportStrategyForClassifierSymbol(@NotNull KtAnalysisSession _context_receiver_0, @NotNull KtClassifierSymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)_context_receiver_0, (String)"_context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        if (!(symbol2 instanceof KtClassLikeSymbol)) {
            return ImportStrategy.DoNothing.INSTANCE;
        }
        ClassId classId = ((KtClassLikeSymbol)symbol2).getClassIdIfNonLocal();
        if (classId == null || (classId = classId.asSingleFqName()) == null) {
            return ImportStrategy.DoNothing.INSTANCE;
        }
        ClassId classId2 = classId;
        if (this.isAlreadyImported((FqName)classId2)) {
            return ImportStrategy.DoNothing.INSTANCE;
        }
        return new ImportStrategy.InsertFqNameAndShorten((FqName)classId2);
    }

    private final boolean isAlreadyImported(FqName $this$isAlreadyImported) {
        ImportPath importPath = new ImportPath($this$isAlreadyImported, false, null, 4, null);
        return FqNameUtilKt.isImported(importPath, (Iterable<ImportPath>)this.defaultImports, (Iterable<FqName>)this.excludedImports);
    }
}

