/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core;

import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.base.util.DexDebugFacility;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.core.VariableWithLocation;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0010\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u0001*\u00020\u0006\u00a8\u0006\u0007"}, d2={"filterRepeatedVariables", "", "Lcom/sun/jdi/LocalVariable;", "sortedVariables", "sortedVariablesWithLocation", "Lorg/jetbrains/kotlin/idea/debugger/core/VariableWithLocation;", "Lcom/sun/jdi/Method;", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nstackFrameUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 stackFrameUtils.kt\norg/jetbrains/kotlin/idea/debugger/core/StackFrameUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,113:1\n1603#2,9:114\n1855#2:123\n1856#2:126\n1612#2:127\n1603#2,9:135\n1855#2:144\n1856#2:146\n1612#2:147\n1194#2,2:148\n1222#2,4:150\n1#3:124\n1#3:125\n1#3:145\n372#4,7:128\n*S KotlinDebug\n*F\n+ 1 stackFrameUtils.kt\norg/jetbrains/kotlin/idea/debugger/core/StackFrameUtilsKt\n*L\n56#1:114,9\n56#1:123\n56#1:126\n56#1:127\n90#1:135,9\n90#1:144\n90#1:146\n90#1:147\n112#1:148,2\n112#1:150,4\n56#1:125\n90#1:145\n72#1:128,7\n*E\n"})
public final class StackFrameUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<VariableWithLocation> sortedVariablesWithLocation(@NotNull Method $this$sortedVariablesWithLocation) {
        void $this$mapNotNullTo$iv$iv;
        Object endOffset2;
        Intrinsics.checkNotNullParameter((Object)$this$sortedVariablesWithLocation, (String)"<this>");
        List<LocalVariable> list2 = SafeUtilKt.safeVariables($this$sortedVariablesWithLocation);
        if (list2 == null) {
            return CollectionsKt.emptyList();
        }
        List<LocalVariable> allVariables = list2;
        VirtualMachine virtualMachine = $this$sortedVariablesWithLocation.virtualMachine();
        Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"virtualMachine()");
        if (!DexDebugFacility.INSTANCE.isDex(virtualMachine)) {
            void $this$mapNotNullTo$iv$iv2;
            Iterable $this$mapNotNull$iv = allVariables;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                VariableWithLocation variableWithLocation;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                LocalVariable local = (LocalVariable)element$iv$iv;
                boolean bl2 = false;
                if (DebuggerUtils.INSTANCE.getBorders(local) != null) {
                    ClosedRange<Location> it;
                    boolean bl3 = false;
                    variableWithLocation = new VariableWithLocation(local, (Location)it.getStart());
                } else {
                    variableWithLocation = null;
                }
                if (variableWithLocation == null) continue;
                VariableWithLocation it$iv$iv = variableWithLocation;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        }
        Map startOffsets = new LinkedHashMap();
        Map replacements = new LinkedHashMap();
        for (LocalVariable variable2 : allVariables) {
            Object object;
            void $this$getOrPut$iv;
            Object object2 = DebuggerUtils.INSTANCE.getBorders(variable2);
            if (object2 == null || (object2 = (Location)object2.getStart()) == null) continue;
            Object startOffset = object2;
            Map $this$forEach$iv$iv$iv = startOffsets;
            Long key$iv = startOffset.codeIndex();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((Collection)object).add(variable2);
        }
        block2: for (LocalVariable variable2 : allVariables) {
            List otherVariables;
            Object object = DebuggerUtils.INSTANCE.getBorders(variable2);
            if (object == null) continue;
            if ((object = (Location)object.getEndInclusive()) == null || (List)startOffsets.get((endOffset2 = object).codeIndex() + 1L) == null) continue;
            for (LocalVariable other2 : otherVariables) {
                if (!Intrinsics.areEqual((Object)variable2.name(), (Object)other2.name()) || !Intrinsics.areEqual((Object)variable2.signature(), (Object)other2.signature()) || Intrinsics.areEqual((Object)variable2, (Object)other2)) continue;
                replacements.put(other2, variable2);
                continue block2;
            }
        }
        Object $this$mapNotNull$iv = allVariables;
        boolean $i$f$mapNotNull = false;
        endOffset2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
        while (iterator3.hasNext()) {
            VariableWithLocation variableWithLocation;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator3.next();
            boolean bl = false;
            LocalVariable variable3 = (LocalVariable)element$iv$iv;
            boolean bl5 = false;
            LocalVariable alias = variable3;
            while ((LocalVariable)replacements.get(alias) != null) {
            }
            if (!Intrinsics.areEqual((Object)variable3, (Object)alias)) {
                replacements.put(variable3, alias);
            }
            if (DebuggerUtils.INSTANCE.getBorders(alias) != null) {
                ClosedRange<Location> it;
                boolean bl6 = false;
                variableWithLocation = new VariableWithLocation(variable3, (Location)it.getStart());
            } else {
                variableWithLocation = null;
            }
            if (variableWithLocation == null) continue;
            VariableWithLocation it$iv$iv = variableWithLocation;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<LocalVariable> filterRepeatedVariables(@NotNull List<? extends LocalVariable> sortedVariables) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(sortedVariables, (String)"sortedVariables");
        Iterable $this$associateBy$iv = sortedVariables;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            LocalVariable localVariable = (LocalVariable)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.name(), element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)destination$iv$iv.values());
    }
}

