/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine;

import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.configurations.DebuggingRunnerData;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.KotlinDebuggerSettings;
import org.jetbrains.kotlin.idea.debugger.coroutine.CoroutineDebugConfigurationExtensionKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.DebuggerConnection;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J5\u0010\u0007\u001a\u00020\b\"\f\b\u0000\u0010\t*\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0005\u001a\u0002H\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineDebugConfigurationExtension;", "Lcom/intellij/execution/RunConfigurationExtension;", "()V", "isApplicableFor", "", "configuration", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "updateJavaParameters", "", "T", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "runnerSettings", "Lcom/intellij/execution/configurations/RunnerSettings;", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/execution/configurations/JavaParameters;Lcom/intellij/execution/configurations/RunnerSettings;)V", "kotlin.jvm-debugger.coroutines"})
public final class CoroutineDebugConfigurationExtension
extends RunConfigurationExtension {
    public <T extends RunConfigurationBase<?>> void updateJavaParameters(@NotNull T configuration2, @NotNull JavaParameters params2, @Nullable RunnerSettings runnerSettings) {
        Intrinsics.checkNotNullParameter(configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
        boolean coroutineDebugIsDisabledInSettings = KotlinDebuggerSettings.Companion.getInstance().getDebugDisableCoroutineAgent();
        boolean coroutineDebugIsDisabledInParameters = CoroutineDebugConfigurationExtensionKt.access$isKotlinxCoroutinesDebugDisabled(params2);
        if (!coroutineDebugIsDisabledInSettings && !coroutineDebugIsDisabledInParameters && runnerSettings instanceof DebuggingRunnerData) {
            Project project2 = configuration2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"configuration.project");
            new DebuggerConnection(project2, configuration2, params2, CoroutineDebugConfigurationExtensionKt.access$argumentsShouldBeModified(configuration2), false, 16, null);
        }
    }

    public boolean isApplicableFor(@NotNull RunConfigurationBase<?> configuration2) {
        Intrinsics.checkNotNullParameter(configuration2, (String)"configuration");
        return true;
    }
}

