/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.sequence.resolve;

import com.intellij.debugger.streams.resolve.ValuesOrderResolver;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.TraceInfo;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.sequence.resolve.WindowedResolver;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u001c\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/sequence/resolve/WindowedResolver;", "Lcom/intellij/debugger/streams/resolve/ValuesOrderResolver;", "()V", "calcWindowSize", "", "before", "", "after", "emptyTransitions", "Lcom/intellij/debugger/streams/resolve/ValuesOrderResolver$Result;", "indexBefore", "", "Lcom/intellij/debugger/streams/trace/TraceElement;", "resolve", "info", "Lcom/intellij/debugger/streams/trace/TraceInfo;", "kotlin.jvm-debugger.sequence"})
@SourceDebugExtension(value={"SMAP\nWindowedResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowedResolver.kt\norg/jetbrains/kotlin/idea/debugger/sequence/resolve/WindowedResolver\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,58:1\n603#2:59\n658#2:60\n739#2,4:61\n*S KotlinDebug\n*F\n+ 1 WindowedResolver.kt\norg/jetbrains/kotlin/idea/debugger/sequence/resolve/WindowedResolver\n*L\n55#1:59\n55#1:60\n55#1:61,4\n*E\n"})
public final class WindowedResolver
implements ValuesOrderResolver {
    @NotNull
    public ValuesOrderResolver.Result resolve(@NotNull TraceInfo info2) {
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        Map map2 = info2.getValuesOrderBefore();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"info.valuesOrderBefore");
        Map indexBefore = map2;
        Map map3 = info2.getValuesOrderAfter();
        Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"info.valuesOrderAfter");
        Map indexAfter = map3;
        int[] timesBefore = CollectionsKt.toIntArray((Collection)CollectionsKt.sorted((Iterable)indexBefore.keySet()));
        int[] timesAfter = CollectionsKt.toIntArray((Collection)CollectionsKt.sorted((Iterable)indexAfter.keySet()));
        if (timesAfter.length == 0) {
            return this.emptyTransitions(indexBefore);
        }
        Map direct = new LinkedHashMap();
        Map reverse = new LinkedHashMap();
        int windowStartIndex = 0;
        int windowEndIndex = this.calcWindowSize(timesBefore, timesAfter);
        int n = timesAfter.length;
        for (int j = 0; j < n; ++j) {
            int timeAfter = timesAfter[j];
            if (windowEndIndex == timesAfter.length) {
                ++windowStartIndex;
            } else {
                while (windowEndIndex < timesBefore.length && timesBefore[windowEndIndex] < timeAfter) {
                    ++windowStartIndex;
                    ++windowEndIndex;
                }
            }
            List window2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)RangesKt.until((int)windowStartIndex, (int)windowEndIndex))), (Function1)((Function1)new Function1<Integer, TraceElement>((Map<Integer, TraceElement>)indexBefore, timesBefore){
                final /* synthetic */ Map<Integer, TraceElement> $indexBefore;
                final /* synthetic */ int[] $timesBefore;
                {
                    this.$indexBefore = $indexBefore;
                    this.$timesBefore = $timesBefore;
                    super(1);
                }

                @NotNull
                public final TraceElement invoke(int it) {
                    TraceElement traceElement = this.$indexBefore.get(this.$timesBefore[it]);
                    Intrinsics.checkNotNull((Object)traceElement);
                    return traceElement;
                }
            })));
            Object v = indexAfter.get(timeAfter);
            Intrinsics.checkNotNull(v);
            TraceElement mappedElement = (TraceElement)v;
            for (TraceElement item : window2) {
                direct.computeIfAbsent(item, arg_0 -> WindowedResolver.resolve$lambda$0(resolve.1.INSTANCE, arg_0)).add(mappedElement);
            }
            reverse.put(mappedElement, window2);
        }
        ValuesOrderResolver.Result result2 = ValuesOrderResolver.Result.of((Map)direct, (Map)reverse);
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"of(direct, reverse)");
        return result2;
    }

    private final int calcWindowSize(int[] before2, int[] after) {
        int size;
        for (size = 0; size < before2.length && before2[size] < after[0]; ++size) {
        }
        return size;
    }

    /*
     * WARNING - void declaration
     */
    private final ValuesOrderResolver.Result emptyTransitions(Map<Integer, TraceElement> indexBefore) {
        void $this$associateTo$iv$iv;
        Sequence $this$sortedBy$iv = MapsKt.asSequence(indexBefore);
        boolean $i$f$sortedBy = false;
        Sequence $this$associate$iv = SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Integer)it.getKey();
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getKey()));
            }
        });
        boolean $i$f$associate = false;
        Sequence sequence2 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to(it.getValue(), (Object)CollectionsKt.emptyList());
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Map direct = destination$iv$iv;
        ValuesOrderResolver.Result result2 = ValuesOrderResolver.Result.of((Map)direct, (Map)MapsKt.emptyMap());
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"of(direct, emptyMap())");
        return result2;
    }

    private static final List resolve$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }
}

