/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto;

import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.psi.PsiElement;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinMethodFilterKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a(\u0010\u0000\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0014\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u001a\u001c\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\rH\u0002\u00a8\u0006\u0011"}, d2={"getMethodDescriptorAndDeclaration", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "positionManager", "Lcom/intellij/debugger/PositionManager;", "location", "Lcom/sun/jdi/Location;", "getMethodNameInCallerFrame", "", "frameProxy", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "isInlinedFromFunction", "", "Lcom/sun/jdi/LocalVariable;", "methodName", "isNameMangledInBytecode", "kotlin.jvm-debugger.core-fe10"})
public final class KotlinMethodFilterKt {
    private static final Pair<DeclarationDescriptor, KtDeclaration> getMethodDescriptorAndDeclaration(PositionManager positionManager, Location location2) {
        Pair pair;
        KtDeclaration declaration2;
        PsiElement elementAt;
        Method method = SafeUtilKt.safeMethod(location2);
        String string2 = method != null ? method.name() : null;
        if (string2 == null) {
            return TuplesKt.to(null, null);
        }
        String actualMethodName = string2;
        SourcePosition sourcePosition2 = positionManager.getSourcePosition(location2);
        PsiElement psiElement2 = elementAt = sourcePosition2 != null ? sourcePosition2.getElementAt() : null;
        if (psiElement2 != null) {
            Class[] classArray = new Class[]{KtDeclaration.class};
            v4 = (KtDeclaration)PsiUtilsKt.getParentOfTypesAndPredicate((PsiElement)psiElement2, (boolean)false, (Class[])classArray, (Function1)getMethodDescriptorAndDeclaration.declaration.1.INSTANCE);
        } else {
            v4 = declaration2 = null;
        }
        if (declaration2 instanceof KtClass && Intrinsics.areEqual((Object)actualMethodName, (Object)"<init>")) {
            ClassDescriptor classDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default((KtClassOrObject)declaration2, null, 1, null);
            pair = TuplesKt.to((Object)(classDescriptor != null ? classDescriptor.getUnsubstitutedPrimaryConstructor() : null), (Object)declaration2);
        } else {
            KtDeclaration ktDeclaration = declaration2;
            pair = TuplesKt.to((Object)(ktDeclaration != null ? ResolutionUtils.resolveToDescriptorIfAny$default(ktDeclaration, null, 1, null) : null), (Object)declaration2);
        }
        return pair;
    }

    private static final boolean isInlinedFromFunction(LocalVariable $this$isInlinedFromFunction, String methodName2, boolean isNameMangledInBytecode) {
        String string2 = $this$isInlinedFromFunction.name();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name()");
        String variableName = DebuggerUtils.INSTANCE.trimIfMangledInBytecode(string2, isNameMangledInBytecode);
        return StringsKt.startsWith$default((String)variableName, (String)"$i$f$", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)StringsKt.substringAfter$default((String)variableName, (String)"$i$f$", null, (int)2, null), (Object)methodName2);
    }

    private static final String getMethodNameInCallerFrame(StackFrameProxyImpl frameProxy) {
        StackFrameProxyImpl stackFrameProxyImpl = frameProxy;
        if (stackFrameProxyImpl == null || (stackFrameProxyImpl = stackFrameProxyImpl.threadProxy()) == null) {
            return null;
        }
        StackFrameProxyImpl threadProxy = stackFrameProxyImpl;
        int callerFrameIndex = frameProxy.getFrameIndex() + 1;
        if (callerFrameIndex >= threadProxy.frameCount()) {
            return null;
        }
        StackFrameProxyImpl callerFrame = threadProxy.frame(callerFrameIndex);
        Object object = callerFrame;
        return object != null && (object = SafeUtilKt.safeLocation((StackFrameProxy)object)) != null && (object = SafeUtilKt.safeMethod((Location)object)) != null ? object.name() : null;
    }

    public static final /* synthetic */ Pair access$getMethodDescriptorAndDeclaration(PositionManager positionManager, Location location2) {
        return KotlinMethodFilterKt.getMethodDescriptorAndDeclaration(positionManager, location2);
    }

    public static final /* synthetic */ String access$getMethodNameInCallerFrame(StackFrameProxyImpl frameProxy) {
        return KotlinMethodFilterKt.getMethodNameInCallerFrame(frameProxy);
    }

    public static final /* synthetic */ boolean access$isInlinedFromFunction(LocalVariable $receiver, String methodName2, boolean isNameMangledInBytecode) {
        return KotlinMethodFilterKt.isInlinedFromFunction($receiver, methodName2, isNameMangledInBytecode);
    }
}

