/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.configuration.kpm;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtilRt;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.idea.kpm.IdeaKpmFragment;
import org.jetbrains.kotlin.gradle.idea.kpm.IdeaKpmFragmentKt;
import org.jetbrains.kotlin.gradle.idea.kpm.IdeaKpmModule;
import org.jetbrains.kotlin.idea.gradle.configuration.kpm.ModuleDataInitializer;
import org.jetbrains.kotlin.idea.gradleJava.configuration.kpm.KotlinFragmentUtilKt;
import org.jetbrains.kotlin.idea.gradleJava.configuration.kpm.KotlinGradleSourceSetDataInitializer;
import org.jetbrains.plugins.gradle.model.DefaultExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.model.DefaultExternalSourceSet;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;

@Order(value=1001)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J<\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/configuration/kpm/KotlinGradleSourceSetDataInitializer;", "Lorg/jetbrains/kotlin/idea/gradle/configuration/kpm/ModuleDataInitializer;", "()V", "createExternalSourceSet", "Lorg/jetbrains/plugins/gradle/model/ExternalSourceSet;", "fragment", "Lorg/jetbrains/kotlin/gradle/idea/kpm/IdeaKpmFragment;", "gradleSourceSetData", "Lorg/jetbrains/plugins/gradle/model/data/GradleSourceSetData;", "initialize", "", "gradleModule", "Lorg/gradle/tooling/model/idea/IdeaModule;", "mainModuleNode", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "projectDataNode", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "resolverCtx", "Lorg/jetbrains/plugins/gradle/service/project/ProjectResolverContext;", "initializerContext", "Lorg/jetbrains/kotlin/idea/gradle/configuration/kpm/ModuleDataInitializer$Context;", "Companion", "kotlin.gradle.gradle-java"})
@SourceDebugExtension(value={"SMAP\nKotlinGradleSourceSetDataInitializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinGradleSourceSetDataInitializer.kt\norg/jetbrains/kotlin/idea/gradleJava/configuration/kpm/KotlinGradleSourceSetDataInitializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,148:1\n1271#2,2:149\n1285#2,4:151\n*S KotlinDebug\n*F\n+ 1 KotlinGradleSourceSetDataInitializer.kt\norg/jetbrains/kotlin/idea/gradleJava/configuration/kpm/KotlinGradleSourceSetDataInitializer\n*L\n35#1:149,2\n35#1:151,4\n*E\n"})
public final class KotlinGradleSourceSetDataInitializer
implements ModuleDataInitializer {
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    public void initialize(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> mainModuleNode, @NotNull DataNode<ProjectData> projectDataNode, @NotNull ProjectResolverContext resolverCtx, @NotNull ModuleDataInitializer.Context initializerContext) {
        LinkedHashMap result$iv;
        Intrinsics.checkNotNullParameter((Object)gradleModule, (String)"gradleModule");
        Intrinsics.checkNotNullParameter(mainModuleNode, (String)"mainModuleNode");
        Intrinsics.checkNotNullParameter(projectDataNode, (String)"projectDataNode");
        Intrinsics.checkNotNullParameter((Object)resolverCtx, (String)"resolverCtx");
        Intrinsics.checkNotNullParameter((Object)initializerContext, (String)"initializerContext");
        Object object = projectDataNode.getUserData(GradleProjectResolver.RESOLVED_SOURCE_SETS);
        Intrinsics.checkNotNull((Object)object);
        Map sourceSetMap = (Map)object;
        Object object2 = resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
        Intrinsics.checkNotNull((Object)object2);
        ExternalProject externalProject = (ExternalProject)object2;
        Object object3 = initializerContext.getModel();
        if (object3 != null && (object3 = object3.getModules()) != null) {
            Iterable $this$associateWith$iv = (Iterable)object3;
            boolean $i$f$associateWith = false;
            result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                IdeaKpmModule ideaKpmModule = (IdeaKpmModule)element$iv$iv;
                Object t = element$iv$iv;
                Map map2 = result$iv;
                boolean bl = false;
                List list2 = it.getFragments();
                map2.put(t, list2);
            }
        } else {
            return;
        }
        Map fragmentsByModules = result$iv;
        for (Map.Entry entry : fragmentsByModules.entrySet()) {
            IdeaKpmModule module2 = (IdeaKpmModule)entry.getKey();
            List fragments = (List)entry.getValue();
            for (IdeaKpmFragment fragment : fragments) {
                DataNode fragmentDataNode;
                DataNode fragmentData;
                String fragmentModuleId = KotlinFragmentUtilKt.calculateKotlinFragmentModuleId(gradleModule, fragment.getCoordinates(), resolverCtx);
                com.intellij.openapi.util.Pair pair = (com.intellij.openapi.util.Pair)sourceSetMap.get(fragmentModuleId);
                DataNode existingSourceSetDataNode = pair != null ? (DataNode)pair.first : null;
                String moduleExternalName = KotlinGradleSourceSetDataInitializer.Companion.calculateFragmentExternalModuleName(gradleModule, fragment);
                String moduleInternalName = KotlinGradleSourceSetDataInitializer.Companion.calculateFragmentInternalModuleName(gradleModule, externalProject, fragment, resolverCtx);
                DataNode dataNode = existingSourceSetDataNode;
                if (dataNode == null || (dataNode = (GradleSourceSetData)dataNode.getData()) == null) {
                    GradleSourceSetData gradleSourceSetData;
                    String string2;
                    String string3 = initializerContext.getMainModuleFileDirectoryPath();
                    if (string3 == null) {
                        string3 = "";
                    }
                    if ((string2 = initializerContext.getMainModuleConfigPath()) == null) {
                        string2 = "";
                    }
                    GradleSourceSetData it = gradleSourceSetData = new GradleSourceSetData(fragmentModuleId, moduleExternalName, moduleInternalName, string3, string2);
                    boolean bl = false;
                    it.setGroup(externalProject.getGroup());
                    it.setVersion(externalProject.getVersion());
                    String string4 = module2.getCoordinates().getModuleName();
                    if (Intrinsics.areEqual((Object)string4, (Object)"main")) {
                        it.setPublication((ProjectCoordinate)new ProjectId(externalProject.getGroup(), externalProject.getName(), externalProject.getVersion()));
                    } else if (Intrinsics.areEqual((Object)string4, (Object)"test")) {
                        it.setProductionModuleId(moduleInternalName);
                    }
                    it.setIdeModuleGroup(initializerContext.getModuleGroup());
                    it.setSdkName(initializerContext.getJdkName());
                    dataNode = fragmentData = gradleSourceSetData;
                }
                if (existingSourceSetDataNode != null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)mainModuleNode.createChild(GradleSourceSetData.KEY, (Object)fragmentData), (String)"mainModuleNode.createChi\u2026etData.KEY, fragmentData)");
                sourceSetMap.put(fragmentModuleId, new com.intellij.openapi.util.Pair((Object)fragmentDataNode, (Object)this.createExternalSourceSet(fragment, (GradleSourceSetData)fragmentData)));
            }
        }
    }

    private final ExternalSourceSet createExternalSourceSet(IdeaKpmFragment fragment, GradleSourceSetData gradleSourceSetData) {
        DefaultExternalSourceDirectorySet dirSet;
        DefaultExternalSourceDirectorySet defaultExternalSourceDirectorySet;
        DefaultExternalSourceSet defaultExternalSourceSet;
        DefaultExternalSourceSet sourceSet = defaultExternalSourceSet = new DefaultExternalSourceSet();
        boolean bl = false;
        sourceSet.setName(IdeaKpmFragmentKt.getName((IdeaKpmFragment)fragment));
        sourceSet.setTargetCompatibility(gradleSourceSetData.getTargetCompatibility());
        Pair[] pairArray = sourceSet.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)pairArray, (String)"sourceSet.dependencies");
        Pair[] pairArray2 = pairArray;
        CollectionsKt.addAll((Collection)pairArray2, (Iterable)CollectionsKt.emptyList());
        pairArray2 = new Pair[2];
        DefaultExternalSourceDirectorySet defaultExternalSourceDirectorySet2 = defaultExternalSourceDirectorySet = new DefaultExternalSourceDirectorySet();
        ExternalSystemSourceType externalSystemSourceType = KotlinFragmentUtilKt.computeSourceType(fragment);
        int n = 0;
        Pair[] pairArray3 = pairArray2;
        DefaultExternalSourceSet defaultExternalSourceSet2 = sourceSet;
        boolean bl2 = false;
        dirSet.setSrcDirs(CollectionsKt.toSet((Iterable)KotlinFragmentUtilKt.getSourceDirs(fragment)));
        Unit unit2 = Unit.INSTANCE;
        pairArray3[n] = TuplesKt.to((Object)externalSystemSourceType, (Object)defaultExternalSourceDirectorySet);
        dirSet = defaultExternalSourceDirectorySet = new DefaultExternalSourceDirectorySet();
        externalSystemSourceType = KotlinFragmentUtilKt.computeResourceType(fragment);
        n = 1;
        pairArray3 = pairArray2;
        boolean bl3 = false;
        dirSet.setSrcDirs(CollectionsKt.toSet((Iterable)KotlinFragmentUtilKt.getResourceDirs(fragment)));
        unit2 = Unit.INSTANCE;
        pairArray3[n] = TuplesKt.to((Object)externalSystemSourceType, (Object)defaultExternalSourceDirectorySet);
        defaultExternalSourceSet2.setSources(MapsKt.toMap((Map)MapsKt.linkedMapOf((Pair[])pairArray2)));
        return (ExternalSourceSet)defaultExternalSourceSet;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J(\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/configuration/kpm/KotlinGradleSourceSetDataInitializer$Companion;", "", "()V", "calculateFragmentExternalModuleName", "", "gradleModule", "Lorg/gradle/tooling/model/idea/IdeaModule;", "fragment", "Lorg/jetbrains/kotlin/gradle/idea/kpm/IdeaKpmFragment;", "calculateFragmentInternalModuleName", "externalProject", "Lorg/jetbrains/plugins/gradle/model/ExternalProject;", "resolverCtx", "Lorg/jetbrains/plugins/gradle/service/project/ProjectResolverContext;", "gradlePathToQualifiedName", "rootName", "gradlePath", "kotlin.gradle.gradle-java"})
    @SourceDebugExtension(value={"SMAP\nKotlinGradleSourceSetDataInitializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinGradleSourceSetDataInitializer.kt\norg/jetbrains/kotlin/idea/gradleJava/configuration/kpm/KotlinGradleSourceSetDataInitializer$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,148:1\n37#2,2:149\n*S KotlinDebug\n*F\n+ 1 KotlinGradleSourceSetDataInitializer.kt\norg/jetbrains/kotlin/idea/gradleJava/configuration/kpm/KotlinGradleSourceSetDataInitializer$Companion\n*L\n122#1:149,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final String calculateFragmentExternalModuleName(IdeaModule gradleModule, IdeaKpmFragment fragment) {
            return gradleModule.getName() + ":" + fragment.getCoordinates().getModule().getModuleName() + "." + IdeaKpmFragmentKt.getName((IdeaKpmFragment)fragment);
        }

        private final String calculateFragmentInternalModuleName(IdeaModule gradleModule, ExternalProject externalProject, IdeaKpmFragment fragment, ProjectResolverContext resolverCtx) {
            String delimiter = null;
            StringBuilder moduleName2 = new StringBuilder();
            String buildSrcGroup = resolverCtx.getBuildSrcGroup();
            if (resolverCtx.isUseQualifiedModuleNames()) {
                delimiter = ".";
                if (StringUtil.isNotEmpty((String)buildSrcGroup)) {
                    moduleName2.append(buildSrcGroup).append(delimiter);
                }
                String string2 = gradleModule.getProject().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"gradleModule.project.name");
                String string3 = externalProject.getQName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"externalProject.qName");
                moduleName2.append(this.gradlePathToQualifiedName(string2, string3));
            } else {
                delimiter = "_";
                if (StringUtil.isNotEmpty((String)buildSrcGroup)) {
                    moduleName2.append(buildSrcGroup).append(delimiter);
                }
                moduleName2.append(gradleModule.getName());
            }
            moduleName2.append(delimiter);
            moduleName2.append(fragment.getCoordinates().getModule().getModuleName() + "." + IdeaKpmFragmentKt.getName((IdeaKpmFragment)fragment));
            String string4 = PathUtilRt.suggestFileName((String)moduleName2.toString(), (boolean)true, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"suggestFileName(moduleNa\u2026.toString(), true, false)");
            return string4;
        }

        private final String gradlePathToQualifiedName(String rootName, String gradlePath) {
            CharSequence charSequence2 = gradlePath;
            Regex regex = new Regex(":");
            int n = 0;
            Collection $this$toTypedArray$iv = regex.split(charSequence2, n);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return (String)(StringsKt.startsWith$default((String)gradlePath, (String)":", (boolean)false, (int)2, null) ? rootName + "." : "") + Arrays.stream(thisCollection$iv.toArray(new String[0])).filter(arg_0 -> Companion.gradlePathToQualifiedName$lambda$0(gradlePathToQualifiedName.1.INSTANCE, arg_0)).collect(Collectors.joining("."));
        }

        private static final boolean gradlePathToQualifiedName$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

