/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.scripting;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.autoimport.changes.vfs.VirtualFileChangesListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.KotlinPluginDisposable;
import org.jetbrains.kotlin.idea.core.script.configuration.listener.ScriptChangeListener;
import org.jetbrains.kotlin.idea.gradleJava.scripting.GradleScriptFileChangeListener;
import org.jetbrains.kotlin.idea.gradleJava.scripting.legacy.GradleLegacyScriptListener;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRootsManager;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0016\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000fJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bRA\u0010\t\u001a2\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u00110\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/scripting/GradleScriptListener;", "Lorg/jetbrains/kotlin/idea/core/script/configuration/listener/ScriptChangeListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "buildRootsManager", "Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootsManager;", "getBuildRootsManager", "()Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootsManager;", "fileChangesProcessor", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "filePath", "", "ts", "", "getFileChangesProcessor", "()Lkotlin/jvm/functions/Function2;", "legacy", "Lorg/jetbrains/kotlin/idea/gradleJava/scripting/legacy/GradleLegacyScriptListener;", "documentChanged", "vFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "editorActivated", "fileChanged", "isApplicable", "", "isCustomScriptingSupport", "kotlin.gradle.gradle-java"})
public final class GradleScriptListener
extends ScriptChangeListener {
    @NotNull
    private final GradleLegacyScriptListener legacy;

    public GradleScriptListener(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super(project2);
        this.legacy = new GradleLegacyScriptListener(project2);
        GradleScriptFileChangeListener listener2 = new GradleScriptFileChangeListener(this, this.getBuildRootsManager());
        VirtualFileChangesListener.Companion.installAsyncVirtualFileListener((VirtualFileChangesListener)listener2, (Disposable)KotlinPluginDisposable.Companion.getInstance(project2));
    }

    private final GradleBuildRootsManager getBuildRootsManager() {
        GradleBuildRootsManager gradleBuildRootsManager = GradleBuildRootsManager.Companion.getInstance(this.getProject());
        if (gradleBuildRootsManager == null) {
            throw new IllegalStateException("GradleBuildRootsManager not found".toString());
        }
        return gradleBuildRootsManager;
    }

    @NotNull
    public final Function2<String, Long, Unit> getFileChangesProcessor() {
        GradleBuildRootsManager buildRootsManager = this.getBuildRootsManager();
        return (Function2)new Function2<String, Long, Unit>(buildRootsManager){
            final /* synthetic */ GradleBuildRootsManager $buildRootsManager;
            {
                this.$buildRootsManager = $buildRootsManager;
                super(2);
            }

            public final void invoke(@NotNull String filePath, long ts) {
                Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
                this.$buildRootsManager.fileChanged(filePath, ts);
            }
        };
    }

    public final void fileChanged(@NotNull String filePath, long ts) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.getFileChangesProcessor().invoke((Object)filePath, (Object)ts);
    }

    @Override
    public boolean isApplicable(@NotNull VirtualFile vFile) {
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        return this.legacy.isApplicable(vFile);
    }

    private final boolean isCustomScriptingSupport(VirtualFile vFile) {
        return this.getBuildRootsManager().isApplicable(vFile);
    }

    @Override
    public void editorActivated(@NotNull VirtualFile vFile) {
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        if (this.isCustomScriptingSupport(vFile)) {
            this.getBuildRootsManager().updateNotifications(false, (Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>(vFile){
                final /* synthetic */ VirtualFile $vFile;
                {
                    this.$vFile = $vFile;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it, (Object)this.$vFile.getPath());
                }
            }));
        } else {
            this.legacy.editorActivated(vFile);
        }
    }

    @Override
    public void documentChanged(@NotNull VirtualFile vFile) {
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        String string2 = vFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"vFile.path");
        this.fileChanged(string2, System.currentTimeMillis());
        if (!this.isCustomScriptingSupport(vFile)) {
            this.legacy.documentChanged(vFile);
        }
    }
}

