/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.DeprecationCollectingInspection;
import org.jetbrains.kotlin.idea.inspections.ConvertObjectToDataObjectInspection;
import org.jetbrains.kotlin.idea.inspections.ConvertObjectToDataObjectInspectionKt;
import org.jetbrains.kotlin.idea.inspections.ConvertToDataObjectQuickFix;
import org.jetbrains.kotlin.idea.inspections.VirtualFunction;
import org.jetbrains.kotlin.idea.search.usagesSearch.SearchHelpersKt;
import org.jetbrains.kotlin.idea.statistics.InspectionData;
import org.jetbrains.kotlin.idea.statistics.KotlinLanguageFeaturesFUSCollector;
import org.jetbrains.kotlin.idea.statistics.NewAndDeprecatedFeaturesInspectionData;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConvertObjectToDataObjectInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/DeprecationCollectingInspection;", "Lorg/jetbrains/kotlin/idea/statistics/NewAndDeprecatedFeaturesInspectionData;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "ObjectVisitor", "kotlin.idea"})
public final class ConvertObjectToDataObjectInspection
extends DeprecationCollectingInspection<NewAndDeprecatedFeaturesInspectionData> {
    public ConvertObjectToDataObjectInspection() {
        super(KotlinLanguageFeaturesFUSCollector.Companion.getDataObjectCollector(), (InspectionData)new NewAndDeprecatedFeaturesInspectionData(false, false, 3, null));
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        PsiElementVisitor psiElementVisitor;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        PsiFile psiFile2 = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"holder.file");
        if (LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)psiFile2).supportsFeature(LanguageFeature.DataObjects)) {
            psiElementVisitor = (PsiElementVisitor)new ObjectVisitor(holder, session);
        } else {
            PsiElementVisitor psiElementVisitor2 = PsiElementVisitor.EMPTY_VISITOR;
            psiElementVisitor = psiElementVisitor2;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor2, (String)"EMPTY_VISITOR");
        }
        return psiElementVisitor;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b\u00b2\u0006\n\u0010\f\u001a\u00020\rX\u008a\u0084\u0002\u00b2\u0006\n\u0010\u000e\u001a\u00020\rX\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConvertObjectToDataObjectInspection$ObjectVisitor;", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "(Lorg/jetbrains/kotlin/idea/inspections/ConvertObjectToDataObjectInspection;Lcom/intellij/codeInspection/ProblemsHolder;Lcom/intellij/codeInspection/LocalInspectionToolSession;)V", "visitObjectDeclaration", "", "ktObject", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "kotlin.idea", "isSealedSubClassCase", "", "isToStringCase"})
    private final class ObjectVisitor
    extends KtVisitorVoid {
        @NotNull
        private final ProblemsHolder holder;
        @NotNull
        private final LocalInspectionToolSession session;

        public ObjectVisitor(@NotNull ProblemsHolder holder, LocalInspectionToolSession session) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            this.holder = holder;
            this.session = session;
        }

        public void visitObjectDeclaration(@NotNull KtObjectDeclaration ktObject) {
            Intrinsics.checkNotNullParameter((Object)ktObject, (String)"ktObject");
            if (ktObject.isData()) {
                ConvertObjectToDataObjectInspection.this.updateDeprecationData(this.session, visitObjectDeclaration.1.INSTANCE);
                return;
            }
            if (ktObject.isCompanion() || ktObject.isObjectLiteral()) {
                return;
            }
            Lazy fqName2 = LazyKt.lazy((Function0)((Function0)new Function0<FqName>(ktObject){
                final /* synthetic */ KtObjectDeclaration $ktObject;
                {
                    this.$ktObject = $ktObject;
                    super(0);
                }

                public final FqName invoke() {
                    DeclarationDescriptor declarationDescriptor = SearchHelpersKt.getDescriptor((KtDeclaration)this.$ktObject);
                    if (declarationDescriptor == null || (declarationDescriptor = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)declarationDescriptor)) == null) {
                        declarationDescriptor = FqName.ROOT;
                    }
                    return declarationDescriptor;
                }
            }));
            VirtualFunction toString2 = ConvertObjectToDataObjectInspectionKt.access$findToString(ktObject);
            Lazy isSealedSubClassCase$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(toString2, ktObject){
                final /* synthetic */ VirtualFunction $toString;
                final /* synthetic */ KtObjectDeclaration $ktObject;
                {
                    this.$toString = $toString;
                    this.$ktObject = $ktObject;
                    super(0);
                }

                @NotNull
                public final Boolean invoke() {
                    return Intrinsics.areEqual((Object)this.$toString, (Object)VirtualFunction.TrivialSuper.INSTANCE) && ConvertObjectToDataObjectInspectionKt.access$isSubclassOfSealed(this.$ktObject);
                }
            }));
            Lazy isToStringCase$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(toString2, ktObject, (Lazy<FqName>)fqName2){
                final /* synthetic */ VirtualFunction $toString;
                final /* synthetic */ KtObjectDeclaration $ktObject;
                final /* synthetic */ Lazy<FqName> $fqName;
                {
                    this.$toString = $toString;
                    this.$ktObject = $ktObject;
                    this.$fqName = $fqName;
                    super(0);
                }

                @NotNull
                public final Boolean invoke() {
                    return this.$toString instanceof VirtualFunction.Function && ConvertObjectToDataObjectInspectionKt.access$isCompatibleToString(this.$ktObject, this.$fqName, ((VirtualFunction.Function)this.$toString).getFunction());
                }
            }));
            if ((ObjectVisitor.visitObjectDeclaration$lambda$0((Lazy<Boolean>)isSealedSubClassCase$delegate) || ObjectVisitor.visitObjectDeclaration$lambda$1((Lazy<Boolean>)isToStringCase$delegate)) && ConvertObjectToDataObjectInspectionKt.access$isCompatibleHashCode(ktObject, fqName2) && ConvertObjectToDataObjectInspectionKt.access$isCompatibleEquals(ktObject, fqName2)) {
                ConvertObjectToDataObjectInspection.this.updateDeprecationData(this.session, visitObjectDeclaration.2.INSTANCE);
                PsiElement psiElement2 = ktObject.getObjectKeyword();
                if (psiElement2 == null) {
                    return;
                }
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new ConvertToDataObjectQuickFix()};
                this.holder.registerProblem(psiElement2, KotlinBundle.message(ObjectVisitor.visitObjectDeclaration$lambda$0((Lazy<Boolean>)isSealedSubClassCase$delegate) ? "inspection.message.sealed.object.can.be.converted.to.data.object" : "inspection.message.object.with.manual.tostring.can.be.converted.to.data.object", new Object[0]), localQuickFixArray);
            }
        }

        private static final boolean visitObjectDeclaration$lambda$0(Lazy<Boolean> $isSealedSubClassCase$delegate) {
            Lazy<Boolean> lazy = $isSealedSubClassCase$delegate;
            return (Boolean)lazy.getValue();
        }

        private static final boolean visitObjectDeclaration$lambda$1(Lazy<Boolean> $isToStringCase$delegate) {
            Lazy<Boolean> lazy = $isToStringCase$delegate;
            return (Boolean)lazy.getValue();
        }
    }
}

