/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RemoveRequireNotNullCallFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "functionName", "", "(Ljava/lang/String;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nRedundantRequireNotNullCallInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedundantRequireNotNullCallInspection.kt\norg/jetbrains/kotlin/idea/inspections/RemoveRequireNotNullCallFix\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,88:1\n142#2:89\n*S KotlinDebug\n*F\n+ 1 RedundantRequireNotNullCallInspection.kt\norg/jetbrains/kotlin/idea/inspections/RemoveRequireNotNullCallFix\n*L\n79#1:89\n*E\n"})
final class RemoveRequireNotNullCallFix
implements LocalQuickFix {
    @NotNull
    private final String functionName;

    public RemoveRequireNotNullCallFix(@NotNull String functionName) {
        Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
        this.functionName = functionName;
    }

    @NotNull
    public String getName() {
        Object[] objectArray = new Object[]{this.functionName};
        return KotlinBundle.message("remove.require.not.null.call.fix.text", objectArray);
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        KtExpression target2;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement2 = descriptor2.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"descriptor.psiElement");
        PsiElement $this$getStrictParentOfType$iv = psiElement2;
        boolean $i$f$getStrictParentOfType = false;
        KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallExpression.class, (boolean)true);
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression callExpression2 = ktCallExpression;
        List list2 = callExpression2.getValueArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"callExpression.valueArguments");
        KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.firstOrNull((List)list2);
        if (ktValueArgument == null || (ktValueArgument = ktValueArgument.getArgumentExpression()) == null) {
            return;
        }
        KtValueArgument argument2 = ktValueArgument;
        KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)((KtElement)callExpression2));
        KtExpression ktExpression = target2 = ktQualifiedExpression != null ? (KtExpression)ktQualifiedExpression : (KtExpression)callExpression2;
        if (BindingContextUtilsKt.isUsedAsExpression((KtElement)((KtElement)callExpression2), (BindingContext)ResolutionUtils.analyze((KtElement)callExpression2, BodyResolveMode.PARTIAL_WITH_CFA))) {
            target2.replace((PsiElement)argument2);
        } else {
            target2.delete();
        }
    }
}

