/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.suggested.UtilsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.inspections.RedundantSamConstructorInspection;
import org.jetbrains.kotlin.idea.quickfix.AddModifierFixFE10;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.sam.SamConversionResolverImplKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u0005H\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\f\u0010\u0014\u001a\u00020\r*\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddFunModifierFix;", "Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFixFE10;", "element", "Lorg/jetbrains/kotlin/psi/KtClass;", "elementName", "", "referrerCall", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "(Lorg/jetbrains/kotlin/psi/KtClass;Ljava/lang/String;Lcom/intellij/psi/SmartPsiElementPointer;)V", "getFamilyName", "getText", "invokeImpl", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "removeRedundantSamConstructor", "Companion", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nAddFunModifierFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddFunModifierFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddFunModifierFix\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n142#2:84\n142#2:86\n1#3:85\n*S KotlinDebug\n*F\n+ 1 AddFunModifierFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddFunModifierFix\n*L\n47#1:84\n48#1:86\n*E\n"})
public final class AddFunModifierFix
extends AddModifierFixFE10 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String elementName;
    @NotNull
    private final SmartPsiElementPointer<KtCallExpression> referrerCall;

    public AddFunModifierFix(@NotNull KtClass element3, @NotNull String elementName, @NotNull SmartPsiElementPointer<KtCallExpression> referrerCall) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)elementName, (String)"elementName");
        Intrinsics.checkNotNullParameter(referrerCall, (String)"referrerCall");
        KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)element3;
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.FUN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"FUN_KEYWORD");
        super(ktModifierListOwner, ktModifierKeywordToken);
        this.elementName = elementName;
        this.referrerCall = referrerCall;
    }

    @Override
    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.elementName};
        return KotlinBundle.message("add.fun.modifier.to.0", objectArray);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    protected void invokeImpl(@NotNull Project project2, @Nullable Editor editor2, @NotNull PsiFile file2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            super.invokeImpl(project2, editor2, file2);
            KtCallExpression ktCallExpression = (KtCallExpression)this.referrerCall.getElement();
            if (ktCallExpression == null) break block0;
            this.removeRedundantSamConstructor(ktCallExpression);
        }
    }

    private final void removeRedundantSamConstructor(KtCallExpression $this$removeRedundantSamConstructor) {
        Object object;
        block7: {
            block6: {
                List list2 = $this$removeRedundantSamConstructor.getLambdaArguments();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"lambdaArguments");
                if (CollectionsKt.singleOrNull((List)list2) == null) {
                    return;
                }
                PsiElement $this$getStrictParentOfType$iv = (PsiElement)$this$removeRedundantSamConstructor;
                boolean $i$f$getStrictParentOfType = false;
                object = (KtValueArgument)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtValueArgument.class, (boolean)true);
                if (object == null) break block6;
                KtValueArgument it = $i$f$getStrictParentOfType = object;
                boolean bl = false;
                object = Intrinsics.areEqual((Object)it.getArgumentExpression(), (Object)$this$removeRedundantSamConstructor) ? $i$f$getStrictParentOfType : null;
                if (object != null) break block7;
            }
            return;
        }
        KtValueArgument argument2 = object;
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)argument2;
        boolean $i$f$getStrictParentOfType = false;
        KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallExpression.class, (boolean)true);
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression parentCall2 = ktCallExpression;
        RedundantSamConstructorInspection.Companion.replaceSamConstructorCall($this$removeRedundantSamConstructor);
        if (PsiModificationUtilsKt.canMoveLambdaOutsideParentheses(parentCall2)) {
            ApplicationUtilsKt.runWriteActionIfPhysical((PsiElement)parentCall2, (Function0)new Function0<Unit>(parentCall2){
                final /* synthetic */ KtCallExpression $parentCall;
                {
                    this.$parentCall = $parentCall;
                    super(0);
                }

                public final void invoke() {
                    PsiModificationUtilsKt.moveFunctionLiteralOutsideParentheses(this.$parentCall);
                }
            });
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddFunModifierFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "isSamInterface", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "kotlin.idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private Companion() {
        }

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            DiagnosticWithParameters3 casted = (DiagnosticWithParameters3)Errors.RESOLUTION_TO_CLASSIFIER.cast((UnboundDiagnostic)diagnostic);
            PsiElement psiElement2 = casted.getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"casted.psiElement");
            KtReferenceExpression referrer = (KtReferenceExpression)psiElement2;
            if (LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)referrer).getLanguageVersion().compareTo((Enum)LanguageVersion.KOTLIN_1_4) < 0) {
                return null;
            }
            PsiElement psiElement3 = referrer.getParent();
            KtCallExpression ktCallExpression = psiElement3 instanceof KtCallExpression ? (KtCallExpression)psiElement3 : null;
            if (ktCallExpression == null) {
                return null;
            }
            KtCallExpression referrerCall = ktCallExpression;
            List list2 = referrerCall.getValueArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"referrerCall.valueArguments");
            if (!(CollectionsKt.singleOrNull((List)list2) instanceof KtLambdaArgument)) {
                return null;
            }
            Object object = casted.getA();
            ClassDescriptor classDescriptor = object instanceof ClassDescriptor ? (ClassDescriptor)object : null;
            if (classDescriptor == null) {
                return null;
            }
            ClassDescriptor referenceClassDescriptor = classDescriptor;
            if (referenceClassDescriptor.isFun() || !this.isSamInterface(referenceClassDescriptor)) {
                return null;
            }
            PsiElement psiElement4 = JvmIrUtilsKt.getPsiElement((DeclarationDescriptorWithSource)((DeclarationDescriptorWithSource)referenceClassDescriptor));
            KtClass ktClass2 = psiElement4 instanceof KtClass ? (KtClass)psiElement4 : null;
            if (ktClass2 == null) {
                return null;
            }
            KtClass referenceClass = ktClass2;
            String string2 = referenceClass.getName();
            if (string2 == null) {
                return null;
            }
            String referenceClassName = string2;
            return new AddFunModifierFix(referenceClass, referenceClassName, (SmartPsiElementPointer<KtCallExpression>)UtilsKt.createSmartPointer((PsiElement)((PsiElement)referrerCall)));
        }

        private final boolean isSamInterface(ClassDescriptor $this$isSamInterface) {
            if ($this$isSamInterface.getKind() != ClassKind.INTERFACE) {
                return false;
            }
            CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)CollectionsKt.singleOrNull((List)SamConversionResolverImplKt.getAbstractMembers((ClassDescriptor)$this$isSamInterface));
            if (callableMemberDescriptor == null) {
                return false;
            }
            CallableMemberDescriptor singleAbstractMember = callableMemberDescriptor;
            return singleAbstractMember instanceof SimpleFunctionDescriptor && ((SimpleFunctionDescriptor)singleAbstractMember).getTypeParameters().isEmpty();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

