/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.actions.KotlinAddImportAction;
import org.jetbrains.kotlin.idea.actions.KotlinAddImportActionKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.quickfix.ImportFixBase;
import org.jetbrains.kotlin.idea.quickfix.OrdinaryImportFixBase;
import org.jetbrains.kotlin.idea.util.CallTypeAndReceiver;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B+\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u0002H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/DelegateAccessorsImportFix;", "Lorg/jetbrains/kotlin/idea/quickfix/OrdinaryImportFixBase;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "importNames", "", "Lorg/jetbrains/kotlin/name/Name;", "solveSeveralProblems", "", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "(Lorg/jetbrains/kotlin/psi/KtExpression;Ljava/util/Collection;ZLorg/jetbrains/kotlin/diagnostics/Diagnostic;)V", "getImportNames", "()Ljava/util/Collection;", "createAction", "Lorg/jetbrains/kotlin/idea/actions/KotlinAddImportAction;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getCallTypeAndReceiver", "Lorg/jetbrains/kotlin/idea/util/CallTypeAndReceiver$DELEGATE;", "getReceiverTypeFromDiagnostic", "Lorg/jetbrains/kotlin/types/KotlinType;", "MyFactory", "kotlin.idea"})
public final class DelegateAccessorsImportFix
extends OrdinaryImportFixBase<KtExpression> {
    @NotNull
    public static final MyFactory MyFactory = new MyFactory(null);
    @NotNull
    private final Collection<Name> importNames;
    private final boolean solveSeveralProblems;
    @NotNull
    private final Diagnostic diagnostic;

    public DelegateAccessorsImportFix(@NotNull KtExpression element3, @NotNull Collection<Name> importNames, boolean solveSeveralProblems, @NotNull Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter(importNames, (String)"importNames");
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        super(element3, MyFactory);
        this.importNames = importNames;
        this.solveSeveralProblems = solveSeveralProblems;
        this.diagnostic = diagnostic;
    }

    @Override
    @NotNull
    protected Collection<Name> getImportNames() {
        return this.importNames;
    }

    @NotNull
    protected CallTypeAndReceiver.DELEGATE getCallTypeAndReceiver() {
        return new CallTypeAndReceiver.DELEGATE((KtExpression)this.getElement());
    }

    @Override
    @NotNull
    public KotlinAddImportAction createAction(@NotNull Project project2, @NotNull Editor editor2, @NotNull KtExpression element3) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (this.solveSeveralProblems) {
            return KotlinAddImportActionKt.createGroupedImportsAction(project2, editor2, (KtElement)element3, KotlinBundle.message("fix.import.kind.delegate.accessors", new Object[0]), this.getSuggestions());
        }
        return super.createAction(project2, editor2, element3);
    }

    @Override
    @Nullable
    protected KotlinType getReceiverTypeFromDiagnostic() {
        return this.diagnostic.getFactory() == Errors.DELEGATE_SPECIAL_FUNCTION_MISSING ? (KotlinType)((DiagnosticWithParameters3)Errors.DELEGATE_SPECIAL_FUNCTION_MISSING.cast((UnboundDiagnostic)this.diagnostic)).getB() : null;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0016J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/DelegateAccessorsImportFix$MyFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/ImportFixBase$FactoryWithUnresolvedReferenceQuickFix;", "()V", "createImportAction", "Lorg/jetbrains/kotlin/idea/quickfix/DelegateAccessorsImportFix;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "createImportActionsForAllProblems", "", "sameTypeDiagnostics", "", "importNames", "Lorg/jetbrains/kotlin/name/Name;", "diagnostics", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nAbstractImportFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractImportFix.kt\norg/jetbrains/kotlin/idea/quickfix/DelegateAccessorsImportFix$MyFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,995:1\n1549#2:996\n1620#2,3:997\n*S KotlinDebug\n*F\n+ 1 AbstractImportFix.kt\norg/jetbrains/kotlin/idea/quickfix/DelegateAccessorsImportFix$MyFactory\n*L\n744#1:996\n744#1:997,3\n*E\n"})
    public static final class MyFactory
    extends ImportFixBase.FactoryWithUnresolvedReferenceQuickFix {
        private MyFactory() {
        }

        /*
         * WARNING - void declaration
         */
        private final Collection<Name> importNames(Collection<? extends Diagnostic> diagnostics2) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = diagnostics2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String missingMethodSignature;
                void it;
                Diagnostic diagnostic = (Diagnostic)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)(it.getFactory() == Errors.DELEGATE_SPECIAL_FUNCTION_MISSING ? (String)((DiagnosticWithParameters3)Errors.DELEGATE_SPECIAL_FUNCTION_MISSING.cast((UnboundDiagnostic)it)).getA() : (String)((DiagnosticWithParameters2)Errors.DELEGATE_SPECIAL_FUNCTION_NONE_APPLICABLE.cast((UnboundDiagnostic)it)).getA()), (String)"if (it.factory === Error\u2026).a\n                    }");
                missingMethodSignature = missingMethodSignature;
                String string2 = OperatorNameConventions.GET_VALUE.getIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GET_VALUE.identifier");
                collection.add(StringsKt.startsWith$default((String)missingMethodSignature, (String)string2, (boolean)false, (int)2, null) ? OperatorNameConventions.GET_VALUE : OperatorNameConventions.SET_VALUE);
            }
            return CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)OperatorNameConventions.PROVIDE_DELEGATE));
        }

        @Nullable
        public DelegateAccessorsImportFix createImportAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            KtExpression ktExpression = psiElement2 instanceof KtExpression ? (KtExpression)psiElement2 : null;
            if (ktExpression == null) {
                return null;
            }
            KtExpression expression2 = ktExpression;
            Collection<Name> importNames = this.importNames(CollectionsKt.listOf((Object)diagnostic));
            return new DelegateAccessorsImportFix(expression2, importNames, false, diagnostic);
        }

        @NotNull
        public List<DelegateAccessorsImportFix> createImportActionsForAllProblems(@NotNull Collection<? extends Diagnostic> sameTypeDiagnostics) {
            Intrinsics.checkNotNullParameter(sameTypeDiagnostics, (String)"sameTypeDiagnostics");
            Diagnostic diagnostic = (Diagnostic)CollectionsKt.first((Iterable)sameTypeDiagnostics);
            PsiElement element3 = diagnostic.getPsiElement();
            KtExpression ktExpression = element3 instanceof KtExpression ? (KtExpression)element3 : null;
            if (ktExpression == null) {
                return CollectionsKt.emptyList();
            }
            KtExpression expression2 = ktExpression;
            Collection<Name> names2 = this.importNames(sameTypeDiagnostics);
            return CollectionsKt.listOf((Object)new DelegateAccessorsImportFix(expression2, names2, true, diagnostic));
        }

        public /* synthetic */ MyFactory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

